/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.input;

import com.ibm.aurora.rare.IInputManager;
import com.ibm.aurora.rare.core.inputs.InputManager;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.logging.LoggingManager;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelXMLSerializer;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import com.ibm.aurora.rare.smdrules.utils.SmdHelper;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AssociativeModelInputManager
extends InputManager {
    public static final String INPUT_SCOPE_TYPE_MODEL = "model";
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final IAssociativeModel mModel;
    private final Set<INode> mVisibleNodes;
    private final Set<INode> mRootNodes;
    private final LoggingManager mLoggingManager;
    private final Map<INode, INode> mDefaultAttributes;

    public AssociativeModelInputManager(IAssociativeModel model, Set<INode> visibleNodes) {
        this(model, visibleNodes, null);
    }

    public AssociativeModelInputManager(IAssociativeModel model, Set<INode> visibleNodes, ILogger logger) {
        this.mLoggingManager = new LoggingManager(logger);
        if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
            this.mLoggingManager.getLogger().beginSection((Object)"AssociativeModelInputManager Initializing");
            this.mLoggingManager.getLogger().beginSection((Object)"Model");
            AssociativeModelXMLSerializer ams = new AssociativeModelXMLSerializer(model);
            String smdModelStr = ams.process().asXML();
            this.mLoggingManager.getLogger().info((Object)smdModelStr);
            this.mLoggingManager.getLogger().endSection((Object)"Model");
            if (visibleNodes != null) {
                this.mLoggingManager.getLogger().beginSection((Object)"Visible Nodes");
                for (INode node : visibleNodes) {
                    this.mLoggingManager.getLogger().info((Object)("Node: " + node.getId() + " (" + node.getLabel() + ")"));
                }
                this.mLoggingManager.getLogger().endSection((Object)"Visible Nodes");
            }
        }
        this.mModel = model;
        this.mVisibleNodes = visibleNodes;
        this.mRootNodes = null == visibleNodes ? Collections.unmodifiableSet(this.extractRootNodes(model.getNodes(), null)) : Collections.unmodifiableSet(this.extractRootNodes(visibleNodes, null));
        this.setRootScope(new InputScopeList((IInputManager)this));
        AssociativeModelNodeScopeObject rootModelScope = this.createScopeObject(null);
        ((InputScopeList)this.getRootScope()).putScope(INPUT_SCOPE_TYPE_MODEL, rootModelScope);
        this.mDefaultAttributes = new HashMap<INode, INode>();
        if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
            this.mLoggingManager.getLogger().endSection((Object)"AssociativeModelInputManager Initializing");
        }
    }

    public AssociativeModelInputManager(IAssociativeModel model) {
        this(model, null);
    }

    public AssociativeModelNodeScopeObject createScopeObject(INode node) {
        return new AssociativeModelNodeScopeObject(this, node);
    }

    public boolean isNodeVisible(INode node) {
        return this.mVisibleNodes == null || this.mVisibleNodes.contains(node);
    }

    public Iterable<INode> getVisibleNodes() {
        if (null == this.mVisibleNodes) {
            return this.mModel.getNodes();
        }
        return this.mVisibleNodes;
    }

    public Set<INode> getRootNodes() {
        return this.mRootNodes;
    }

    public Set<INode> extractNodes(INode parentNode) {
        HashSet<INode> nodesInScope = new HashSet<INode>();
        for (IEdge edge : parentNode.getOutEdges(EMPTY_STRING_ARRAY)) {
            INode child;
            if (!edge.isWholePart() || !this.isNodeVisible(child = edge.getEnd())) continue;
            nodesInScope.add(child);
        }
        return nodesInScope;
    }

    public INode getDefaultAttribute(INode node) {
        INode attr = null;
        if (node != null && (attr = this.mDefaultAttributes.get(node)) == null) {
            attr = SmdHelper.getDefaultAttribute(node);
            this.mDefaultAttributes.put(node, attr);
        }
        return attr;
    }

    public INode getParent(INode childNode) {
        for (IEdge edge : childNode.getInEdges(EMPTY_STRING_ARRAY)) {
            INode parent;
            if (!edge.isWholePart() || !this.isNodeVisible(parent = edge.getStart())) continue;
            return parent;
        }
        return null;
    }

    protected Set<INode> extractRootNodes(Iterable<INode> nodes, List<String> excludedConcepts) {
        return SmdHelper.extractRootNodes(nodes, excludedConcepts);
    }

    protected LoggingManager getLoggingManager() {
        return this.mLoggingManager;
    }
}

