/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.input;

import com.ibm.aurora.rare.IInputManager;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelInputManager;
import com.ibm.aurora.rare.smdrules.utils.SmdHelper;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class AssociativeModelNodeScopeObject
extends InputScopeObject
implements IDataItemStats {
    public static final String PROP_DEFAULT_AGGREGATION = "defAggregate";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected final INode _node;
    private INode _defaultAttr;
    private final AssociativeModelInputManager _associativeModelInputManager;

    protected AssociativeModelNodeScopeObject() {
        super((IInputManager)null);
        this._associativeModelInputManager = null;
        this._node = null;
    }

    public AssociativeModelNodeScopeObject(AssociativeModelInputManager inputManager, INode node) {
        super((IInputManager)inputManager);
        this._node = node;
        this._associativeModelInputManager = inputManager;
        if (inputManager != null) {
            this._defaultAttr = inputManager.getDefaultAttribute(this._node);
        } else if (this._node != null) {
            this._defaultAttr = SmdHelper.getDefaultAttribute(this._node);
        }
    }

    public AssociativeModelNodeScopeObject(AssociativeModelNodeScopeObject obj) {
        super((InputScopeObject)obj);
        this._associativeModelInputManager = obj._associativeModelInputManager;
        this._node = obj._node;
    }

    public List<AssociativeModelNodeScopeObject> getNodes() {
        return this.getNodes(this._node);
    }

    public INode getModelNode() {
        return this._node;
    }

    private List<AssociativeModelNodeScopeObject> getNodes(INode inode) {
        AssociativeModelInputManager inputManager = this._associativeModelInputManager;
        Set<INode> nodeset = inode == null ? inputManager.getRootNodes() : inputManager.extractNodes(inode);
        ArrayList<AssociativeModelNodeScopeObject> nodes = new ArrayList<AssociativeModelNodeScopeObject>();
        for (INode node : nodeset) {
            if (!inputManager.isNodeVisible(node) || !node.isCategory() && !node.isMetric()) continue;
            AssociativeModelNodeScopeObject obj = inputManager.createScopeObject(node);
            nodes.add(obj);
        }
        return nodes;
    }

    public String getDefaultAttributeValue() {
        return this._defaultAttr.getLabel();
    }

    public INode getDefaultAttribute() {
        return this._defaultAttr;
    }

    public String getProperty(String name) {
        Object property = this._node.getProperty(name);
        if (property != null) {
            return property.toString();
        }
        return null;
    }

    public boolean hasNode() {
        return this._node != null;
    }

    public String getDataItemProperty(String name) {
        IValue property;
        IDataItem dataItem = this.getDataItem();
        if (dataItem != null && (property = dataItem.getProperty(name)) != null) {
            return property.toString();
        }
        return null;
    }

    public IDataItem getDataItem() {
        IDataItem dataItem;
        block1: {
            IEdge edge;
            INode endNode;
            dataItem = this._node.getDataItem();
            if (dataItem != null) break block1;
            Iterable edgeItr = this._node.getOutEdges(EMPTY_STRING_ARRAY);
            Iterator i$ = edgeItr.iterator();
            while (i$.hasNext() && (dataItem = (endNode = (edge = (IEdge)i$.next()).getEnd()).getDataItem()) == null) {
            }
        }
        return dataItem;
    }

    public List<INode> getAttributes() {
        return NavigationHelper.getAttributeNodes((INode)this._node);
    }

    public String getAttributeValueByConcept(String conceptName) {
        List<INode> nodes = this.getAttributes();
        if (nodes != null) {
            for (INode node : nodes) {
                if (!node.getConcept().is(conceptName)) continue;
                return node.getLabel();
            }
        }
        return null;
    }

    public boolean isOfConcept(String concept) {
        if (concept == null) {
            return true;
        }
        boolean reversed = false;
        String sonceptString = concept;
        if (concept.charAt(0) == '~') {
            sonceptString = concept.substring(1);
            reversed = true;
        }
        StringTokenizer tokenizer = new StringTokenizer(sonceptString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String singleConcept = tokenizer.nextToken();
            if (this._node.getConcept().isA(singleConcept)) {
                return !reversed;
            }
            if (!this._node.getConcept().is(singleConcept)) continue;
            return !reversed;
        }
        return reversed;
    }

    public IConcept getConcept() {
        return this._node.getConcept();
    }

    public float getConfidence() {
        return this._node.getConfidenceLevel();
    }

    public String getNodeId() {
        return this._node.getId();
    }

    public boolean isAttribute() {
        return this._node.isAttribute();
    }

    public boolean isMetric() {
        return this._node.isMetric();
    }

    public boolean isCategory() {
        return this._node.isCategory();
    }

    public float density() {
        return this._defaultAttr.getDataItem().getStats().density();
    }

    public boolean isNullable() {
        return this._defaultAttr.getDataItem().getStats().isNullable();
    }

    public long nullCount() {
        return this._defaultAttr.getDataItem().getStats().nullCount();
    }

    public long distinctCount() {
        return this._defaultAttr.getDataItem().getStats().distinctCount();
    }

    public boolean checkDistinctCount(long min, long max) {
        long distinctCount = this.distinctCount();
        return distinctCount >= min && distinctCount <= max;
    }

    public long count() {
        return this._defaultAttr.getDataItem().getStats().count();
    }

    public long totalCount() {
        return this._defaultAttr.getDataItem().getStats().totalCount();
    }

    public IValue maxValue() {
        return this._defaultAttr.getDataItem().getStats().maxValue();
    }

    public IValue minValue() {
        return this._defaultAttr.getDataItem().getStats().minValue();
    }

    public String getDefaultAggregation() {
        if (this.isMetric()) {
            return this._node.getConcept().getProperty(PROP_DEFAULT_AGGREGATION);
        }
        return null;
    }

    public List<AssociativeModelNodeScopeObject> getReferentNodes(String referingPropertyName) {
        String name;
        HashSet<AssociativeModelNodeScopeObject> referentNodes = null;
        if (null != this._defaultAttr && null != (name = this._defaultAttr.getDataItem().getName())) {
            for (INode candidate : this._associativeModelInputManager.getVisibleNodes()) {
                IValue referingPropertyValue;
                IDataItem dataItem = candidate.getDataItem();
                if (null == dataItem || null == (referingPropertyValue = dataItem.getProperty(referingPropertyName)) || !name.equals(referingPropertyValue.stringValue())) continue;
                if (null == referentNodes) {
                    referentNodes = new HashSet<AssociativeModelNodeScopeObject>();
                }
                referentNodes.add(new AssociativeModelNodeScopeObject(this._associativeModelInputManager, candidate));
            }
        }
        if (null == referentNodes) {
            return Collections.emptyList();
        }
        return new ArrayList<AssociativeModelNodeScopeObject>(referentNodes);
    }

    public List<AssociativeModelNodeScopeObject> getSiblingNodes() {
        if (this._node != null) {
            INode parent = this._associativeModelInputManager.getParent(this._node);
            return this.getNodes(parent);
        }
        return Collections.emptyList();
    }

    public InputScopeObject clone() {
        return new AssociativeModelNodeScopeObject(this);
    }

    public boolean equals(Object scopeObj) {
        if (this == scopeObj) {
            return true;
        }
        if (!(scopeObj instanceof AssociativeModelNodeScopeObject)) {
            return false;
        }
        AssociativeModelNodeScopeObject obj = (AssociativeModelNodeScopeObject)((Object)scopeObj);
        return this._node == obj._node && this._associativeModelInputManager == obj._associativeModelInputManager;
    }

    public String toString() {
        return "AssociativeModelNodeScopeObject_" + (null != this._node ? this._node.toString() : "_node_Is_Null");
    }

    public boolean isInDateHierarchy() {
        return null != MetadataHelper.getDateHierarchyRoot((INode)this._node);
    }
}

