/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.input;

import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class AssociativeModelScopeIterator
implements Iterator<InputScopeObject> {
    private InputScopeList _next = null;
    private Iterator<InputScopeList> _itr = null;
    private String _concept = null;
    private Set<String> _inclusionsSet = null;
    private Set<String> _exclusionsSet = null;

    public AssociativeModelScopeIterator(InputScopeObject input) {
        this(input, null, null, null);
    }

    public AssociativeModelScopeIterator(InputScopeObject input, String concept) {
        this(input, concept, null, null);
    }

    public AssociativeModelScopeIterator(InputScopeObject input, String concept, String inclusions, String exclusions) {
        AssociativeModelNodeScopeObject model;
        List<InputScopeList> list;
        if (inclusions != null) {
            this._inclusionsSet = AssociativeModelScopeIterator.generateSet(inclusions);
        }
        if (exclusions != null) {
            this._exclusionsSet = AssociativeModelScopeIterator.generateSet(exclusions);
        }
        this._concept = concept;
        InputScopeObject amScopeObject = input;
        if (InputScopeList.class.isInstance(input)) {
            amScopeObject = ((InputScopeList)input).getScope("model");
        }
        if (amScopeObject instanceof AssociativeModelNodeScopeObject && (list = AssociativeModelScopeIterator.createListScopeObjects((InputScopeList)input, (model = (AssociativeModelNodeScopeObject)amScopeObject).getNodes())) != null) {
            for (InputScopeList node : list) {
                if (!AssociativeModelScopeIterator.isOfConcept(node, concept) || !AssociativeModelScopeIterator.passesFilters(this._inclusionsSet, this._exclusionsSet, node)) continue;
                this._next = node;
                break;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this._next != null;
    }

    @Override
    public InputScopeList next() {
        if (this.hasNext()) {
            InputScopeList current = this._next;
            this._next = null;
            if (this._itr != null) {
                while (this._itr.hasNext()) {
                    InputScopeList node = this._itr.next();
                    if (!AssociativeModelScopeIterator.isOfConcept(node, this._concept) || !AssociativeModelScopeIterator.passesFilters(this._inclusionsSet, this._exclusionsSet, node)) continue;
                    this._next = node;
                    break;
                }
            }
            if (InputScopeList.class.isInstance((Object)current)) {
                return current;
            }
        }
        return null;
    }

    public static List<InputScopeList> createListScopeObjects(InputScopeList listScope, List<AssociativeModelNodeScopeObject> modelScopes) {
        ArrayList<InputScopeList> listScopes = new ArrayList<InputScopeList>();
        for (AssociativeModelNodeScopeObject modelScope : modelScopes) {
            listScopes.add(AssociativeModelScopeIterator.createListScopeObject(listScope, modelScope));
        }
        return listScopes;
    }

    public static InputScopeList createListScopeObject(InputScopeList listScope, AssociativeModelNodeScopeObject modelScope) {
        InputScopeList scopeList = (InputScopeList)listScope.clone();
        scopeList.putScope("model", modelScope);
        return scopeList;
    }

    public static boolean isOfConcept(InputScopeObject scope, String concept) {
        AssociativeModelNodeScopeObject modelScope = AssociativeModelScopeIterator.getAssociativeModelNode(scope);
        if (modelScope != null) {
            return modelScope.isOfConcept(concept);
        }
        return false;
    }

    private static AssociativeModelNodeScopeObject getAssociativeModelNode(InputScopeObject scope) {
        InputScopeObject currentScope = scope;
        if (InputScopeList.class.isInstance(scope)) {
            currentScope = ((InputScopeList)scope).getScope("model");
        }
        return AssociativeModelNodeScopeObject.class.isInstance(currentScope) ? (AssociativeModelNodeScopeObject)currentScope : null;
    }

    public static boolean passesFilters(Set<String> inclusionsSet, Set<String> exclusionsSet, InputScopeList node) {
        if (inclusionsSet == null && exclusionsSet == null) {
            return true;
        }
        AssociativeModelNodeScopeObject modelScope = AssociativeModelScopeIterator.getAssociativeModelNode(node);
        if (modelScope != null) {
            Iterator<String> i$;
            boolean passes = true;
            if (inclusionsSet != null) {
                String inclusion;
                i$ = inclusionsSet.iterator();
                while (i$.hasNext() && (passes = AssociativeModelScopeIterator.checkProperty(modelScope, inclusion = i$.next()))) {
                }
            }
            if (passes && exclusionsSet != null) {
                String exclusion;
                i$ = exclusionsSet.iterator();
                while (i$.hasNext() && (passes = !AssociativeModelScopeIterator.checkProperty(modelScope, exclusion = i$.next()))) {
                }
            }
            return passes;
        }
        return true;
    }

    private static boolean checkProperty(AssociativeModelNodeScopeObject nodeScopeObj, String prop) {
        String propValue = nodeScopeObj.getDataItemProperty(prop);
        if (propValue != null) {
            return !"false".equals(propValue);
        }
        return false;
    }

    private static Set<String> generateSet(String items) {
        HashSet<String> itemsSet = new HashSet<String>();
        if (items != null) {
            StringTokenizer itemsTokens = new StringTokenizer(items, ",", false);
            while (itemsTokens.hasMoreTokens()) {
                itemsSet.add(itemsTokens.nextToken());
            }
        }
        return itemsSet;
    }

    @Override
    public void remove() {
    }
}

