/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.output;

import com.ibm.aurora.rare.core.exception.OutputResolutionException;
import com.ibm.aurora.rare.core.exception.XMLParsingException;
import com.ibm.aurora.rare.core.output.OutputManager;
import com.ibm.aurora.rare.core.utils.Pair;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.logging.LoggingManager;
import com.ibm.aurora.rare.smdrules.utils.MessageManager;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class LocalizableOutputManager
extends OutputManager {
    private static final String LOCALIZATION_PREFIX = "MSG.";
    private static final String LOCALIZATION_POSTFIX = ".MSG";
    private static final String SECTION_TEXT = "text";
    private static final String SECTION_TEXT_TAG = "<text>";
    private static final String SECTION_PARAMETERS = "parameters";
    private static final String SECTION_PARAMETER = "parameter";
    private static final String SECTION_ROOT = "root";
    private final String _locale;
    private final XMLHelperD4J _xmlHelper = new XMLHelperD4J();
    private final LoggingManager mLoggingManager;

    public LocalizableOutputManager(String locale, String messageFile) {
        this(locale, messageFile, null);
    }

    public LocalizableOutputManager(String locale, String messageFile, ILogger logger) {
        this._locale = locale;
        this.mLoggingManager = new LoggingManager(logger);
        if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
            this.mLoggingManager.getLogger().beginSection((Object)"LocalizableOutputManager Initializing");
            this.mLoggingManager.getLogger().info((Object)("Locale: " + locale));
            this.mLoggingManager.getLogger().info((Object)("Message File: " + messageFile));
        }
        if (messageFile != null) {
            MessageManager.initialize();
            MessageManager.addMessageFile(messageFile);
        }
        if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
            this.mLoggingManager.getLogger().endSection((Object)"LocalizableOutputManager Initializing");
        }
    }

    public StringBuilder resolveOutput(StringBuilder resolvedTemplate, String outputName) throws OutputResolutionException {
        StringBuilder resolvedOutput = super.resolveOutput(resolvedTemplate, outputName);
        try {
            resolvedOutput = new StringBuilder(this.localizeString(resolvedOutput.toString()));
        }
        catch (XMLParsingException xmlpe) {
            throw new OutputResolutionException((Exception)((Object)xmlpe));
        }
        return resolvedOutput;
    }

    public String localizeString(String input) throws XMLParsingException, OutputResolutionException {
        input = input.trim();
        boolean containsTextTag = true;
        for (int i = 0; i < SECTION_TEXT_TAG.length() && i < input.length() && containsTextTag; ++i) {
            if (input.charAt(i) == SECTION_TEXT_TAG.charAt(i)) continue;
            containsTextTag = false;
        }
        if (containsTextTag) {
            XMLHelperD4J xmlHelper = this.getXMLHelper();
            Document xmlDoc = XMLHelperD4J.getParsedDocument((String)("<root>" + input + "</" + SECTION_ROOT + ">"));
            Element root = xmlDoc.getRootElement();
            Element textTag = xmlHelper.getChildElement(root, SECTION_TEXT, null);
            Element parametersTag = xmlHelper.getChildElement(root, SECTION_PARAMETERS, null);
            List parameterTags = XMLHelperD4J.getChildElements((Element)parametersTag, (String)SECTION_PARAMETER, null);
            return this.replaceLocalizationTags(textTag.getText(), parameterTags);
        }
        return this.replaceLocalizationTags(input, Collections.<Element>emptyList());
    }

    private String replaceLocalizationTags(String input, List<Element> parameterTags) throws OutputResolutionException {
        String localizedString = "";
        String remaining = input;
        int indexOfPrefix = remaining.indexOf(LOCALIZATION_PREFIX);
        Object[] args = this.getArguments(parameterTags);
        if (indexOfPrefix != -1) {
            localizedString = localizedString + remaining.substring(0, indexOfPrefix);
            while (indexOfPrefix != -1) {
                Pair<String, Object[]> messageRemainingArgumentsPair;
                String token = (indexOfPrefix = (remaining = remaining.substring(indexOfPrefix + LOCALIZATION_PREFIX.length())).indexOf(LOCALIZATION_PREFIX)) == -1 ? remaining : remaining.substring(0, indexOfPrefix);
                int indexOfPostFix = token.indexOf(LOCALIZATION_POSTFIX);
                if (indexOfPostFix == -1) {
                    messageRemainingArgumentsPair = this.convert(token, args);
                    localizedString = localizedString + (String)messageRemainingArgumentsPair.getFirst();
                } else {
                    String key = token.substring(0, indexOfPostFix);
                    messageRemainingArgumentsPair = this.convert(key, args);
                    localizedString = localizedString + (String)messageRemainingArgumentsPair.getFirst();
                    localizedString = localizedString + token.substring(indexOfPostFix + LOCALIZATION_POSTFIX.length());
                }
                args = (Object[])messageRemainingArgumentsPair.getSecond();
            }
        } else {
            localizedString = localizedString + remaining;
        }
        return localizedString;
    }

    private Object[] getArguments(List<Element> parameterTags) {
        Object[] args = new Object[parameterTags.size()];
        for (int i = 0; i < parameterTags.size(); ++i) {
            Element paramTag = parameterTags.get(i);
            args[i] = paramTag.getText();
        }
        return args;
    }

    private Pair<String, Object[]> convert(String key, Object[] args) throws OutputResolutionException {
        String convertedMessage;
        Object[] remainingArgs = args;
        int numArgs = MessageManager.countMessageArguments(key, this._locale);
        if (numArgs > args.length) {
            throw new OutputResolutionException("Insifficent arguments to format message: " + key);
        }
        if (numArgs > 0) {
            int remainingArgsLength = args.length - numArgs;
            Object[] currentArgs = new Object[numArgs];
            remainingArgs = new Object[remainingArgsLength];
            System.arraycopy(args, 0, currentArgs, 0, numArgs);
            if (remainingArgsLength > 0) {
                System.arraycopy(args, numArgs, remainingArgs, 0, remainingArgsLength);
            }
            convertedMessage = MessageManager.convert(key, this._locale, currentArgs);
        } else {
            convertedMessage = MessageManager.convert(key, this._locale);
        }
        return new Pair((Object)convertedMessage, (Object)remainingArgs);
    }

    public boolean canLocalize() {
        return true;
    }

    protected XMLHelperD4J getXMLHelper() {
        return this._xmlHelper;
    }

    protected LoggingManager getLoggingManager() {
        return this.mLoggingManager;
    }
}

