/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.parameters;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.ParameterResolutionException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IBindingParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IMultiResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolutionGroupMember;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.core.rule.IInputScopeObjectRule;
import com.ibm.aurora.rare.core.rule.RulesLibrary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Data
extends ParentParameter
implements IBindingParameter,
IMultiResolvableParameter {
    public static final String TYPE = "data";
    private static final int DEAFULT_MIN_BINDINGS = 1;
    private static final int DEAFULT_MAX_BINDINGS = 1;
    private InputScopeObject _scope = null;
    private String _resolutionGroupTag;
    private IInputScopeObjectRule _rule;
    private boolean _enumerateAllPossibilities = true;
    private boolean _allowsBindingSizeVariations = false;
    private boolean _enumerateAllOrderings = false;
    private final boolean _flattenInput;
    private final int _minBindings;
    private final int _maxBindings;
    private final String _concept;
    private final List<IBooleanRule> _filterRules;

    public Data(String name, RulesLibrary rulesLibrary, Map<String, String> attributes) throws ParameterCreationException {
        super(name, attributes);
        this._concept = this.getAttribute("concept", attributes);
        String ruleName = TYPE;
        if (this.hasAttribute("rule", attributes)) {
            ruleName = this.getAttribute("rule", attributes);
        }
        this._rule = rulesLibrary.getInputScopeObjectRule(ruleName);
        if (this._rule == null) {
            throw new ParameterCreationException("Data parameter cannot load rule (" + ruleName + ")!", this.getName());
        }
        this._allowsBindingSizeVariations = !"false".equals(this.getAttribute("allowsBindingSizeVariations", attributes));
        this._enumerateAllPossibilities = !"false".equals(this.getAttribute("enumerateVariations", attributes));
        this._enumerateAllOrderings = "true".equals(this.getAttribute("enumerateAllOrderings", attributes));
        this._flattenInput = "true".equals(this.getAttribute("flattenInput", attributes));
        this._minBindings = this.getIntAttribute("minBindings", attributes, 1);
        this._maxBindings = this.getIntAttribute("maxBindings", attributes, 1);
        String groupName = this.getAttribute("group", attributes);
        this._resolutionGroupTag = groupName != null ? groupName : ((Object)((Object)this)).getClass().getName();
        String filterRules = this.getAttribute("filters", attributes);
        if (filterRules != null) {
            this._filterRules = new ArrayList<IBooleanRule>();
            StringTokenizer tokenizer = new StringTokenizer(filterRules, ",", false);
            while (tokenizer.hasMoreTokens()) {
                String filterRuleName = tokenizer.nextToken();
                IBooleanRule filterRule = rulesLibrary.getBooleanRule(filterRuleName);
                if (filterRule == null) {
                    throw new ParameterCreationException("Data parameter cannot load rule (" + filterRule + ")!", this.getName());
                }
                this._filterRules.add(filterRule);
            }
        } else {
            this._filterRules = null;
        }
    }

    public Data(Data parameter) throws ParameterCreationException {
        super((ParentParameter)parameter);
        this._scope = parameter._scope;
        this._rule = parameter._rule;
        this._resolutionGroupTag = parameter._resolutionGroupTag;
        this._minBindings = parameter._minBindings;
        this._maxBindings = parameter._maxBindings;
        this._allowsBindingSizeVariations = parameter._allowsBindingSizeVariations;
        this._enumerateAllPossibilities = parameter._enumerateAllPossibilities;
        this._concept = parameter._concept;
        this._filterRules = parameter._filterRules;
        this._flattenInput = parameter._flattenInput;
    }

    public Data(Data parameter, boolean shallow) throws ParameterCreationException {
        super((ParentParameter)parameter, shallow);
        this._scope = parameter._scope;
        this._rule = parameter._rule;
        this._resolutionGroupTag = parameter._resolutionGroupTag;
        this._minBindings = parameter._minBindings;
        this._maxBindings = parameter._maxBindings;
        this._allowsBindingSizeVariations = parameter._allowsBindingSizeVariations;
        this._enumerateAllPossibilities = parameter._enumerateAllPossibilities;
        this._concept = parameter._concept;
        this._filterRules = parameter._filterRules;
        this._flattenInput = parameter._flattenInput;
    }

    protected ParentParameter copyImpl(boolean shallow) throws ParameterCreationException {
        Data copy = new Data(this, shallow);
        return copy;
    }

    protected Parameter copyImpl() throws ParameterCreationException {
        Data copy = new Data(this);
        return copy;
    }

    public boolean isResolved() {
        return this._scope != null;
    }

    public InputScopeObject getScope() {
        return this._scope;
    }

    public List<? extends InputScopeObject> resolvePossibleVariations(IVariationsInitializationHandle handle, InputScopeObject scopeList) throws ParameterResolutionException {
        List possibleVariations;
        ArrayList<InputScopeObject> inputs = new ArrayList<InputScopeObject>();
        inputs.add(scopeList);
        try {
            possibleVariations = (List)this._rule.apply(inputs, this.getAttributes(), handle);
        }
        catch (RAREException e) {
            throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
        }
        if (this._filterRules != null) {
            ArrayList<InputScopeObject> filteredVariations = new ArrayList<InputScopeObject>();
            for (InputScopeObject possibility : possibleVariations) {
                InputScopeObject filteredPossiblity = null;
                if (this._flattenInput) {
                    if (this.passesAllFilters(handle, possibility)) {
                        filteredPossiblity = possibility;
                    }
                } else {
                    filteredPossiblity = this.getClosestDescendentOfHierarchyRootThatPassesFilters(handle, possibility);
                }
                if (filteredPossiblity == null || filteredVariations.contains(filteredPossiblity)) continue;
                filteredVariations.add(filteredPossiblity);
            }
            return filteredVariations;
        }
        return possibleVariations;
    }

    private InputScopeObject getClosestDescendentOfHierarchyRootThatPassesFilters(IVariationsInitializationHandle handle, InputScopeObject possibility) throws ParameterResolutionException {
        if (this.passesAllFilters(handle, possibility)) {
            return possibility;
        }
        try {
            ArrayList<InputScopeObject> possibleVariationScopeList = new ArrayList<InputScopeObject>();
            possibleVariationScopeList.add(possibility);
            List possibleVariations = (List)this._rule.apply(possibleVariationScopeList, this.getAttributes(), handle);
            for (InputScopeObject subpossibility : possibleVariations) {
                InputScopeObject passedSubPossiblity = this.getClosestDescendentOfHierarchyRootThatPassesFilters(handle, subpossibility);
                if (passedSubPossiblity == null) continue;
                return passedSubPossiblity;
            }
        }
        catch (RAREException e) {
            throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
        }
        return null;
    }

    private boolean passesAllFilters(IVariationsInitializationHandle handle, InputScopeObject possibility) throws ParameterResolutionException {
        boolean passesAllFilters = true;
        for (IBooleanRule filterRule : this._filterRules) {
            ArrayList<InputScopeObject> possibilityList = new ArrayList<InputScopeObject>();
            possibilityList.add(possibility);
            try {
                if (((Boolean)filterRule.apply(possibilityList, this.getAttributes(), handle)).booleanValue()) continue;
                passesAllFilters = false;
                break;
            }
            catch (RuleException e) {
                throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
            }
        }
        return passesAllFilters;
    }

    public void resolve(IVariationsInitializationHandle handle, InputScopeObject scopeList) {
        this._scope = scopeList;
    }

    public String getResolutionGroupName() {
        return this._resolutionGroupTag;
    }

    public void setToResolutionGroup(IResolutionGroupMember resolutionGroupParameter) {
        this._resolutionGroupTag = resolutionGroupParameter.getResolutionGroupName();
    }

    public boolean allowsEnumerateAllPossiblities() {
        return this._enumerateAllPossibilities;
    }

    public int getMinBindings() {
        return this._minBindings;
    }

    public int getMaxBindings() {
        return this._maxBindings;
    }

    public boolean allowsBindingSizeVariations() {
        return this._allowsBindingSizeVariations;
    }

    public boolean allowsEnumerateAllOrderings() {
        return this._enumerateAllOrderings;
    }

    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        int maxBindingSize;
        int minBindingSize;
        String conceptName = this.getAttribute("concept", attributes);
        if (conceptName != null && !this._concept.equals(conceptName)) {
            return false;
        }
        String allowsBindingVariations = this.getAttribute("allowsBindingSizeVariations", attributes);
        if (allowsBindingVariations != null && this._allowsBindingSizeVariations != "true".equals(allowsBindingVariations)) {
            return false;
        }
        if (this.hasAttribute("minBindings", attributes) && (minBindingSize = this.getIntAttribute("minBindings", attributes, 1)) != this._minBindings) {
            return false;
        }
        if (this.hasAttribute("maxBindings", attributes) && (maxBindingSize = this.getIntAttribute("maxBindings", attributes, 1)) != this._maxBindings) {
            return false;
        }
        String groupName = this.getAttribute("group", attributes);
        if (groupName != null && !groupName.equals(this._resolutionGroupTag)) {
            return false;
        }
        String enumerateAllVariations = this.getAttribute("enumerateVariations", attributes);
        if (enumerateAllVariations != null && !"false".equals(enumerateAllVariations) != this._enumerateAllPossibilities) {
            return false;
        }
        return super.validateMatchesAttributes(attributes);
    }

    protected int getIntAttribute(String name, Map<String, String> attributes, int defaultValue) {
        int result = defaultValue;
        String value = this.getAttribute(name, attributes);
        if (value != null) {
            if (value.equalsIgnoreCase("N")) {
                result = Integer.MAX_VALUE;
            } else {
                try {
                    result = Integer.valueOf(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }
}

