/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.parameters;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.ParameterResolutionException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScorableParameter;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.core.rule.INumericRule;
import com.ibm.aurora.rare.core.rule.IRule;
import com.ibm.aurora.rare.core.rule.RulesLibrary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Score
extends DependentParameter
implements IScorableParameter {
    public static final String TYPE = "score";
    private float _score = 0.0f;
    private float _weight = 0.0f;
    private boolean _hasWeight = false;
    private boolean _resolved = false;
    protected final IRule<?> _rule;
    protected final String _ruleName;
    private boolean _scoreIsCalculated;
    private String _description = null;
    private IVariationsInitializationHandle _resolvedHandle;

    public Score(String name, RulesLibrary rulesLibrary, Map<String, String> attributes) throws ParameterCreationException {
        super(name, attributes);
        this._scoreIsCalculated = false;
        this._ruleName = this.getAttribute("rule", attributes);
        this._resolvedHandle = null;
        String scoreValue = this.getAttribute("value", attributes);
        this._description = this.getAttribute("description", attributes);
        if (scoreValue != null) {
            this._score = Float.parseFloat(scoreValue);
            this._resolved = true;
            this._rule = null;
        } else if (this._ruleName != null) {
            this._rule = rulesLibrary.get(this._ruleName);
            if (this._rule == null) {
                throw new ParameterCreationException("invalid rule (" + this._ruleName + ") referenced by scoring parameter", this.getName());
            }
            if (!INumericRule.class.isInstance(this._rule) && !IBooleanRule.class.isInstance(this._rule)) {
                throw new ParameterCreationException("invalid rule type referenced by scoring parameter", this.getName());
            }
            String weight = this.getAttribute("weight", attributes);
            if (weight != null) {
                this._hasWeight = true;
                this._weight = Float.parseFloat(weight);
            }
        } else {
            throw new ParameterCreationException("rule attribute is missing", this.getName());
        }
    }

    public Score(Score parameter) {
        super((DependentParameter)parameter);
        this._score = parameter._score;
        this._rule = parameter._rule;
        this._ruleName = parameter._ruleName;
        this._resolved = parameter._resolved;
        this._weight = parameter._weight;
        this._hasWeight = parameter._hasWeight;
        this._scoreIsCalculated = parameter._scoreIsCalculated;
        this._resolvedHandle = parameter._resolvedHandle;
        this._description = parameter._description;
    }

    protected Parameter copyImpl() throws ParameterCreationException {
        Score copy = new Score(this);
        return copy;
    }

    public float getScore() throws ParameterResolutionException {
        if (this.isDependent() && !this._scoreIsCalculated) {
            List dependentParameters = this.getDependentParameters();
            if (dependentParameters != null && !dependentParameters.isEmpty()) {
                this._score = 0.0f;
                ArrayList<InputScopeObject> scopes = new ArrayList<InputScopeObject>();
                for (Parameter param : dependentParameters) {
                    if (!IScopeParameter.class.isInstance(param)) continue;
                    scopes.add(((IScopeParameter)param).getScope());
                }
                try {
                    this._score += this.calculateScore(this._resolvedHandle, scopes);
                }
                catch (RAREException e) {
                    throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
                }
            }
            this._scoreIsCalculated = true;
        }
        return this._score;
    }

    public String getScoreDescription() {
        if (this._rule != null) {
            return this._rule.getDescription();
        }
        return this._description;
    }

    public void resolve(IVariationsInitializationHandle handle, InputScopeObject scopeList) throws ParameterResolutionException {
        if (!this._resolved) {
            if (!this.isDependent()) {
                try {
                    ArrayList<InputScopeObject> scopes = new ArrayList<InputScopeObject>();
                    scopes.add(scopeList);
                    this._score = this.calculateScore(handle, scopes);
                }
                catch (RAREException e) {
                    throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
                }
                this._resolved = true;
            } else {
                this._resolvedHandle = handle;
                this._resolved = true;
            }
        }
    }

    private float calculateScore(IVariationsInitializationHandle handle, List<InputScopeObject> scopeList) throws RAREException {
        float score = 0.0f;
        float ruleScore = 0.0f;
        if (INumericRule.class.isInstance(this._rule)) {
            ruleScore = ((Number)((INumericRule)this._rule).apply(scopeList, this.getAttributes(), handle)).floatValue();
        } else if (IBooleanRule.class.isInstance(this._rule) && ((Boolean)((IBooleanRule)this._rule).apply(scopeList, this.getAttributes(), handle)).booleanValue()) {
            ruleScore = 1.0f;
        }
        score = this._hasWeight ? (score += ruleScore * this._weight) : (score += ruleScore);
        return score;
    }

    public boolean isResolved() {
        return this._resolved;
    }

    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        String ruleName = this.getAttribute("rule", attributes);
        if (ruleName != null && !this._ruleName.equals(ruleName)) {
            return false;
        }
        String weight = this.getAttribute("weight", attributes);
        if (weight != null && Float.parseFloat(weight) != this._weight) {
            return false;
        }
        return super.validateMatchesAttributes(attributes);
    }
}

