/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.parameters;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.ParameterResolutionException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IValidationParameter;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.core.rule.INumericRule;
import com.ibm.aurora.rare.core.rule.IRule;
import com.ibm.aurora.rare.core.rule.RulesLibrary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Validate
extends DependentParameter
implements IValidationParameter,
IResolvableParameter {
    public static final String TYPE = "validate";
    private boolean _isValid;
    private boolean _isResolved = false;
    private final IRule _rule;
    private boolean _validIsDetermined;
    private IVariationsInitializationHandle _resolvedHandle;

    public Validate(String name, RulesLibrary rulesLibrary, Map<String, String> attributes) throws ParameterCreationException {
        super(name, attributes);
        String ruleName = this.getAttribute("rule", attributes);
        String value = this.getAttribute("value", attributes);
        if (value != null) {
            this._isValid = "true".equals(value);
            this._isResolved = true;
            this._validIsDetermined = true;
            this._rule = null;
        } else if (ruleName != null) {
            this._rule = rulesLibrary.get(ruleName);
            this._validIsDetermined = false;
        } else {
            throw new ParameterCreationException("rule and value attributes are missing, at least one of the two is required", this.getName());
        }
        this._resolvedHandle = null;
    }

    public Validate(Validate parameter) {
        super((DependentParameter)parameter);
        this._rule = parameter._rule;
        this._isValid = parameter._isValid;
        this._isResolved = parameter._isResolved;
        this._validIsDetermined = parameter._validIsDetermined;
        this._resolvedHandle = parameter._resolvedHandle;
    }

    protected Parameter copyImpl() throws ParameterCreationException {
        Validate copy = new Validate(this);
        return copy;
    }

    public boolean isValid() throws ParameterResolutionException {
        if (this.isDependent() && !this._validIsDetermined) {
            ArrayList<InputScopeObject> inputs = new ArrayList<InputScopeObject>();
            List dependentParameters = this.getDependentParameters();
            if (dependentParameters != null && !dependentParameters.isEmpty()) {
                for (Parameter param : dependentParameters) {
                    if (!IScopeParameter.class.isInstance(param)) continue;
                    inputs.add(((IScopeParameter)param).getScope());
                }
                this._validIsDetermined = true;
                this._isValid = this.isValid(this._resolvedHandle, inputs);
            }
        }
        return this._isValid;
    }

    public boolean isResolved() {
        return this._isResolved;
    }

    public void resolve(IVariationsInitializationHandle handle, InputScopeObject scopeList) throws ParameterResolutionException {
        if (!this.isDependent()) {
            if (this._rule != null) {
                ArrayList<InputScopeObject> inputs = new ArrayList<InputScopeObject>();
                inputs.add(scopeList);
                this._isValid = this.isValid(handle, inputs);
                this._isResolved = true;
            }
        } else {
            this._resolvedHandle = handle;
            this._isResolved = true;
        }
    }

    private boolean isValid(IVariationsInitializationHandle handle, List<InputScopeObject> inputs) throws ParameterResolutionException {
        try {
            boolean isValid = false;
            if (IBooleanRule.class.isInstance(this._rule)) {
                isValid = (Boolean)((IBooleanRule)this._rule).apply(inputs, this.getAttributes(), handle);
            } else if (INumericRule.class.isInstance(this._rule)) {
                isValid = ((Number)((INumericRule)this._rule).apply(inputs, this.getAttributes(), handle)).intValue() != 0;
            }
            return isValid;
        }
        catch (RAREException e) {
            throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
        }
    }

    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        String ruleName = this.getAttribute("rule", attributes);
        if (ruleName != null && !((String)this.getAttributes().get("rule")).equals(ruleName)) {
            return false;
        }
        return super.validateMatchesAttributes(attributes);
    }

    public String toString() {
        return "Validate-" + this._rule.getDescription() + '-' + this._isResolved + '-' + this._validIsDetermined + '-' + this._isValid;
    }
}

