/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class MessageManager {
    private static final MessageManager m_instance = new MessageManager();
    private Map<String, List<ResourceBundle>> m_oMsgResourceMap = new HashMap<String, List<ResourceBundle>>();
    private Map<String, String> m_oMsgFileMap = new HashMap<String, String>();
    private boolean m_bInitialized = false;

    private static MessageManager getInstance() {
        return m_instance;
    }

    private MessageManager() {
    }

    private String getMessage(Locale locale, String key) {
        List<ResourceBundle> msgFilesList = this.getMsgFiles(locale);
        String sMessage = null;
        for (int i = 0; i < msgFilesList.size(); ++i) {
            ResourceBundle bundle = msgFilesList.get(i);
            try {
                sMessage = bundle.getString(key);
                return sMessage;
            }
            catch (MissingResourceException mre) {
                continue;
            }
        }
        return key;
    }

    private int countMessageArguments(Locale locale, String sKey) {
        String rawMessage = MessageManager.getInstance().getMessage(locale, sKey);
        MessageFormat messageformat = new MessageFormat(rawMessage);
        return messageformat.getFormats().length;
    }

    private String getMessage(Locale locale, String sKey, Object[] args) {
        String rawMessage = MessageManager.getInstance().getMessage(locale, sKey);
        StringBuffer newMsgFormat = new StringBuffer(rawMessage.length());
        int idx = 0;
        while ((idx = rawMessage.indexOf(39)) != -1) {
            newMsgFormat.append(rawMessage.substring(0, idx));
            newMsgFormat.append("''");
            rawMessage = rawMessage.substring(idx + 1);
        }
        newMsgFormat.append(rawMessage);
        return MessageFormat.format(newMsgFormat.toString(), args);
    }

    public static void initialize() {
        MessageManager.getInstance().m_bInitialized = true;
    }

    public static void terminate() {
        MessageManager.getInstance().m_bInitialized = false;
    }

    public static boolean isInitialized() {
        return MessageManager.getInstance().m_bInitialized;
    }

    public static Locale getLocale(String locale) {
        int indexOfDash = locale.indexOf(45);
        if (indexOfDash == -1) {
            return new Locale(locale, "");
        }
        return new Locale(locale.substring(0, indexOfDash), locale.substring(indexOfDash + 1));
    }

    public static String convert(String key, String sLocale) {
        if (!MessageManager.isInitialized()) {
            return key;
        }
        Locale locale = MessageManager.getLocale(sLocale);
        return MessageManager.getInstance().getMessage(locale, key);
    }

    public static int countMessageArguments(String key, String sLocale) {
        if (!MessageManager.isInitialized()) {
            return 0;
        }
        Locale locale = MessageManager.getLocale(sLocale);
        return MessageManager.getInstance().countMessageArguments(locale, key);
    }

    public static String convert(String sKey, String sLocale, Object[] args) {
        if (!MessageManager.isInitialized()) {
            return sKey;
        }
        Locale locale = MessageManager.getLocale(sLocale);
        return MessageManager.getInstance().getMessage(locale, sKey, args);
    }

    public static synchronized void addMessageFile(String sFile) {
        if (!MessageManager.getInstance().m_oMsgFileMap.containsKey(sFile)) {
            MessageManager.getInstance().m_oMsgFileMap.put(sFile, sFile);
        }
    }

    public synchronized List<ResourceBundle> getMsgFiles(Locale locale) {
        List<Object> list;
        String mapkey = MessageManager.toJavaString(locale);
        if (this.m_oMsgResourceMap.containsKey(mapkey) && (list = this.m_oMsgResourceMap.get(mapkey)).size() == this.m_oMsgFileMap.size()) {
            return list;
        }
        list = new ArrayList();
        for (Map.Entry<String, String> mapEntry : this.m_oMsgFileMap.entrySet()) {
            String msgfile = mapEntry.getValue();
            list.add(ResourceBundle.getBundle(msgfile, locale));
        }
        this.m_oMsgResourceMap.put(mapkey, list);
        return list;
    }

    public static String toJavaString(Locale locale) {
        if (locale == null) {
            return null;
        }
        String country = locale.getCountry();
        if (country.length() == 0) {
            return locale.getLanguage();
        }
        StringBuffer ret = new StringBuffer();
        ret.append(locale.getLanguage()).append("_").append(country.toUpperCase());
        return ret.toString();
    }

    public static MessageManager getSingletonInstance() {
        return MessageManager.getInstance();
    }
}

