/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.utils;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SmdHelper {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected SmdHelper() {
    }

    public static Set<INode> extractRootNodes(IAssociativeModel model) {
        return SmdHelper.extractRootNodes(model.getNodes(), null);
    }

    public static Set<INode> extractRootNodes(Iterable<INode> nodes, List<String> excludedConcepts) {
        HashSet<INode> nodesInScope = new HashSet<INode>();
        for (INode node : nodes) {
            if (!SmdHelper.isHierarchyRoot(node, excludedConcepts)) continue;
            nodesInScope.add(node);
        }
        return nodesInScope;
    }

    public static INode getDefaultAttribute(INode node) {
        if (node.getDataItem() != null) {
            return node;
        }
        return NavigationHelper.getDefaultAttributeNode((INode)node);
    }

    public static INode getIdAttribute(INode aNode) {
        List<INode> nodes;
        INode node = SmdHelper.getAttributeNode(aNode, "cIdentifier");
        if (node == null) {
            node = SmdHelper.getAttributeNode(aNode, "cCaption");
        }
        if (node == null && (nodes = SmdHelper.getAttributeNodes(aNode)) != null && nodes.size() > 0) {
            node = nodes.get(0);
        }
        if (node == null) {
            node = aNode;
        }
        return node;
    }

    public static List<INode> getAttributeNodes(INode aNode) {
        if (!aNode.isCategory()) {
            return null;
        }
        ArrayList<INode> outNodes = new ArrayList<INode>(3);
        for (IEdge e : aNode.getEdges(new String[0])) {
            INode nodeTo;
            if (e.isWholePart() || !(nodeTo = e.getEnd()).isAttribute()) continue;
            outNodes.add(nodeTo);
        }
        return outNodes;
    }

    public static INode getAttributeNode(INode aNode, String conceptName) {
        if (!aNode.isCategory()) {
            return null;
        }
        ArrayList<INode> outNodes = new ArrayList<INode>(3);
        for (IEdge e : aNode.getOutEdges(new String[0])) {
            INode nodeTo;
            if (e.isWholePart() || !(nodeTo = e.getEnd()).isAttribute() || nodeTo.getConcept().getName().compareTo(conceptName) != 0) continue;
            outNodes.add(nodeTo);
        }
        if (outNodes.size() != 1) {
            return null;
        }
        return (INode)outNodes.get(0);
    }

    private static boolean isHierarchyRoot(INode node, List<String> excludedConcepts) {
        for (IEdge inEdge : node.getInEdges(EMPTY_STRING_ARRAY)) {
            if (excludedConcepts != null && SmdHelper.isConceptExcluded(inEdge.getStart().getConcept(), excludedConcepts)) continue;
            return false;
        }
        return excludedConcepts == null || !SmdHelper.isConceptExcluded(node.getConcept(), excludedConcepts);
    }

    private static boolean isConceptExcluded(IConcept concept, List<String> excludedConcepts) {
        return excludedConcepts.contains(concept.getName());
    }
}

