/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave;

import com.ibm.ba.vis.adapter.Adapter;
import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.DataSet;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.rave.DataProcessor;
import com.ibm.cognos.adapters.rave.FixupJsonProcessor;
import com.ibm.cognos.adapters.rave.JsonParser;
import com.ibm.cognos.adapters.rave.Messages;
import com.ibm.cognos.adapters.rave.OrderedJsonParser;
import com.ibm.cognos.adapters.rave.PalettePropertiesProcessor;
import com.ibm.cognos.adapters.rave.PropertiesProcessor;
import com.ibm.cognos.adapters.rave.SizePropertiesProcessor;
import com.ibm.cognos.adapters.rave.StandardDataProcessor;
import com.ibm.cognos.adapters.rave.TemplatePropertiesProcessor;
import com.ibm.cognos.adapters.rave.render.RaveRenderer;
import com.ibm.cognos.adapters.rave.render.RaveRendererFactory;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAVEChartAdapter
implements Adapter {
    private static final Logger logger = LoggerFactory.getLogger(RAVEChartAdapter.class);
    private final RaveRendererFactory rendererFactory;
    private final JsonParser jsonParser;
    private final DataProcessor dataProcessor;
    private final FixupJsonProcessor fixupJsonProcessor;
    private final PropertiesProcessor[] propsProcessors;
    private boolean forceAndaleFont = false;
    private String bundleName = null;
    Map<String, DataSet> data;
    Map<String, Boolean> override;
    Map<String, Object> properties;
    Formatter formatter = null;

    public RAVEChartAdapter() {
        this(new RaveRendererFactory(), new OrderedJsonParser(), new StandardDataProcessor(), new FixupJsonProcessor(), new SizePropertiesProcessor(), new PalettePropertiesProcessor(), new TemplatePropertiesProcessor());
    }

    RAVEChartAdapter(RaveRendererFactory rendererFactory, JsonParser jsonParser, DataProcessor dataProcessor, FixupJsonProcessor fixupJsonProcessor, PropertiesProcessor ... propsProcessors) {
        this.rendererFactory = rendererFactory;
        this.jsonParser = jsonParser;
        this.dataProcessor = dataProcessor;
        this.fixupJsonProcessor = fixupJsonProcessor;
        this.propsProcessors = propsProcessors;
    }

    public void setData(Map<String, DataSet> data, Map<String, Boolean> override) {
        this.data = data;
        this.override = override;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public Map<String, byte[]> generate(ZipInputStream implementation, String format) {
        boolean modifed;
        InputStream jsonStream = this.getImplementationJson(implementation);
        JSONObject jImplementation = this.jsonParser.read(jsonStream);
        if (logger.isInfoEnabled()) {
            logger.info("Implementation template: " + jImplementation.toString());
        }
        if ((modifed = this.fixupJsonProcessor.process(jImplementation)) && logger.isDebugEnabled()) {
            logger.debug("Post fixup JSON procesing: " + jImplementation.toString());
        }
        if (!"interactive".equalsIgnoreCase(format)) {
            jImplementation = this.dataProcessor.process(jImplementation, this.data, this.override);
            if (logger.isDebugEnabled()) {
                logger.debug("Post data procesing: " + jImplementation.toString());
            }
            for (PropertiesProcessor processor : this.propsProcessors) {
                jImplementation = processor.process(jImplementation, this.properties);
            }
            if (logger.isInfoEnabled()) {
                logger.info("Post processing: " + jImplementation.toString());
            }
            if (this.forceAndaleFont) {
                String def = jImplementation.toString().replaceAll("\"family\":\"", "\"family\":\"Andale WT, ");
                try {
                    jImplementation = JSONObject.parse((String)def);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        RaveRenderer renderer = this.rendererFactory.getRenderer(format);
        return renderer.render(jImplementation, format, this.formatter, this.bundleName);
    }

    private InputStream getImplementationJson(ZipInputStream implementation) {
        try {
            implementation.getNextEntry();
            byte[] json = IOUtils.toByteArray((InputStream)implementation);
            return new ByteArrayInputStream(json);
        }
        catch (IOException e) {
            logger.error("Error reading implementation.json from bundle", (Throwable)e);
            throw new AdapterException(Messages.getString("chartAdapterError"), (Throwable)e);
        }
    }

    public void setForceAndaleFont(boolean forceAndaleFont) {
        this.forceAndaleFont = forceAndaleFont;
    }

    public void setBundleName(String bundleId) {
        this.bundleName = bundleId;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Map<String, byte[]> generate(JSONObject definition, String galleryFolder, String format, Map<String, String> headers) {
        return null;
    }

    public void setLocale(Locale lc) {
    }
}

