/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave;

import com.ibm.ba.vis.adapter.Adapter;
import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.DataSet;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.rave.GeoDataProcessor;
import com.ibm.cognos.adapters.rave.JsonParser;
import com.ibm.cognos.adapters.rave.Messages;
import com.ibm.cognos.adapters.rave.OrderedJsonParser;
import com.ibm.cognos.adapters.rave.PropertiesProcessor;
import com.ibm.cognos.adapters.rave.SizePropertiesProcessor;
import com.ibm.cognos.adapters.rave.SmarterMapBuilder;
import com.ibm.cognos.adapters.rave.StandardDataProcessor;
import com.ibm.cognos.adapters.rave.TemplatePropertiesProcessor;
import com.ibm.cognos.adapters.rave.render.RaveRenderer;
import com.ibm.cognos.adapters.rave.render.RaveRendererFactory;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmarterMapAdapter
implements Adapter {
    private static final Logger logger = LoggerFactory.getLogger(SmarterMapAdapter.class);
    private final RaveRendererFactory rendererFactory;
    private final JsonParser jsonParser;
    private final GeoDataProcessor dataProcessor;
    private final PropertiesProcessor[] propsProcessors;
    Map<String, DataSet> data;
    Map<String, Boolean> override;
    Map<String, Object> properties;
    Formatter formatter = null;

    public SmarterMapAdapter() {
        this(new RaveRendererFactory(), new OrderedJsonParser(), new GeoDataProcessor(new StandardDataProcessor(), SmarterMapBuilder.create()), new SizePropertiesProcessor(), new TemplatePropertiesProcessor());
    }

    SmarterMapAdapter(RaveRendererFactory rendererFactory, JsonParser jsonParser, GeoDataProcessor dataProcessor, PropertiesProcessor ... propsProcessors) {
        this.rendererFactory = rendererFactory;
        this.jsonParser = jsonParser;
        this.dataProcessor = dataProcessor;
        this.propsProcessors = propsProcessors;
    }

    public void setData(Map<String, DataSet> data, Map<String, Boolean> override) {
        this.data = data;
        this.override = override;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
        this.dataProcessor.setProperties(properties);
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public Map<String, byte[]> generate(ZipInputStream implementation, String format) {
        Map<String, InputStream> files = this.readImplementationStream(implementation);
        InputStream jsonStream = files.get("implementation.json");
        JSONObject definition = this.jsonParser.read(jsonStream);
        this.setAlternateJson(files);
        if (logger.isInfoEnabled()) {
            logger.info("Implementation template: " + definition.toString());
        }
        definition = this.dataProcessor.process(definition, this.data, this.override);
        if (logger.isDebugEnabled()) {
            logger.debug("Post data procesing: " + definition.toString());
        }
        if (!"interactive".equalsIgnoreCase(format)) {
            for (PropertiesProcessor processor : this.propsProcessors) {
                definition = processor.process(definition, this.properties);
            }
            if (logger.isInfoEnabled()) {
                logger.info("Post processing: " + definition.toString());
            }
        }
        RaveRenderer renderer = this.rendererFactory.getRenderer(format);
        return renderer.render(definition, format, this.formatter, null);
    }

    private void setAlternateJson(Map<String, InputStream> files) {
        try {
            InputStream alternateStrean = files.get("alternate.json");
            if (alternateStrean != null) {
                JSONObject alternate = this.jsonParser.read(alternateStrean);
                this.dataProcessor.setAlterate(alternate);
            } else {
                logger.info("No alternate.json file found.  Unmappable data may cause rendering fault.");
            }
        }
        catch (Exception e) {
            logger.info("No alternate.json file found.  Unmappable data may cause rendering fault.", (Throwable)e);
        }
    }

    private Map<String, InputStream> readImplementationStream(ZipInputStream implementation) {
        try {
            ZipEntry entry;
            HashMap<String, InputStream> files = new HashMap<String, InputStream>();
            while ((entry = implementation.getNextEntry()) != null) {
                byte[] file = IOUtils.toByteArray((InputStream)implementation);
                files.put(entry.getName(), new ByteArrayInputStream(file));
            }
            return files;
        }
        catch (IOException e) {
            logger.error("Error reading implementaion files from bundle", (Throwable)e);
            throw new AdapterException(Messages.getString("chartAdapterError"), (Throwable)e);
        }
    }

    public void setForceAndaleFont(boolean forceAndaleFont) {
    }

    public void setBundleName(String bundleId) {
    }

    public String getBundleName() {
        return null;
    }

    public Map<String, byte[]> generate(JSONObject definition, String galleryFolder, String format, Map<String, String> headers) {
        return null;
    }

    public void setLocale(Locale lc) {
    }
}

