/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave;

import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.DataSet;
import com.ibm.ba.vis.adapter.DataSetField;
import com.ibm.cognos.adapters.rave.DataProcessor;
import com.ibm.cognos.adapters.rave.Messages;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StandardDataProcessor
implements DataProcessor {
    private static final String CATEGORIES = "categories";
    private static final String CATEGORY_DATA = "categoryData";
    private static final String DATA = "data";
    private static final String FIELDS = "fields";
    private static final String ID = "id";
    private static final String LABEL = "label";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String ROWS = "rows";
    private static final String ROW_DATA = "rowData";

    @Override
    public JSONObject process(JSONObject json, Map<String, DataSet> datasets, Map<String, Boolean> overrides) {
        JSONArray dataArray = (JSONArray)json.get((Object)DATA);
        this.validateDataMap(dataArray, datasets);
        for (int i = 0; i < dataArray.size(); ++i) {
            boolean canOverride;
            JSONObject dataJson = (JSONObject)dataArray.get(i);
            String id = (String)dataJson.get((Object)ID);
            DataSet dataset = datasets.get(id);
            Boolean override = overrides.get(id);
            boolean bl = canOverride = override != null ? override : false;
            if (dataset != null && !dataset.getDataSetFields().isEmpty()) {
                if (!this.hasAllValues(dataJson, dataset)) {
                    this.clearAllData(dataJson);
                    continue;
                }
                this.replaceDataSetData(dataJson, dataset);
                continue;
            }
            if (dataset == null && canOverride) continue;
            this.clearAllData(dataJson);
        }
        return json;
    }

    private boolean hasAllValues(JSONObject dataJson, DataSet dataset) {
        List fieldList = dataset.getDataSetFields();
        HashSet<String> instanceFieldsIDs = new HashSet<String>(fieldList.size());
        for (DataSetField field : fieldList) {
            instanceFieldsIDs.add(field.getName());
        }
        HashSet<String> definitionFieldsIDs = new HashSet<String>(dataJson.size());
        JSONArray fields = (JSONArray)dataJson.get((Object)FIELDS);
        for (Object fieldObj : fields) {
            JSONObject field = (JSONObject)fieldObj;
            definitionFieldsIDs.add((String)field.get((Object)ID));
        }
        return instanceFieldsIDs.containsAll(definitionFieldsIDs);
    }

    private void validateDataMap(JSONArray dataArray, Map<String, DataSet> dataset) throws AdapterException {
        HashSet<String> templateIDs = new HashSet<String>(dataArray.size());
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject dataJson = (JSONObject)dataArray.get(i);
            String id = (String)dataJson.get((Object)ID);
            templateIDs.add(id);
        }
        Set<String> dataKeys = dataset.keySet();
        for (String key : dataKeys) {
            if (templateIDs.contains(key)) continue;
            String msg = Messages.getString("dataIdMissingInChartTemplate") + key;
            throw new AdapterException(msg);
        }
    }

    private void replaceDataSetData(JSONObject dataJson, DataSet dataset) {
        JSONObject dataSetData;
        JSONArray fields = (JSONArray)dataJson.get((Object)FIELDS);
        Map<String, JSONObject> fieldMap = this.convertToMap(fields);
        List fieldList = dataset.getDataSetFields();
        try {
            dataSetData = JSONObject.parse((String)dataset.getDatSetData());
        }
        catch (IOException e) {
            String template = Messages.getString("invalidDataJSON");
            String message = MessageFormat.format(template, dataset.getDatSetData());
            throw new AdapterException(message, (Throwable)e);
        }
        for (DataSetField field : fieldList) {
            JSONObject dataField = fieldMap.remove(field.getName());
            fields.remove((Object)dataField);
            JSONObject updated = this.updateField(dataField, field, (JSONObject)dataSetData.get((Object)CATEGORY_DATA));
            fields.add((Object)updated);
        }
        Set<String> unsetFields = fieldMap.keySet();
        if (!unsetFields.isEmpty()) {
            Iterator<String> keys = unsetFields.iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                JSONObject dataField = fieldMap.get(key);
                keys.remove();
                fields.remove((Object)dataField);
                JSONObject emptyField = new JSONObject();
                emptyField.put((Object)ID, (Object)key);
                emptyField.put((Object)LABEL, (Object)"");
                fields.add((Object)emptyField);
            }
            this.replaceRowData(dataJson, new JSONArray());
        } else {
            this.replaceRowData(dataJson, (JSONArray)dataSetData.get((Object)ROW_DATA));
        }
    }

    private Map<String, JSONObject> convertToMap(JSONArray fields) {
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        for (Object fieldObj : fields) {
            JSONObject field = (JSONObject)fieldObj;
            String id = (String)field.get((Object)ID);
            map.put(id, field);
        }
        return map;
    }

    private JSONObject updateField(JSONObject dataField, DataSetField field, JSONObject categoryData) {
        if (dataField != null) {
            dataField.put((Object)ID, (Object)field.getName());
            dataField.put((Object)LABEL, (Object)field.getLabel());
            JSONArray categories = (JSONArray)categoryData.get((Object)field.getName());
            if (categories != null) {
                dataField.put((Object)CATEGORIES, (Object)categories);
            }
        } else {
            throw new AdapterException(Messages.getString("categoricalFieldIdMissingInChartTemplate") + field.getName());
        }
        this.setFieldDecimal(dataField, field.getMin(), MIN);
        this.setFieldDecimal(dataField, field.getMax(), MAX);
        return dataField;
    }

    private void setFieldDecimal(JSONObject dataField, BigDecimal value, String label) {
        if (value != null) {
            dataField.put((Object)label, (Object)value.doubleValue());
        }
    }

    private void clearAllData(JSONObject dataJson) {
        JSONArray empty = new JSONArray();
        this.clearAllCategories(dataJson);
        this.replaceRowData(dataJson, empty);
    }

    private void clearAllCategories(JSONObject dataJson) {
        JSONArray fields = (JSONArray)dataJson.get((Object)FIELDS);
        if (fields == null) {
            return;
        }
        for (Object fieldObj : fields) {
            JSONObject field = (JSONObject)fieldObj;
            field.put((Object)LABEL, (Object)"");
            if (field.containsKey((Object)CATEGORIES)) {
                field.put((Object)CATEGORIES, (Object)new JSONArray());
            }
            field.remove((Object)MIN);
            field.remove((Object)MAX);
        }
    }

    private void replaceRowData(JSONObject dataJson, JSONArray rowData) {
        if (dataJson.containsKey((Object)ROWS)) {
            dataJson.remove((Object)ROWS);
            dataJson.put((Object)ROWS, (Object)rowData);
        }
    }
}

