/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave;

import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.property.Color;
import com.ibm.ba.vis.adapter.property.Font;
import com.ibm.cognos.adapters.rave.PropertiesProcessor;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.template.ColorParameter;
import com.ibm.vis.template.FontParameter;
import com.ibm.vis.template.Parameter;
import com.ibm.vis.template.ParameterType;
import com.ibm.vis.template.Template;
import com.ibm.vis.template.ravetype.RaveColor;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class TemplatePropertiesProcessor
implements PropertiesProcessor {
    @Override
    public JSONObject process(JSONObject json, Map<String, Object> props) {
        if (!json.containsKey((Object)"parameters")) {
            return json;
        }
        try {
            Template template = new Template(json.serialize());
            if (template.hasParameters()) {
                Set<String> propIds = props.keySet();
                for (String id : propIds) {
                    Object valueObject = props.get(id);
                    Parameter p = template.getParameter(id);
                    this.setParameterValue(p, valueObject);
                }
                String resolved = template.resolve();
                json = JSONObject.parse((String)resolved);
            }
        }
        catch (IOException e) {
            throw new AdapterException("Error resolving templated properties", (Throwable)e);
        }
        return json;
    }

    private void setParameterValue(Parameter p, Object valueObject) {
        if (p == null || valueObject == null) {
            return;
        }
        ParameterType type = p.getType();
        switch (type) {
            case STRING: {
                p.setValue((Object)((String)valueObject));
                break;
            }
            case BOOLEAN: {
                if (valueObject instanceof String) {
                    p.setValue((Object)Boolean.valueOf((String)valueObject));
                    break;
                }
                p.setValue((Object)((Boolean)valueObject));
                break;
            }
            case INTEGER: {
                if (valueObject instanceof String) {
                    p.setValue((Object)Integer.valueOf((String)valueObject));
                    break;
                }
                p.setValue((Object)((Integer)valueObject));
                break;
            }
            case DOUBLE: {
                if (valueObject instanceof String) {
                    p.setValue((Object)Double.valueOf((String)valueObject));
                    break;
                }
                p.setValue((Object)((Double)valueObject));
                break;
            }
            case COLOR: {
                Color c = (Color)valueObject;
                RaveColor color = new RaveColor();
                color.setRGBA((Number)c.getR(), (Number)c.getG(), (Number)c.getB(), (Number)c.getA());
                ColorParameter cp = (ColorParameter)p;
                cp.setColorValue(color);
                break;
            }
            case FONT: {
                Font f = (Font)valueObject;
                FontParameter fp = (FontParameter)p;
                if (!"".equals(f.getFamily())) {
                    fp.setFontFamily(f.getFamily());
                }
                if (!"".equals(f.getSize())) {
                    fp.setFontSize((Object)f.getSize());
                }
                if (!"".equals(f.getWeight())) {
                    fp.setFontWeight(f.getWeight());
                }
                if ("".equals(f.getStyle())) break;
                fp.setFontStyle(f.getStyle());
                break;
            }
            case LENGTH: {
                p.setValue((Object)((String)valueObject));
                break;
            }
            case SIZE: {
                break;
            }
            case COLOR_PALETTE: {
                Color c = (Color)valueObject;
                RaveColor color = new RaveColor();
                color.setRGBA((Number)c.getR(), (Number)c.getG(), (Number)c.getB(), (Number)c.getA());
                ColorParameter cp = (ColorParameter)p;
                cp.setColorValue(color);
                break;
            }
            case STYLEBY_PALETTE: {
                break;
            }
        }
    }
}

