/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave.render;

import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.rave.Messages;
import com.ibm.cognos.adapters.rave.render.NumberFormatAdapter;
import com.ibm.cognos.adapters.rave.render.RaveRenderer;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.NumberFormatter;
import com.ibm.vis.ui.awt.VisControl;
import java.io.IOException;
import java.util.Map;

public abstract class BaseImageRenderer
implements RaveRenderer {
    private final String name;

    BaseImageRenderer(String name) {
        this.name = name;
    }

    @Override
    public Map<String, byte[]> render(JSONObject json, String mimeType, Formatter formatter, String bundleName) {
        VisControl control = null;
        try {
            control = new VisControl(null, this.name);
            if (formatter != null) {
                NumberFormatAdapter format = new NumberFormatAdapter(formatter);
                control.setNumberFormatter((NumberFormatter)format);
            }
            Map<String, byte[]> output = this.generate(json, control, bundleName);
            control.dispose();
            return output;
        }
        catch (IOException e) {
            if (control != null) {
                control.dispose();
            }
            String errorMsg = Messages.getString("failedToGenerateImage");
            throw new AdapterException(errorMsg, (Throwable)e);
        }
    }

    abstract Map<String, byte[]> generate(JSONObject var1, VisControl var2, String var3) throws IOException;
}

