/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave.render;

import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.cognos.adapters.rave.Messages;
import com.ibm.cognos.adapters.rave.imagemap.beans.AreaShape;
import com.ibm.cognos.adapters.rave.imagemap.beans.AreaShapes;
import com.ibm.cognos.adapters.rave.imagemap.beans.Row;
import com.ibm.cognos.adapters.rave.render.BaseImageRenderer;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.configuration.IVisConfiguration;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.services.VisImageService;
import com.ibm.vis.ui.awt.VisControl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ImageMapRenderer
extends BaseImageRenderer {
    private static final String VIS_NAME = "com.ibm.cognos.adapters.rave.render.ImageMapRenderer";
    private final JAXBContext imageMapContext;

    ImageMapRenderer() {
        super(VIS_NAME);
        try {
            this.imageMapContext = JAXBContext.newInstance((Class[])new Class[]{AreaShapes.class});
        }
        catch (JAXBException e) {
            throw new AdapterException("Error creating JAXB context for ImageMapRenderer", (Throwable)e);
        }
    }

    @Override
    Map<String, byte[]> generate(JSONObject spec, VisControl control, String bundleName) throws IOException {
        HashMap<String, byte[]> images;
        try {
            images = new HashMap<String, byte[]>();
            ByteArrayOutputStream image = new ByteArrayOutputStream();
            SceneItem[] sceneItems = VisImageService.generateImageWithImageMap((JSONObject)spec, (OutputStream)image, (String)"png", null, null, null, null, (IVisConfiguration)control);
            images.put("image.png", image.toByteArray());
            ByteArrayOutputStream areaShapeStream = new ByteArrayOutputStream();
            AreaShapes areaShapes = this.createAreaShapes(sceneItems);
            if (bundleName != null && bundleName.startsWith("az.Treemap")) {
                areaShapes = this.removeOuterAreaShapeForTreemap(areaShapes);
            }
            Marshaller marshaller = this.imageMapContext.createMarshaller();
            marshaller.marshal((Object)areaShapes, (OutputStream)areaShapeStream);
            images.put("imagemap.xml", areaShapeStream.toByteArray());
        }
        catch (JAXBException e) {
            String message = Messages.getString("failedToCreateImagemapXML");
            throw new AdapterException(message, (Throwable)e);
        }
        return images;
    }

    private AreaShapes createAreaShapes(SceneItem[] sceneItems) {
        AreaShapes areaShapes = new AreaShapes();
        for (SceneItem sceneItem : sceneItems) {
            AreaShape areaShape = AreaShape.createAreaShapeBean(sceneItem);
            areaShapes.getAreaShape().add(areaShape);
        }
        return areaShapes;
    }

    private AreaShapes removeOuterAreaShapeForTreemap(AreaShapes areaShapes) {
        List<AreaShape> areaShapeList = areaShapes.getAreaShape();
        ArrayList<AreaShape> areaShapeDeleteList = new ArrayList<AreaShape>();
        for (AreaShape areaShape : areaShapeList) {
            Row[] rows;
            if (!"element".equals(areaShape.getType()) || !"main".equals(areaShape.getSubType()) || (rows = areaShape.getRows()) == null || rows.length <= 1) continue;
            areaShapeDeleteList.add(areaShape);
        }
        areaShapeList.removeAll(areaShapeDeleteList);
        return areaShapes;
    }
}

