/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave2;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.athena.smartermaps.ISmarterMaps;
import com.ibm.athena.smartermaps.SMLocation;
import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.DataSetField;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.rave2.DataProcessor;
import com.ibm.cognos.adapters.rave2.Messages;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.library.datamodel.DataSet;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoDataProcessor
implements DataProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GeoDataProcessor.class);
    private final DataProcessor processor;
    private final ISmarterMaps map;
    private String mapType = "region";
    private int confidence = 80;
    private JSONObject alternate;

    GeoDataProcessor(DataProcessor processor, ISmarterMaps map) {
        this.processor = processor;
        this.map = map;
    }

    void setProperties(Map<String, Object> properties) {
        Object confInt;
        Object type = properties.get("mapType");
        if (type != null) {
            this.mapType = (String)type;
        }
        if ((confInt = properties.get("confidence")) != null) {
            this.confidence = Integer.valueOf((String)confInt);
        }
    }

    private boolean setGeoData(JSONObject json, Map<String, com.ibm.ba.vis.adapter.DataSet> dataset) {
        JSONArray augmentations = (JSONArray)json.get((Object)"augment");
        if (augmentations != null) {
            for (int i = 0; i < augmentations.size(); ++i) {
                JSONObject augmentation = (JSONObject)augmentations.get(i);
                JSONObject source = (JSONObject)augmentation.get((Object)"source");
                String id = (String)source.get((Object)"$ref");
                JSONArray dataKeys = (JSONArray)augmentation.get((Object)"dataKeys");
                for (int j = 0; j < dataKeys.size(); ++j) {
                    JSONObject key = (JSONObject)dataKeys.get(j);
                    String field = (String)key.get((Object)"$ref");
                    List<ISMLocation> locations = this.getFieldData(field, dataset);
                    String fieldLabel = this.getFieldLabel(field, dataset);
                    this.map.setConfidenceLevel(this.confidence);
                    JSONObject geoObject = "bounding".equalsIgnoreCase(this.mapType) ? this.map.generateBoundingRegion(locations, fieldLabel) : this.map.generateSmallestRegion(locations, fieldLabel);
                    String status = this.setGeoJson(json, id, geoObject);
                    if (!"Fail".equalsIgnoreCase(status)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private String setGeoJson(JSONObject json, String id, JSONObject geoObject) {
        try {
            String status = (String)geoObject.get((Object)"status");
            if ("Fail".equalsIgnoreCase(status)) {
                if (this.alternate == null) {
                    throw new AdapterException(Messages.getString("chartAdapterError") + " " + geoObject.get((Object)"failureMessage"));
                }
                return status;
            }
            if ("Warning".equalsIgnoreCase(status)) {
                this.logWarnings(geoObject);
            }
            JSONObject geoJSON = (JSONObject)geoObject.get((Object)"geojson");
            JSONArray resources = (JSONArray)json.get((Object)"resource");
            for (int i = 0; i < resources.size(); ++i) {
                JSONObject resource = (JSONObject)resources.get(i);
                if (!resource.get((Object)"id").equals(id)) continue;
                resource.put((Object)"embeddedData", (Object)geoJSON.serialize(false));
            }
            return status;
        }
        catch (IOException e) {
            throw new AdapterException(Messages.getString("chartAdapterError"), (Throwable)e);
        }
    }

    private List<ISMLocation> getFieldData(String field, Map<String, com.ibm.ba.vis.adapter.DataSet> datasets) {
        List<ISMLocation> locations = Collections.emptyList();
        Set<String> keys = datasets.keySet();
        for (String key : keys) {
            com.ibm.ba.vis.adapter.DataSet dataset = datasets.get(key);
            try {
                List fields = dataset.getDataSetFields();
                for (DataSetField dataSetField : fields) {
                    if (!dataSetField.getName().equals(field)) continue;
                    JSONObject dataSetData = JSONObject.parse((String)dataset.getDatSetData());
                    JSONObject categoryData = (JSONObject)dataSetData.get((Object)"categoryData");
                    JSONArray fieldData = (JSONArray)categoryData.get((Object)field);
                    locations = new ArrayList<ISMLocation>(fieldData.size());
                    for (Object fieldValue : fieldData) {
                        SMLocation location = new SMLocation((String)fieldValue);
                        locations.add((ISMLocation)location);
                    }
                }
            }
            catch (IOException e) {
                String template = Messages.getString("invalidDataJSON");
                String message = MessageFormat.format(template, dataset.getDatSetData());
                throw new AdapterException(message, (Throwable)e);
            }
        }
        return locations;
    }

    private String getFieldLabel(String field, Map<String, com.ibm.ba.vis.adapter.DataSet> datasets) {
        Set<String> keys = datasets.keySet();
        for (String key : keys) {
            com.ibm.ba.vis.adapter.DataSet dataset = datasets.get(key);
            List fields = dataset.getDataSetFields();
            for (DataSetField dataSetField : fields) {
                if (!dataSetField.getName().equals(field)) continue;
                return dataSetField.getLabel();
            }
        }
        return field;
    }

    private void logWarnings(JSONObject geoObject) {
        if (logger.isInfoEnabled()) {
            Object ambMessage;
            Object ambiguous;
            Object unmatched = geoObject.get((Object)"unmatched");
            if (unmatched != null) {
                logger.info("Unmatched geo data: " + unmatched);
            }
            if ((ambiguous = geoObject.get((Object)"ambiguous")) != null) {
                logger.info("Ambiguous geo data: " + ambiguous);
            }
            if ((ambMessage = geoObject.get((Object)"ambiguityMessage")) != null) {
                logger.info(ambMessage.toString());
            }
        }
    }

    void setAlterate(JSONObject alternate) {
        this.alternate = alternate;
    }

    @Override
    public void process(Map<String, com.ibm.ba.vis.adapter.DataSet> dataset, DataSet dataSet, int dataSetId, Formatter formatter) {
    }

    @Override
    public String getFormatSpecifier(String measureKey, int setId) {
        return null;
    }

    @Override
    public void setBundleName(String bundleName) {
    }
}

