/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave2;

import com.ibm.rave.core.geom.PointStruct;
import com.ibm.rave.library.framework.internal.OrdinalCoordinateScaleDatum;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.XMLEvent;

public class ImagemapProcessor {
    private static final String VALUE = "value";
    private static final String COORDINATE_FIELD = "coordinateField";
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private XMLEventWriter writer = null;

    public void startAreaShapes() throws XMLStreamException {
        this.writer = xmlOutputFactory.createXMLEventWriter(this.baos, "UTF-8");
        XMLEvent event = eventFactory.createStartDocument("UTF-8", "1.0", true);
        this.writer.add(event);
        event = eventFactory.createStartElement("", "", "AreaShapes");
        this.writer.add(event);
    }

    public void endAreaShapes() throws XMLStreamException {
        EndElement event = eventFactory.createEndElement("", "", "AreaShapes");
        this.writer.add(event);
        this.writer.flush();
        this.writer.close();
    }

    public void startAreaShape(String type, String subType, List<PointStruct> points, String dataIndex, Object data) throws XMLStreamException {
        XMLEvent event = eventFactory.createStartElement("", "", "AreaShape");
        this.writer.add(event);
        event = eventFactory.createAttribute("type", type);
        this.writer.add(event);
        event = eventFactory.createAttribute("subType", subType);
        this.writer.add(event);
        event = eventFactory.createAttribute("dataIndex", dataIndex);
        this.writer.add(event);
        if (points != null) {
            this.createPoints(points);
        }
        this.createCoordinateFields(false);
        if (data != null) {
            List dataList = null;
            if (data instanceof List) {
                dataList = (List)data;
            } else if (data instanceof OrdinalCoordinateScaleDatum) {
                OrdinalCoordinateScaleDatum datum = (OrdinalCoordinateScaleDatum)data;
                dataList = datum.originalDataList();
            }
            if (dataList != null) {
                this.createRowsIndex(dataList);
            }
        }
    }

    public void endAreaShape() throws XMLStreamException {
        EndElement event = eventFactory.createEndElement("", "", "AreaShape");
        this.writer.add(event);
    }

    private void createCoordinateFields(boolean doIt) throws XMLStreamException {
        if (!doIt) {
            return;
        }
        XMLEvent event = eventFactory.createStartElement("", "", "coordinateFields");
        this.writer.add(event);
        event = eventFactory.createStartElement("", "", COORDINATE_FIELD);
        this.writer.add(event);
        event = eventFactory.createAttribute(VALUE, "yStart");
        this.writer.add(event);
        event = eventFactory.createEndElement("", "", COORDINATE_FIELD);
        this.writer.add(event);
        event = eventFactory.createStartElement("", "", COORDINATE_FIELD);
        this.writer.add(event);
        event = eventFactory.createAttribute(VALUE, "x");
        this.writer.add(event);
        event = eventFactory.createEndElement("", "", COORDINATE_FIELD);
        this.writer.add(event);
        event = eventFactory.createStartElement("", "", COORDINATE_FIELD);
        this.writer.add(event);
        event = eventFactory.createAttribute(VALUE, "key");
        this.writer.add(event);
        event = eventFactory.createEndElement("", "", COORDINATE_FIELD);
        this.writer.add(event);
        event = eventFactory.createStartElement("", "", COORDINATE_FIELD);
        this.writer.add(event);
        event = eventFactory.createAttribute(VALUE, "color");
        this.writer.add(event);
        event = eventFactory.createEndElement("", "", COORDINATE_FIELD);
        this.writer.add(event);
        event = eventFactory.createEndElement("", "", "coordinateFields");
        this.writer.add(event);
    }

    private void createRowsIndex(List<Object> rows) throws XMLStreamException {
        for (Object row : rows) {
            if (row == null) continue;
            XMLEvent event = eventFactory.createStartElement("", "", "rows");
            this.writer.add(event);
            event = eventFactory.createStartElement("", "", "row");
            this.writer.add(event);
            event = eventFactory.createAttribute(VALUE, row.toString().replace(".0", ""));
            this.writer.add(event);
            event = eventFactory.createEndElement("", "", "row");
            this.writer.add(event);
            event = eventFactory.createEndElement("", "", "rows");
            this.writer.add(event);
        }
    }

    private void createPoints(List<PointStruct> points) throws XMLStreamException {
        XMLEvent event = eventFactory.createStartElement("", "", "points");
        this.writer.add(event);
        for (PointStruct point : points) {
            this.createPoint(point);
        }
        event = eventFactory.createEndElement("", "", "points");
        this.writer.add(event);
    }

    private void createPoint(PointStruct point) throws XMLStreamException {
        XMLEvent event = eventFactory.createStartElement("", "", "point");
        this.writer.add(event);
        this.createPointCoord("x", point.x);
        this.createPointCoord("y", point.y);
        event = eventFactory.createEndElement("", "", "point");
        this.writer.add(event);
    }

    private void createPointCoord(String name, double value) throws XMLStreamException {
        XMLEvent event = eventFactory.createStartElement("", "", name);
        this.writer.add(event);
        event = eventFactory.createCharacters(Double.toString(value));
        this.writer.add(event);
        event = eventFactory.createEndElement("", "", name);
        this.writer.add(event);
    }

    public ByteArrayOutputStream getAreaShapes() {
        return this.baos;
    }
}

