/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave2;

import com.ibm.icu.util.Currency;
import com.ibm.xmlns.prod.ba.visbundle.chartinstance._3_1.DataFormat;
import java.math.BigInteger;

public class NumberFormatSpecifiers {
    public DataFormat dataFormat;

    public NumberFormatSpecifiers(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getSymbolSpecifier() {
        if (this.dataFormat == null) {
            return "";
        }
        String symbol = "";
        if (this.dataFormat.getCurrencyFormat() != null) {
            symbol = this.dataFormat.getCurrencyFormat().getCurrencySymbol() != null ? this.dataFormat.getCurrencyFormat().getCurrencySymbol() : Currency.getInstance((String)this.dataFormat.getCurrencyFormat().getCurrencyCode()).getSymbol();
        } else if (this.dataFormat.getNumberFormat() == null && this.dataFormat.getPercentFormat() != null) {
            symbol = this.dataFormat.getPercentFormat().getPercentSymbol();
        }
        return symbol != null ? symbol : "";
    }

    public String getPrecisionSpecifier() {
        if (this.dataFormat == null) {
            return ".0";
        }
        BigInteger decimals = null;
        if (this.dataFormat.getCurrencyFormat() != null) {
            decimals = this.dataFormat.getCurrencyFormat().getDecimalSize();
        } else if (this.dataFormat.getNumberFormat() != null) {
            decimals = this.dataFormat.getNumberFormat().getDecimalSize();
        } else if (this.dataFormat.getPercentFormat() != null) {
            decimals = this.dataFormat.getPercentFormat().getDecimalSize();
        }
        return decimals == null ? ".0" : "." + decimals.toString();
    }

    public String getFillSpecifier() {
        return "";
    }

    public String getAlignSpecifier() {
        return "";
    }

    public String getSignSpecifier() {
        if (this.dataFormat == null) {
            return "";
        }
        String sign = "";
        if (this.dataFormat.getCurrencyFormat() != null) {
            sign = this.dataFormat.getCurrencyFormat().getSign();
        } else if (this.dataFormat.getNumberFormat() != null) {
            sign = this.dataFormat.getNumberFormat().getSign();
        } else if (this.dataFormat.getPercentFormat() != null) {
            sign = this.dataFormat.getPercentFormat().getSign();
        }
        return sign != null ? sign : "";
    }

    public String getPaddingSpecifier() {
        if (this.dataFormat == null) {
            return "0";
        }
        String padding = "";
        if (this.dataFormat.getCurrencyFormat() != null) {
            padding = this.dataFormat.getCurrencyFormat().getPaddingCharacter();
        } else if (this.dataFormat.getNumberFormat() != null) {
            padding = this.dataFormat.getNumberFormat().getPaddingCharacter();
        } else if (this.dataFormat.getPercentFormat() != null) {
            padding = this.dataFormat.getPercentFormat().getPaddingCharacter();
        }
        return padding == null ? "0" : padding;
    }

    public String getWidthSpecifier() {
        return "";
    }

    public String getSeparatorSpecifier() {
        if (this.dataFormat == null) {
            return "";
        }
        String delimiter = "";
        if (this.dataFormat.getCurrencyFormat() != null) {
            delimiter = this.dataFormat.getCurrencyFormat().getGroupDelimiter();
        } else if (this.dataFormat.getNumberFormat() != null) {
            delimiter = this.dataFormat.getNumberFormat().getGroupDelimiter();
        } else if (this.dataFormat.getPercentFormat() != null) {
            delimiter = this.dataFormat.getPercentFormat().getGroupDelimiter();
        }
        return delimiter == null ? "" : delimiter;
    }

    public String getTypeSpecifier() {
        if (this.dataFormat == null) {
            return "";
        }
        if (this.dataFormat.getCurrencyFormat() != null) {
            return "f";
        }
        if (this.dataFormat.getNumberFormat() != null) {
            return "f";
        }
        if (this.dataFormat.getPercentFormat() != null) {
            return "%";
        }
        return "";
    }

    public Integer getSubDomainDivision() {
        if (this.dataFormat == null) {
            return null;
        }
        Integer result = null;
        if (this.dataFormat.getCurrencyFormat() != null && this.dataFormat.getCurrencyFormat().getDecimalSize() != null) {
            int scale = this.dataFormat.getCurrencyFormat().getScale() != null ? this.dataFormat.getCurrencyFormat().getScale().intValue() : 0;
            result = -(this.dataFormat.getCurrencyFormat().getDecimalSize().intValue() + scale);
        } else if (this.dataFormat.getNumberFormat() != null && this.dataFormat.getNumberFormat().getDecimalSize() != null) {
            int scale = this.dataFormat.getNumberFormat().getScale() != null ? this.dataFormat.getNumberFormat().getScale().intValue() : 0;
            result = -(this.dataFormat.getNumberFormat().getDecimalSize().intValue() + scale);
        } else if (this.dataFormat.getPercentFormat() != null && this.dataFormat.getPercentFormat().getDecimalSize() != null) {
            int scale = this.dataFormat.getPercentFormat().getScale() != null ? this.dataFormat.getPercentFormat().getScale().intValue() : 0;
            result = -(this.dataFormat.getPercentFormat().getDecimalSize().intValue() + scale + 2);
        }
        return result;
    }
}

