/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave2;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.ibm.ba.vis.adapter.Adapter;
import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.rave2.DataProcessor;
import com.ibm.cognos.adapters.rave2.ImagemapProcessor;
import com.ibm.cognos.adapters.rave2.Messages;
import com.ibm.cognos.adapters.rave2.StandardDataProcessor;
import com.ibm.cognos.adapters.rave2.render.RaveRenderer;
import com.ibm.cognos.adapters.rave2.render.RaveRendererFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.awt.service.AWTRaveImageService;
import com.ibm.rave.awt.service.AWTRaveImageServiceRunnable;
import com.ibm.rave.bundles.RaveBundle;
import com.ibm.rave.bundles.nativeImpl.BundleLookup;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.geom.PointStruct;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.datamodel.DataModel;
import com.ibm.rave.library.datamodel.DataModelDescriptor;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.ext.imagemap.ImageMap;
import com.ibm.rave.library.ext.imagemap.ImageMapArguments;
import com.ibm.rave.library.ext.imagemap.ImageMapCallback;
import com.ibm.rave.library.ext.imagemap.ImageMapResult;
import com.ibm.rave.library.ext.imagemap.ImageMapSceneItem;
import com.ibm.rave.library.framework.Controller;
import com.ibm.rave.library.framework.CustomFormatInfo;
import com.ibm.rave.library.framework.CustomFormatter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAVEChartAdapter
implements Adapter,
AWTRaveImageServiceRunnable {
    private static final Logger logger = LoggerFactory.getLogger(RAVEChartAdapter.class);
    private static final String ADAPTER_ERR_STR = Messages.getString("chartAdapterError");
    private final RaveRendererFactory rendererFactory;
    private final DataProcessor dataProcessor;
    private final ImagemapProcessor imagemapProcessor;
    private String bundleName = null;
    private String bundleID = "";
    private String configID = "";
    private static final String CATEGORY = "category";
    private static final String VALUE = "value";
    private Map<String, com.ibm.ba.vis.adapter.DataSet> instanceData;
    private Map<String, Object> properties;
    private BufferedImage bufferedImage;
    private Formatter formatter = null;
    private Controller bundleInstance = null;

    public RAVEChartAdapter() {
        this(new RaveRendererFactory(), new StandardDataProcessor(), new ImagemapProcessor());
    }

    RAVEChartAdapter(RaveRendererFactory rendererFactory, DataProcessor dataProcessor, ImagemapProcessor imagemapProcessor) {
        this.rendererFactory = rendererFactory;
        this.dataProcessor = dataProcessor;
        this.imagemapProcessor = imagemapProcessor;
    }

    public void setData(Map<String, com.ibm.ba.vis.adapter.DataSet> data, Map<String, Boolean> override) {
        this.instanceData = data;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public Map<String, byte[]> generate(ZipInputStream implementation, String format) {
        HashMap<String, byte[]> outputs = new HashMap<String, byte[]>();
        if ("interactive".equalsIgnoreCase(format)) {
            RaveRenderer renderer = this.rendererFactory.getRenderer(format);
            return renderer.render(this.bundleID, format, this.formatter);
        }
        AWTRaveImageService.getInstance().run((AWTRaveImageServiceRunnable)this, "root");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, "png", baos);
            baos.flush();
            outputs.put("imagemap.xml", this.imagemapProcessor.getAreaShapes().toByteArray());
            outputs.put("image.png", baos.toByteArray());
            baos.close();
        }
        catch (IOException e) {
            logger.error("Error generating the image and the imagemap", (Throwable)e);
            throw new AdapterException(ADAPTER_ERR_STR, (Throwable)e);
        }
        return outputs;
    }

    public void setForceAndaleFont(boolean forceAndaleFont) {
    }

    public void ready(Object arg0) {
        this.bufferedImage = (BufferedImage)arg0;
        this.doImageMap(this.bundleInstance.node().node());
    }

    void doImageMap(SceneNode node) {
        ImageMapArguments args = ImageMap.INSTANCE.makeArguments(node);
        args.types.add("element-*");
        args.types.add("legend-*");
        args.types.add("axis-*");
        ImageMap im = ImageMap.INSTANCE;
        try {
            im.createImageMap(args, (ImageMapCallback)new Rave2ImageMapCallback());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception in doImageMap createImageMap", (Throwable)e);
        }
    }

    public void create(Selector root) {
        String path = CCLConfigurationFactory.getInstance().resolveEffectivePath("../reportstyles/palettes.json");
        File palettes = new File(path);
        try {
            FileInputStream palettesIS = new FileInputStream(palettes);
            JSONObject palettesJson = JSONObject.parse((InputStream)palettesIS);
            JSONArray colorPaletteArray = (JSONArray)palettesJson.get((Object)"ColorPalette");
            Library.palettes.addPalettes(colorPaletteArray);
        }
        catch (IOException | NullPointerException e) {
            logger.error("Error getting the palettes", (Throwable)e);
        }
        this.bundleID = this.bundleName;
        if (this.bundleName.contains(",")) {
            String[] parts = this.bundleName.split(",");
            this.bundleID = parts[0];
            this.configID = parts[1];
        }
        RaveBundle bundle = BundleLookup.getBundle((String)this.bundleID);
        this.bundleInstance = bundle.create(this.configID);
        this.bundleInstance.node(root);
        DataModel dataModel = this.bundleInstance.createDataModel(((DataModelDescriptor)this.bundleInstance.info().dataModels().get(0)).id());
        this.dataProcessor.setBundleName(this.bundleID);
        for (int setId = 0; setId < dataModel.datasets().size(); ++setId) {
            this.dataProcessor.process(this.instanceData, (DataSet)dataModel.datasets().get(setId), setId, this.formatter);
            this.setCustomFormatter(this.bundleInstance, setId);
        }
        this.setProperties(this.bundleInstance);
        this.bundleInstance.render();
    }

    private String doFormat(Object node, Object value, int selectorIndex, int selectorGroup, DataSlotEntry entry, int setId) {
        if (this.formatter == null) {
            return (String)Rave.format.create(this.dataProcessor.getFormatSpecifier(entry.label(), setId)).getValue(node, value, selectorIndex, selectorGroup);
        }
        return this.formatter.formatNumber((Number)value, 0, entry.dataSlot().descriptor().id());
    }

    private void setCustomFormatter(Controller bundleInstance, final int setId) {
        bundleInstance.setCustomFormatter("all", new CustomFormatter(){

            public String getValue(Object node, Object value, int selectorIndex, int selectorGroup, CustomFormatInfo info, boolean doAbbreviatedFormatting) {
                DataSlotEntry entry;
                DataSlotDescriptor slotDescriptor;
                if (doAbbreviatedFormatting) {
                    return null;
                }
                if (!info.entries().isEmpty() && !(slotDescriptor = (entry = (DataSlotEntry)info.entries().get(0)).dataSlot().descriptor()).dataTypes().contains((Object)"string")) {
                    double dValue = 0.0;
                    if (value instanceof String) {
                        dValue = Double.parseDouble((String)value);
                    } else if (value instanceof Double) {
                        dValue = (Double)value;
                    }
                    return RAVEChartAdapter.this.doFormat(node, dValue, selectorIndex, selectorGroup, entry, setId);
                }
                return ObjectConverter.toString((Object)value);
            }
        });
    }

    private void setProperties(Controller bundleInstance) {
        for (Map.Entry<String, Object> property : this.properties.entrySet()) {
            boolean isNotSupported;
            String key = property.getKey();
            if (this.properties.get(key) == null) continue;
            Object value = property.getValue();
            boolean bl = isNotSupported = key.equals("area.borderWidth") && value.toString().endsWith("ex");
            if (isNotSupported) continue;
            bundleInstance.property(key, value);
        }
    }

    public String css() {
        return null;
    }

    public int getHeight() {
        if (this.properties != null && !this.properties.isEmpty() && this.properties.get("height") != null) {
            return Integer.parseInt((String)this.properties.get("height"));
        }
        return 500;
    }

    public int getWidth() {
        if (this.properties != null && !this.properties.isEmpty() && this.properties.get("width") != null) {
            return Integer.parseInt((String)this.properties.get("width"));
        }
        return 500;
    }

    public void setException(Exception e) {
        e.printStackTrace();
        logger.error("Rave 2 exception", (Throwable)e);
        throw new AdapterException(ADAPTER_ERR_STR, (Throwable)e);
    }

    public void setBundleName(String bundleName) {
        this.bundleID = this.bundleName = bundleName;
        if (this.bundleName != null && this.bundleName.contains(",")) {
            String[] parts = bundleName.split(",");
            this.bundleID = parts[0];
            this.configID = parts[1];
        }
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Map<String, byte[]> generate(JSONObject definition, String galleryFolder, String format, Map<String, String> headers) {
        return null;
    }

    public void setLocale(Locale lc) {
    }

    private final class Rave2ImageMapCallback
    implements ImageMapCallback {
        private Rave2ImageMapCallback() {
        }

        public void ready(ImageMapResult result) {
            if (result.errorCode() != 0) {
                return;
            }
            try {
                RAVEChartAdapter.this.imagemapProcessor.startAreaShapes();
                this.processImagemapElement(result);
                RAVEChartAdapter.this.imagemapProcessor.endAreaShapes();
            }
            catch (XMLStreamException e) {
                logger.error("Error creating imagemap", (Throwable)e);
                throw new AdapterException(ADAPTER_ERR_STR, (Throwable)e);
            }
        }

        private void processImagemapElement(ImageMapResult result) throws XMLStreamException {
            boolean debug = false;
            Graphics2D g = this.getGraphicsForDebug(debug);
            for (ImageMapSceneItem sceneItem : result.sceneItems()) {
                ItemTypes itemTypes = new ItemTypes(sceneItem.type());
                if (itemTypes.type.isEmpty() || itemTypes.subType.isEmpty()) continue;
                this.drawElementRowIndexInOutput(sceneItem, sceneItem.data(), debug);
                this.drawOutlineForSceneItem(g, sceneItem, debug);
                try {
                    RAVEChartAdapter.this.imagemapProcessor.startAreaShape(itemTypes.type, itemTypes.subType, sceneItem.points(), "0", sceneItem.data());
                }
                catch (XMLStreamException e) {
                    logger.error("Error processing imagemap", (Throwable)e);
                    throw new AdapterException(ADAPTER_ERR_STR, (Throwable)e);
                }
                RAVEChartAdapter.this.imagemapProcessor.endAreaShape();
            }
        }

        private Graphics2D getGraphicsForDebug(boolean debug) {
            Graphics2D g = null;
            if (debug) {
                g = (Graphics2D)RAVEChartAdapter.this.bufferedImage.getGraphics();
                g.setColor(new Color(0, 255, 0));
                g.setStroke(new BasicStroke(2.0f));
            }
            return g;
        }

        private void drawOutlineForSceneItem(Graphics2D g, ImageMapSceneItem sceneItem, boolean debug) {
            int npts = sceneItem.points().size();
            if (debug && npts > 0) {
                Path2D.Double path = new Path2D.Double();
                for (int i = 0; i < npts; ++i) {
                    PointStruct p = (PointStruct)sceneItem.points().get(i);
                    if (i == 0) {
                        ((Path2D)path).moveTo(p.x, p.y);
                        continue;
                    }
                    ((Path2D)path).lineTo(p.x, p.y);
                }
                path.closePath();
                g.draw(path);
            }
        }

        private void drawElementRowIndexInOutput(ImageMapSceneItem sceneItem, Object data, boolean debug) {
            if (debug && sceneItem.dataType() == 1) {
                List dataList = null;
                if (data != null && data instanceof List) {
                    dataList = (List)data;
                    Graphics2D g = (Graphics2D)RAVEChartAdapter.this.bufferedImage.getGraphics();
                    g.setColor(new Color(0, 255, 0));
                    g.setStroke(new BasicStroke(5.0f));
                    g.drawString(dataList.get(0).toString().replace(".0", ""), (int)((PointStruct)sceneItem.points().get((int)0)).x + 15, (int)((PointStruct)sceneItem.points().get((int)0)).y);
                }
            }
        }

        class ItemTypes {
            String type = "";
            String subType = "";

            ItemTypes(String rave2Type) {
                switch (rave2Type) {
                    case "element-shape": {
                        this.type = "element";
                        this.subType = "main";
                        break;
                    }
                    case "axis-tick": {
                        this.type = "axis";
                        this.subType = "mark";
                        break;
                    }
                    case "legend-tick": {
                        this.type = "legend";
                        this.subType = "swatch";
                        break;
                    }
                    default: {
                        int pos = rave2Type.indexOf(45);
                        this.type = rave2Type.substring(0, pos);
                        this.subType = rave2Type.substring(pos + 1);
                    }
                }
            }
        }
    }
}

