/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave2;

import com.ibm.athena.smartermaps.ISmarterMaps;
import com.ibm.athena.smartermaps.SmarterMaps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmarterMapBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SmarterMapBuilder.class);

    SmarterMapBuilder() {
    }

    static ISmarterMaps create() {
        InputStream stream = SmarterMapBuilder.class.getResourceAsStream("territories.properties");
        Properties disputed = SmarterMapBuilder.loadDisputedTerritories(stream);
        SmarterMaps smartermaps = new SmarterMaps(disputed);
        SmarterMapBuilder.setAliases((ISmarterMaps)smartermaps);
        SmarterMapBuilder.setCustomGroups((ISmarterMaps)smartermaps);
        return smartermaps;
    }

    static Properties loadDisputedTerritories(InputStream stream) {
        Properties disputed = new Properties();
        try {
            if (stream != null) {
                disputed.load(stream);
            }
        }
        catch (IOException e) {
            logger.info("Error loading \"territories.properties\". Defaults will be used.", (Throwable)e);
        }
        return disputed;
    }

    static void setCustomGroups(ISmarterMaps smartermaps) {
        try {
            InputStream groups = SmarterMapBuilder.class.getResourceAsStream("map_groups.csv");
            if (groups != null) {
                smartermaps.addGroups(groups);
            }
        }
        catch (Exception e) {
            logger.info("Error reading resource map_groups.csv, no custom groups will be available.", (Throwable)e);
        }
    }

    static void setAliases(ISmarterMaps smartermaps) {
        try {
            InputStream alias = SmarterMapBuilder.class.getResourceAsStream("map_alias.csv");
            if (alias != null) {
                smartermaps.addAliases(alias);
            }
        }
        catch (Exception e) {
            logger.info("Error reading resource map_alias.csv, no custom aliases will be available.", (Throwable)e);
        }
    }
}

