/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave2;

import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.DataSetField;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.rave.Messages;
import com.ibm.cognos.adapters.rave2.DataProcessor;
import com.ibm.cognos.adapters.rave2.NumberFormatSpecifiers;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlot;
import com.ibm.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.xmlns.prod.ba.visbundle.chartinstance._3_1.DataFormat;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StandardDataProcessor
implements DataProcessor {
    private static final String ADAPTER_ERR_STR = Messages.getString("chartAdapterError");
    private static final String CATEGORY_DATA = "categoryData";
    private static final String ROW_DATA = "rowData";
    private static final String NUMERIC = "numeric";
    private static final String STRING = "string";
    private HashMap<String, HashMap<String, MeasureInfo>> measuresMapSetId = new HashMap();
    private HashMap<String, HashMap<String, String>> fieldsdMapSetId = new HashMap();
    private String bundleName = null;

    @Override
    public void process(Map<String, com.ibm.ba.vis.adapter.DataSet> instanceData, DataSet dataSet, int setId, Formatter formatter) {
        JSONArray instanceDataArray = this.createInstanceDataArray(instanceData, dataSet, setId);
        if (instanceDataArray.isEmpty()) {
            return;
        }
        dataSet.data((Object)Rave.range((Object)instanceDataArray.size()));
        HashMap<String, String> fieldsdMap = this.fieldsdMapSetId.get(Integer.toString(setId));
        HashMap<String, MeasureInfo> measuresMap = this.measuresMapSetId.get(Integer.toString(setId));
        ArrayEx dataSlotArray = dataSet.slots();
        for (DataSlot dataSlot : dataSlotArray) {
            DataSlotDescriptor dataSlotDescriptor = dataSlot.descriptor();
            String id = dataSlotDescriptor.id();
            if (!fieldsdMap.containsKey(id) && !dataSlotDescriptor.isRequired()) {
                dataSet.slot(id).clear();
                continue;
            }
            BigDecimal measureMin = null;
            BigDecimal measureMax = null;
            Integer subDomainDivision = null;
            if (measuresMap.get(id) != null) {
                measureMin = measuresMap.get((Object)id).measureMin;
                measureMax = measuresMap.get((Object)id).measureMax;
                subDomainDivision = measuresMap.get((Object)id).numberFormatSpecifiers.getSubDomainDivision();
            }
            if (measuresMap.get(id) != null) {
                dataSet.slot(id).push().type(NUMERIC).accessor(rowIndex -> {
                    if (!(rowIndex instanceof Number)) {
                        return null;
                    }
                    return ((JSONObject)instanceDataArray.get(((Number)rowIndex).intValue())).get((Object)id);
                }).label(fieldsdMap.get(id));
                if (subDomainDivision != null) {
                    if (measureMin != null && measureMax != null) {
                        dataSet.slot(id).entry().domain(Arrays.asList(measureMin, measureMax), (Number)subDomainDivision);
                        continue;
                    }
                    dataSet.slot(id).entry().domain(null, (Number)subDomainDivision);
                    continue;
                }
                if (measureMin == null || measureMax == null) continue;
                dataSet.slot(id).entry().domain(Arrays.asList(measureMin, measureMax));
                continue;
            }
            dataSet.slot(id).push().type(STRING).accessor(rowIndex -> {
                if (!(rowIndex instanceof Number)) {
                    return null;
                }
                return ((JSONObject)instanceDataArray.get(((Number)rowIndex).intValue())).get((Object)id);
            }).label(fieldsdMap.get(id));
        }
    }

    private JSONArray createInstanceDataArray(Map<String, com.ibm.ba.vis.adapter.DataSet> instanceData, DataSet dataSet, int setId) {
        String dataSetName = dataSet.descriptor().id();
        Set<Map.Entry<String, com.ibm.ba.vis.adapter.DataSet>> entrySet = instanceData.entrySet();
        for (Map.Entry<String, com.ibm.ba.vis.adapter.DataSet> entry : entrySet) {
            JSONArray rowData;
            JSONObject categoryData;
            com.ibm.ba.vis.adapter.DataSet instanceDataSet = entry.getValue();
            String instanceDataSetName = instanceDataSet.getName();
            if (entrySet.size() > 1 && !instanceDataSetName.equals(dataSetName)) continue;
            try {
                JSONObject dataSetData = JSONObject.parse((String)instanceDataSet.getDatSetData());
                categoryData = (JSONObject)dataSetData.get((Object)CATEGORY_DATA);
                rowData = (JSONArray)dataSetData.get((Object)ROW_DATA);
            }
            catch (IOException e) {
                throw new AdapterException(ADAPTER_ERR_STR, (Throwable)e);
            }
            return this.getInstanceData(instanceDataSet, categoryData, rowData, (ArrayEx<DataSlot>)dataSet.slots(), setId);
        }
        return null;
    }

    private int getIndex(Object indexObj) {
        int result = -1;
        if (indexObj != null) {
            if (indexObj instanceof Long) {
                result = ((Long)indexObj).intValue();
            } else if (indexObj instanceof Integer) {
                result = (Integer)indexObj;
            } else if (indexObj instanceof Short) {
                result = ((Short)indexObj).intValue();
            }
        }
        return result;
    }

    private JSONArray getInstanceData(com.ibm.ba.vis.adapter.DataSet dataset, JSONObject categoryData, JSONArray rowData, ArrayEx<DataSlot> dataSlotArray, int setId) {
        JSONArray dataArray = new JSONArray();
        List fieldList = dataset.getDataSetFields();
        HashMap<String, String> fieldsdMap = new HashMap<String, String>();
        HashMap<String, MeasureInfo> measuresMap = new HashMap<String, MeasureInfo>();
        for (int i = 0; i < rowData.size(); ++i) {
            Object row = rowData.get(i);
            JSONArray jRow = (JSONArray)row;
            JSONObject newRow = new JSONObject();
            for (int j = 0; j < jRow.size(); ++j) {
                DataSetField field = (DataSetField)fieldList.get(j);
                if (field.getLabel().isEmpty() && !this.isSlotRequired(dataSlotArray, field)) continue;
                fieldsdMap.putIfAbsent(field.getName(), field.getLabel());
                if (field.getClass().getName().endsWith("DataSetCategoryFieldProxy")) {
                    JSONArray categories = (JSONArray)categoryData.get((Object)field.getName());
                    int numberOfCategories = categories.size();
                    Object indexObj = jRow.get(j);
                    int index = this.getIndex(indexObj);
                    if (index < 0 || index >= numberOfCategories) continue;
                    Object categoryName = categories.get(index);
                    newRow.put((Object)field.getName(), categoryName);
                    continue;
                }
                MeasureInfo measureInfo = new MeasureInfo(field.getLabel(), field.getMin(), field.getMax(), new NumberFormatSpecifiers((DataFormat)field.getDataFormat()));
                measuresMap.put(field.getName(), measureInfo);
                newRow.put((Object)field.getName(), jRow.get(j));
            }
            dataArray.add((Object)newRow);
        }
        this.fieldsdMapSetId.put(Integer.toString(setId), fieldsdMap);
        this.measuresMapSetId.put(Integer.toString(setId), measuresMap);
        return dataArray;
    }

    private boolean isSlotRequired(ArrayEx<DataSlot> dataSlotArray, DataSetField field) {
        for (DataSlot dataSlot : dataSlotArray) {
            DataSlotDescriptor dataSlotDescriptor = dataSlot.descriptor();
            if (!field.getName().equals(dataSlotDescriptor.id())) continue;
            if (!dataSlotDescriptor.isRequired()) break;
            return true;
        }
        return false;
    }

    @Override
    public String getFormatSpecifier(String measureKey, int setId) {
        HashMap<String, MeasureInfo> measuresMap = this.measuresMapSetId.get(Integer.toString(setId));
        if (measuresMap != null) {
            NumberFormatSpecifiers numberFormatSpecifiers = measuresMap.get((Object)measureKey).numberFormatSpecifiers;
            String fill = numberFormatSpecifiers.getFillSpecifier();
            String align = numberFormatSpecifiers.getAlignSpecifier();
            String sign = numberFormatSpecifiers.getSignSpecifier();
            String symbol = numberFormatSpecifiers.getSymbolSpecifier();
            String padding = numberFormatSpecifiers.getPaddingSpecifier();
            String width = numberFormatSpecifiers.getWidthSpecifier();
            String separator = numberFormatSpecifiers.getSeparatorSpecifier();
            String precision = numberFormatSpecifiers.getPrecisionSpecifier();
            String type = numberFormatSpecifiers.getTypeSpecifier();
            return fill + align + sign + symbol + padding + width + separator + precision + type;
        }
        return "";
    }

    @Override
    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    class MeasureInfo {
        String measureName = "";
        BigDecimal measureMin = null;
        BigDecimal measureMax = null;
        NumberFormatSpecifiers numberFormatSpecifiers = null;

        public MeasureInfo(String measureName, BigDecimal measureMin, BigDecimal measureMax, NumberFormatSpecifiers numberFormatSpecifiers) {
            this.measureName = measureName;
            this.measureMin = measureMin;
            this.measureMax = measureMax;
            this.numberFormatSpecifiers = numberFormatSpecifiers;
        }
    }
}

