/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave2.render;

import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.cognos.adapters.rave.Messages;
import com.ibm.cognos.adapters.rave.imagemap.beans.AreaShape;
import com.ibm.cognos.adapters.rave.imagemap.beans.AreaShapes;
import com.ibm.cognos.adapters.rave2.render.BaseImageRenderer;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.configuration.IVisConfiguration;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.services.VisImageService;
import com.ibm.vis.ui.awt.VisControl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ImageMapRenderer
extends BaseImageRenderer {
    private static final String VIS_NAME = "com.ibm.cognos.adapters.rave2.render.ImageMapRenderer";
    private final JAXBContext imageMapContext;

    ImageMapRenderer() {
        super(VIS_NAME);
        try {
            this.imageMapContext = JAXBContext.newInstance((Class[])new Class[]{AreaShapes.class});
        }
        catch (JAXBException e) {
            throw new AdapterException("Error creating JAXB context for ImageMapRenderer", (Throwable)e);
        }
    }

    @Override
    Map<String, byte[]> generate(JSONObject spec, VisControl control) throws IOException {
        HashMap<String, byte[]> images;
        try {
            images = new HashMap<String, byte[]>();
            ByteArrayOutputStream image = new ByteArrayOutputStream();
            SceneItem[] areaShapes = VisImageService.generateImageWithImageMap((JSONObject)spec, (OutputStream)image, (String)"png", null, null, null, null, (IVisConfiguration)control);
            images.put("image.png", image.toByteArray());
            ByteArrayOutputStream areaShapeStream = new ByteArrayOutputStream();
            Marshaller marshaller = this.imageMapContext.createMarshaller();
            marshaller.marshal((Object)this.createAreaShapes(areaShapes), (OutputStream)areaShapeStream);
            images.put("imagemap.xml", areaShapeStream.toByteArray());
        }
        catch (JAXBException e) {
            String message = Messages.getString("failedToCreateImagemapXML");
            throw new AdapterException(message, (Throwable)e);
        }
        return images;
    }

    private AreaShapes createAreaShapes(SceneItem[] shapes) {
        AreaShapes areaShapes = new AreaShapes();
        for (SceneItem areaShape : shapes) {
            areaShapes.getAreaShape().add(AreaShape.createAreaShapeBean(areaShape));
        }
        return areaShapes;
    }
}

