/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.rave2.render;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.rave.Messages;
import com.ibm.cognos.adapters.rave2.render.RaveRenderer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractiveRenderer
implements RaveRenderer {
    private static final Logger logger = LoggerFactory.getLogger(InteractiveRenderer.class);
    private String adapterPath = CCLConfigurationFactory.getInstance().resolveEffectivePath("../templates/rsvp/bundles");

    InteractiveRenderer() {
    }

    @Override
    public Map<String, byte[]> render(String bundleName, String mimeType, Formatter formatter) {
        HashMap<String, byte[]> outputs = new HashMap<String, byte[]>();
        StringBuilder name = new StringBuilder(bundleName);
        name.append(".min.js");
        this.addOutput(name.toString(), bundleName, outputs);
        return outputs;
    }

    private void addOutput(String key, String path, Map<String, byte[]> outputs) {
        StringBuilder builder = new StringBuilder(this.adapterPath);
        builder.append("/");
        builder.append(path);
        builder.append("/");
        builder.append(key);
        File filePath = new File(builder.toString());
        if (filePath.exists()) {
            outputs.put(key, this.readFully(filePath));
        }
    }

    private byte[] readFully(File filePath) {
        byte[] result = null;
        try (FileInputStream ins = new FileInputStream(filePath);){
            result = new byte[(int)filePath.length()];
            IOUtils.readFully((InputStream)ins, (byte[])result);
        }
        catch (IOException e) {
            logger.error("Error reading .js from bundle", (Throwable)e);
            throw new AdapterException(Messages.getString("chartAdapterError"), (Throwable)e);
        }
        return result;
    }
}

