/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida;

import com.ibm.ba.vis.adapter.Adapter;
import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.ba.vis.adapter.DataSet;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.rave2.Messages;
import com.ibm.cognos.adapters.vida.VIDACatPalette;
import com.ibm.cognos.adapters.vida.VIDAContPalette;
import com.ibm.cognos.adapters.vida.VIDAPalette;
import com.ibm.cognos.adapters.vida.VIDAPalettes;
import com.ibm.cognos.adapters.vida.data.VIPRData;
import com.ibm.cognos.adapters.vida.data.VIPRDataPoint;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.vipr.VIPR;
import com.ibm.vipr.api.ICatPaletteResolver;
import com.ibm.vipr.api.IColor;
import com.ibm.vipr.api.IContPaletteResolver;
import com.ibm.vipr.api.IContStops;
import com.ibm.vipr.api.IHostAPI;
import com.ibm.vipr.api.IImageMapEntry;
import com.ibm.vipr.api.IPoint;
import com.ibm.vipr.api.IVisualizationImage;
import com.ibm.vipr.api.IVizBundle;
import com.ibm.vipr.api.IVizService;
import com.ibm.vipr.api.IVizServiceNotification;
import com.ibm.vipr.api.IVizServiceRequest;
import com.ibm.vipr.api.PaletteType;
import com.ibm.vipr.data.IContDomain;
import com.ibm.vipr.data.ISlotMapping;
import com.ibm.vipr.data.IVIPRData;
import com.ibm.vipr.data.IVIPRDataNode;
import com.ibm.vipr.info.ICatDataItemInfo;
import com.ibm.vipr.info.IContDataItemInfo;
import com.ibm.vipr.info.IInfo;
import com.ibm.vipr.info.ITupleInfo;
import com.ibm.vipr.property.IVizPaletteProperty;
import com.ibm.vipr.property.IVizProperties;
import com.ibm.vipr.property.IVizValueProperty;
import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.renderingservice.api.ICustomDataDecorated;
import com.ibm.vipr.renderingservice.api.IRenderSurface;
import com.ibm.vipr.vizdef.PropertyOverride;
import com.ibm.vipr.vizdef.UserConfig;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VIDAChartAdapter
implements Adapter {
    private static final Logger logger = LoggerFactory.getLogger(VIDAChartAdapter.class);
    private static final String ADAPTER_ERR_STR = Messages.getString("chartAdapterError");
    private static VIPR vipr = VIPR.create();
    private String bundleId = null;
    private Map<String, DataSet> instanceData = null;
    private Map<String, Object> properties = null;
    private Formatter formatter = null;
    private Locale locale = null;
    private UserConfig config = null;

    public void setData(Map<String, DataSet> data, Map<String, Boolean> override) {
        this.instanceData = data;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public Map<String, byte[]> generate(ZipInputStream implementation, String format) {
        return null;
    }

    public void setForceAndaleFont(boolean forceAndaleFont) {
    }

    public void setBundleName(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleName() {
        return null;
    }

    private void setDefaultProperties(IVizService _service) {
        if (this.properties != null) {
            IVizProperties vizProps = _service.getProperties();
            vizProps.set("rave.legend.display", (Object)Boolean.TRUE);
        }
    }

    private void setProperties(IVizService _service) {
        if (this.properties != null) {
            IVizProperties vizProps = _service.getProperties();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                vizProps.set(entry.getKey(), entry.getValue());
            }
        }
    }

    private ByteArrayOutputStream getAreaShapes(List<IImageMapEntry> imageMap) throws XMLStreamException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(result);
        writer.writeStartDocument();
        writer.writeStartElement("AreaShapes");
        for (IImageMapEntry entry : imageMap) {
            List points;
            IInfo info;
            IVIPRDataNode dataNode;
            List data;
            writer.writeStartElement("AreaShape");
            if (entry.getType() != null && !entry.getType().isEmpty()) {
                writer.writeAttribute("type", entry.getType());
            }
            if (entry.getSubType() != null && !entry.getSubType().isEmpty()) {
                writer.writeAttribute("subType", entry.getSubType());
            }
            if ((data = entry.getData()) != null && data.size() > 0 && (dataNode = (info = (IInfo)data.get(0)).getSource()) instanceof VIPRDataPoint) {
                VIPRDataPoint dataPoint = (VIPRDataPoint)dataNode;
                writer.writeAttribute("dataIndex", Integer.toString(dataPoint.getDataSetIndex()));
            }
            if ((points = entry.getPoints()) != null && points.size() > 0) {
                writer.writeStartElement("points");
                for (IPoint point : points) {
                    writer.writeStartElement("point");
                    writer.writeStartElement("x");
                    writer.writeCharacters(Double.toString(point.getX()));
                    writer.writeEndElement();
                    writer.writeStartElement("y");
                    writer.writeCharacters(Double.toString(point.getY()));
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (data != null && data.size() > 0) {
                writer.writeStartElement("rows");
                for (IInfo info2 : data) {
                    IVIPRDataNode dataNode2 = info2.getSource();
                    if (!(dataNode2 instanceof VIPRDataPoint)) continue;
                    VIPRDataPoint dataPoint = (VIPRDataPoint)dataNode2;
                    writer.writeEmptyElement("row");
                    writer.writeAttribute("value", Integer.toString(dataPoint.getRowIndex()));
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        return result;
    }

    private ByteArrayOutputStream getMessages(List<IVizServiceNotification> notifications) throws XMLStreamException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(result);
        writer.writeStartDocument();
        writer.writeStartElement("Notifications");
        for (IVizServiceNotification entry : notifications) {
            writer.writeStartElement("Notification");
            if (entry.getId() != null && !entry.getId().isEmpty()) {
                writer.writeAttribute("id", entry.getId());
            }
            if (entry.getLevel() != null && !entry.getLevel().isEmpty()) {
                writer.writeAttribute("level", entry.getLevel());
            }
            if (entry.getMessage() != null && !entry.getMessage().isEmpty()) {
                writer.writeCharacters(entry.getMessage());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        return result;
    }

    private UserConfig getUserConfig() {
        if (this.config == null) {
            HashMap<String, PropertyOverride> overrides = new HashMap<String, PropertyOverride>();
            overrides.put("rave.legend.display", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.display")));
            overrides.put("rave.legend.titlevisible", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.titlevisible")));
            overrides.put("rave.legend.position", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.position")));
            overrides.put("rave.legend.size", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.size")));
            overrides.put("rave.legend.titleColor", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.titleColor")));
            overrides.put("rave.legend.color", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.color")));
            overrides.put("rave.legend.fontSize", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.fontSize")));
            overrides.put("rave.legend.font", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.font")));
            overrides.put("rave.legend.titleFont", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.titleFont")));
            overrides.put("rave.legend.backgroundColor", PropertyOverride.create((String)PropertyOverride.DEFAULT_CAPTION, (String)PropertyOverride.DEFAULT_DESCRIPTION, (Object)PropertyOverride.DEFAULT_VALUE, Arrays.asList("widget.legend.backgroundColor")));
            this.config = UserConfig.create(null, null, overrides, null, null, null);
        }
        return this.config;
    }

    private IRenderSurface createRenderSurface() {
        RenderSurface result = new RenderSurface();
        if (this.properties != null) {
            String vcWidth = (String)this.properties.get("vcWidth");
            String vcHeight = (String)this.properties.get("vcHeight");
            if (!(vcWidth == null || vcWidth.endsWith("%") || vcWidth.endsWith("em") || vcWidth.endsWith("ex"))) {
                Double width = CSSConverter.convertCSSSizeToPixelNumber((Object)vcWidth, (double)100.0, (double)10.0);
                if (width != null) {
                    result.setWidth(width.intValue());
                }
            } else {
                String vcServerDefaultWidth = (String)this.properties.get("vcServerDefaultWidth");
                if (vcServerDefaultWidth != null && !vcServerDefaultWidth.isEmpty()) {
                    result.setWidth(Integer.valueOf(vcServerDefaultWidth));
                }
            }
            if (!(vcHeight == null || vcHeight.endsWith("%") || vcHeight.endsWith("em") || vcHeight.endsWith("ex"))) {
                Double height = CSSConverter.convertCSSSizeToPixelNumber((Object)vcHeight, (double)100.0, (double)10.0);
                if (height != null) {
                    result.setHeight(height.intValue());
                }
            } else {
                String vcServerDefaultHeight = (String)this.properties.get("vcServerDefaultHeight");
                if (vcServerDefaultHeight != null && !vcServerDefaultHeight.isEmpty()) {
                    result.setHeight(Integer.valueOf(vcServerDefaultHeight));
                }
            }
        }
        return result;
    }

    private void setPalettes(IVizService _service, Map<String, String> headers, JSONObject defaultPalettes) {
        JSONArray categories = null;
        JSONArray continuous = null;
        if (defaultPalettes != null) {
            Set entrySet = defaultPalettes.entrySet();
            for (Map.Entry entry : entrySet) {
                if (((String)entry.getKey()).equals("categorical")) {
                    categories = (JSONArray)entry.getValue();
                    continue;
                }
                if (!((String)entry.getKey()).equals("continuous")) continue;
                continuous = (JSONArray)entry.getValue();
            }
        }
        int catIndex = 0;
        int contIndex = 0;
        for (IVizValueProperty vizProp : _service.getProperties()) {
            String alias;
            if (vizProp.getType() != PropertyType.Palette) continue;
            IVizPaletteProperty paletteProp = (IVizPaletteProperty)vizProp;
            Object id = null;
            Iterator iterator = vizProp.getAliases().iterator();
            while (iterator.hasNext() && (id = this.properties.get(alias = (String)iterator.next())) == null) {
            }
            if (id == null) {
                String name = vizProp.getName();
                id = this.properties.get(name);
            }
            if (paletteProp.getPaletteType() == PaletteType.Cat) {
                if (id == null && categories != null && categories.size() > catIndex) {
                    id = categories.get(catIndex);
                }
                ++catIndex;
            } else if (paletteProp.getPaletteType() == PaletteType.Cont) {
                if (id == null && continuous != null && continuous.size() > contIndex) {
                    id = continuous.get(contIndex);
                }
                ++contIndex;
            }
            if (id == null || !(id instanceof String)) continue;
            VIDAPalette vPalette = VIDAPalettes.getInstance().getPalette((String)id);
            if (vPalette == null) {
                vPalette = VIDAPalettes.getInstance().getCMPalette((String)id, headers);
            }
            if (vPalette == null || vPalette.getType() != paletteProp.getPaletteType()) continue;
            if (paletteProp.getPaletteType() == PaletteType.Cat) {
                paletteProp.setValue((Object)new CatPaletteResolver((VIDACatPalette)vPalette));
                continue;
            }
            if (paletteProp.getPaletteType() != PaletteType.Cont) continue;
            paletteProp.setValue((Object)new ContPaletteResolver((VIDAContPalette)vPalette));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> generate(JSONObject definition, String galleryFolder, String format, Map<String, String> headers) {
        HashMap<String, byte[]> outputs = new HashMap<String, byte[]>();
        if (definition.containsKey((Object)"location")) {
            StringBuilder builder = new StringBuilder(galleryFolder);
            builder.append("/templates/rsvp/viz/");
            builder.append(definition.get((Object)"location"));
            try {
                URL url = new File(builder.toString()).toURI().normalize().toURL();
                VIPR vIPR = vipr;
                synchronized (vIPR) {
                    if (!vipr.isRegistered(this.bundleId)) {
                        UserConfig userConfig = this.getUserConfig();
                        vipr.register(this.bundleId, url, userConfig, null, null);
                    }
                }
                IRenderSurface surface = this.createRenderSurface();
                HostAPI hostApi = new HostAPI();
                ((CompletableFuture)vipr.newViz(this.bundleId, this.locale, "image", surface, (IHostAPI)hostApi, null).thenCompose(_service -> {
                    try {
                        IVizBundle bundle = _service.getVizBundle();
                        VIPRData data = VIPRData.create(bundle, this.instanceData, this.formatter);
                        _service.setData((IVIPRData)data, (ISlotMapping)data);
                        if (definition.containsKey((Object)"propertyConfiguration")) {
                            IVizProperties properties = _service.getProperties();
                            JSONObject configuration = (JSONObject)definition.get((Object)"propertyConfiguration");
                            Set entrySet = configuration.entrySet();
                            for (Map.Entry entry : entrySet) {
                                properties.set((String)entry.getKey(), entry.getValue());
                            }
                        }
                        JSONObject defaultPalettes = null;
                        if (definition.containsKey((Object)"paletteDefaults")) {
                            defaultPalettes = (JSONObject)definition.get((Object)"paletteDefaults");
                        }
                        this.setDefaultProperties((IVizService)_service);
                        this.setProperties((IVizService)_service);
                        this.setPalettes((IVizService)_service, headers, defaultPalettes);
                        CompletionStage completionStage = _service.render().thenAccept(_op -> {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            try {
                                IVisualizationImage img = (IVisualizationImage)_op.getData();
                                List imageMap = img.getImageMap();
                                ImageIO.write((RenderedImage)img.getImageData(), "png", baos);
                                baos.flush();
                                ByteArrayOutputStream areaShapes = this.getAreaShapes(imageMap);
                                List<IVizServiceNotification> notifications = hostApi.getNotifications();
                                if (notifications != null && notifications.size() > 0) {
                                    ByteArrayOutputStream messages = this.getMessages(notifications);
                                    outputs.put("messages.xml", messages.toByteArray());
                                }
                                outputs.put("imagemap.xml", areaShapes.toByteArray());
                                outputs.put("image.png", baos.toByteArray());
                                baos.close();
                            }
                            catch (IOException | XMLStreamException e) {
                                logger.error("Error generating the image and the imagemap", (Throwable)e);
                                throw new AdapterException(ADAPTER_ERR_STR, (Throwable)e);
                            }
                        });
                        return completionStage;
                    }
                    finally {
                        _service.destroy();
                    }
                })).exceptionally(_t -> {
                    _t.printStackTrace();
                    logger.error("Error creating visualization", _t);
                    throw new AdapterException(ADAPTER_ERR_STR, _t);
                });
            }
            catch (MalformedURLException e) {
                logger.error("Invalid Visualization Location", (Throwable)e);
                throw new AdapterException(ADAPTER_ERR_STR, (Throwable)e);
            }
        }
        return outputs;
    }

    public void setLocale(Locale lc) {
        this.locale = lc;
    }

    private static class ContPaletteResolver
    implements IContPaletteResolver {
        private VIDAContPalette palette;

        public ContPaletteResolver(VIDAContPalette palette) {
            this.palette = palette;
        }

        public IContStops getColorStops(IContDataItemInfo _dataItem, IContDomain _domain) {
            return this.palette.getColorStops();
        }
    }

    private static class CatPaletteResolver
    implements ICatPaletteResolver {
        private VIDACatPalette palette;

        public CatPaletteResolver(VIDACatPalette palette) {
            this.palette = palette;
        }

        public IColor getColor(ITupleInfo _tuple, ICatDataItemInfo _dataItem, int _level) {
            int index = 0;
            if (_tuple != null) {
                index = _tuple.getIndex();
            }
            return this.palette.getColor(index % this.palette.size());
        }
    }

    private static class RenderSurface
    implements IRenderSurface {
        private int width = 500;
        private int height = 500;

        private RenderSurface() {
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Object getSurface() {
            return null;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }

    private static class HostAPI
    implements IHostAPI {
        private List<IVizServiceNotification> notifications = new ArrayList<IVizServiceNotification>();

        private HostAPI() {
        }

        public void request(IVizServiceRequest _request) {
        }

        public void notify(IVizServiceNotification notification) {
            this.notifications.add(notification);
        }

        public void setCustomData(String arg0, List<ICustomDataDecorated> arg1) {
        }

        public List<IVizServiceNotification> getNotifications() {
            return this.notifications;
        }
    }
}

