/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida;

import com.ibm.cognos.adapters.vida.VIDAPalette;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vipr.api.IColor;
import com.ibm.vipr.api.IColorStop;
import com.ibm.vipr.api.IContStops;
import com.ibm.vipr.api.PaletteType;
import com.ibm.vipr.util.Color;
import java.util.ArrayList;
import java.util.List;

public class VIDAContPalette
extends VIDAPalette {
    private IContStops contStops = null;

    public VIDAContPalette(String id, JSONObject jPalette) {
        super(id, PaletteType.Cont);
        JSONArray array = (JSONArray)jPalette.get((Object)"fills");
        if (array != null) {
            ArrayList<IColorStop> colors = new ArrayList<IColorStop>();
            for (JSONObject jStop : array) {
                IColor color;
                String jColor = (String)jStop.get((Object)"fill");
                Number jAt = (Number)jStop.get((Object)"at");
                Number jValue = (Number)jStop.get((Object)"value");
                if (jColor == null || (color = Color.fromString((String)jColor)) == null) continue;
                ColorStop stop = new ColorStop(color, jAt, jValue);
                colors.add(stop);
            }
            this.contStops = new ContStops(colors, true);
        }
    }

    public IContStops getColorStops() {
        return this.contStops;
    }

    private static class ColorStop
    implements IColorStop {
        private IColor color = null;
        private Number at = null;
        private Number value = null;

        public ColorStop(IColor color, Number at, Number value) {
            this.color = color;
            this.at = at;
            this.value = value;
        }

        public IColor getColor() {
            return this.color;
        }

        public Number getAt() {
            return this.at;
        }

        public Number getValue() {
            return this.value;
        }
    }

    private static class ContStops
    implements IContStops {
        private final List<IColorStop> stops;
        private final boolean interpolate;

        public ContStops(List<IColorStop> stops, boolean interpolate) {
            this.stops = stops;
            this.interpolate = interpolate;
        }

        public List<IColorStop> getStops() {
            return this.stops;
        }

        public boolean mustInterpolate() {
            return this.interpolate;
        }
    }
}

