/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.ba.vis.adapter.AdapterException;
import com.ibm.cognos.adapters.rave2.Messages;
import com.ibm.cognos.adapters.vida.VIDACatPalette;
import com.ibm.cognos.adapters.vida.VIDAContPalette;
import com.ibm.cognos.adapters.vida.VIDAPalette;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class VIDAPalettes {
    private static VIDAPalettes instance = null;
    private Map<String, VIDAPalette> palettes = new HashMap<String, VIDAPalette>();
    private String baseURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VIDAPalettes getInstance() {
        Class<VIDAPalettes> clazz = VIDAPalettes.class;
        synchronized (VIDAPalettes.class) {
            if (instance == null) {
                instance = new VIDAPalettes();
                instance.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private VIDAPalette parsePalette(JSONObject jPalette) {
        VIDAPalette palette = null;
        String id = (String)jPalette.get((Object)"id");
        String fillType = (String)jPalette.get((Object)"fillType");
        if (fillType != null) {
            if (fillType.equals("simple")) {
                palette = new VIDACatPalette(id, jPalette);
            } else if (fillType.equals("continuous")) {
                palette = new VIDAContPalette(id, jPalette);
            }
        }
        return palette;
    }

    private void init() {
        ICCLConfiguration config = CCLConfigurationFactory.getInstance();
        String path = config.resolveEffectivePath("../templates/rsvp/irot/reportstyles/palettes.json");
        File palettesJson = new File(path);
        if (palettesJson.exists()) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(palettesJson), "UTF-8");
                JSONObject root = OrderedJSONObject.parse((Reader)reader);
                JSONArray colorPalettes = (JSONArray)root.get((Object)"ColorPalette");
                for (int count = 0; count < colorPalettes.size(); ++count) {
                    JSONObject jPalette = (JSONObject)colorPalettes.get(count);
                    VIDAPalette palette = this.parsePalette(jPalette);
                    if (palette == null) continue;
                    this.palettes.put(palette.getId(), palette);
                }
            }
            catch (IOException e) {
                String msg = Messages.getString("unableToParsePalettes");
                throw new AdapterException(msg, (Throwable)e);
            }
        }
        try {
            String dispatcherURL = config.getValue("internalDispatcher", false);
            URL url = new URL(dispatcherURL);
            StringBuilder restURL = new StringBuilder();
            if (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https")) {
                restURL.append(url.getProtocol());
                restURL.append("://");
                restURL.append(url.getHost());
                restURL.append(":");
                restURL.append(url.getPort());
                this.baseURL = restURL.toString();
            }
        }
        catch (CCLConfigurationException | MalformedURLException throwable) {
            // empty catch block
        }
    }

    public VIDAPalette getPalette(String id) {
        return this.palettes.get(id);
    }

    public VIDAPalette getCMPalette(String id, Map<String, String> headers) {
        VIDAPalette palette = null;
        try {
            JSONObject content;
            JSONObject obj;
            StringBuilder restURL = new StringBuilder(this.baseURL);
            restURL.append("/bi/v1/palettes/");
            restURL.append(id);
            URL url = new URL(restURL.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            InputStreamReader reader = new InputStreamReader(connection.getInputStream(), "UTF-8");
            JSONObject root = OrderedJSONObject.parse((Reader)reader);
            JSONArray array = (JSONArray)root.get((Object)"data");
            if (array.size() > 0 && (obj = (JSONObject)array.get(0)) != null && (content = (JSONObject)obj.get((Object)"content")) != null) {
                palette = this.parsePalette(content);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return palette;
    }
}

