/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida.data;

import com.ibm.cognos.adapters.vida.data.VIPRDataItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MeasureGroups {
    private Map<String, Integer> measureGroups = new HashMap<String, Integer>();
    private List<Integer> measureCountList = new ArrayList<Integer>();

    public void put(String slot, int numberOfMeasures) {
        Integer index = this.measureGroups.size();
        this.measureGroups.put(slot, index);
        this.measureCountList.add(numberOfMeasures);
    }

    public MeasureGroupsIterator iterator() {
        return new MeasureGroupsIterator();
    }

    public class MeasureGroupsIterator {
        public int[] measureIndicies = null;

        public MeasureGroupsIterator() {
            this.measureIndicies = new int[MeasureGroups.this.measureGroups.size()];
        }

        public boolean hasNext() {
            boolean result = false;
            if (this.measureIndicies.length > 0 && MeasureGroups.this.measureCountList.size() > 0) {
                for (int count = 0; !result && count < MeasureGroups.this.measureCountList.size() && count < this.measureIndicies.length; ++count) {
                    if (this.measureIndicies[count] >= (Integer)MeasureGroups.this.measureCountList.get(count) - 1) continue;
                    result = true;
                }
            }
            return result;
        }

        public void next() {
            if (this.measureIndicies.length > 0 && MeasureGroups.this.measureCountList.size() > 0) {
                boolean done = false;
                for (int count = this.measureIndicies.length - 1; !done && count >= 0; --count) {
                    int n = count;
                    this.measureIndicies[n] = this.measureIndicies[n] + 1;
                    if (this.measureIndicies[count] < (Integer)MeasureGroups.this.measureCountList.get(count)) {
                        done = true;
                        continue;
                    }
                    if (count <= 0) continue;
                    this.measureIndicies[count] = 0;
                    int n2 = count - 1;
                    this.measureIndicies[n2] = this.measureIndicies[n2] + 1;
                }
            }
        }

        public void first() {
            for (int index = 0; index < this.measureIndicies.length; ++index) {
                this.measureIndicies[index] = 0;
            }
        }

        public boolean hasMeasureIndex(VIPRDataItem item) {
            return MeasureGroups.this.measureGroups.containsKey(item.getRefSlot() != null ? item.getRefSlot() : item.getName());
        }

        public int getMeasureIndex(VIPRDataItem item) {
            int result = 0;
            Integer index = (Integer)MeasureGroups.this.measureGroups.get(item.getRefSlot() != null ? item.getRefSlot() : item.getName());
            if (index != null && index < this.measureIndicies.length) {
                result = this.measureIndicies[index];
            }
            return result;
        }
    }
}

