/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida.data;

import com.ibm.ba.vis.adapter.DataSetBaseline;
import com.ibm.vida.vizbundles.extensions.decorations.Orientation;
import com.ibm.vida.vizbundles.extensions.decorations.lines.BaseLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.BaseLinePositionTypes;
import com.ibm.vipr.api.IColor;
import com.ibm.vipr.renderingservice.property.Length;
import com.ibm.vipr.util.Color;
import java.math.BigDecimal;

public class VIPRBaseline
extends BaseLine {
    private static final String DATA_VALUE = "DATA_VALUE";
    private static final String TUPLE_INDEX = "TUPLE_IDX";
    private static final String RELATIVE_PERCENT = "RELATIVE_PCT";
    private static final String STATIC_PERCENT = "STATIC_PCT";
    private static final String DATAVALUE = "dataValue";
    private static final String TUPLEINDEX = "tupleIndex";
    private static final String RELATIVEPERCENT = "relativePercent";
    private static final String STATICPERCENT = "staticPercent";

    public VIPRBaseline(String _id, double _position, BaseLinePositionTypes _positionType) {
        super(_id, _position, _positionType);
    }

    public static VIPRBaseline create(DataSetBaseline dataSetBaseline, int index) {
        VIPRBaseline viprBaseline = null;
        String type = dataSetBaseline.getPositionType();
        BigDecimal value = dataSetBaseline.getPosition();
        if (value != null && VIPRBaseline.isSupported(type)) {
            double positionValue = VIPRBaseline.getPositionValue(value, type);
            BaseLinePositionTypes positionTypes = BaseLinePositionTypes.parse((String)VIPRBaseline.getPositionType(type));
            viprBaseline = new VIPRBaseline(String.valueOf(index), positionValue, positionTypes);
            String label = dataSetBaseline.getLabel();
            if (label != null && !label.isEmpty()) {
                viprBaseline.setTitle(dataSetBaseline.getLabel());
                viprBaseline.setShowInLegend(true);
                if (dataSetBaseline.hasCaption()) {
                    viprBaseline.setCaption(dataSetBaseline.getLabel());
                    String orientation = dataSetBaseline.getCaptionOrientation();
                    if (orientation != null && !orientation.isEmpty()) {
                        viprBaseline.setCaptionOrientation(Orientation.parse((String)orientation));
                    }
                }
            }
            viprBaseline.setLineWidth(Length.parse((String)dataSetBaseline.getLineWeight()));
            viprBaseline.setColor(Color.toRSColor((IColor)Color.fromString((String)dataSetBaseline.getLineColor())));
            viprBaseline.setDashStyle(viprBaseline.getDashStyle(dataSetBaseline.getLineStyle()));
        }
        return viprBaseline;
    }

    private static boolean isSupported(String type) {
        switch (type) {
            case "dataValue": 
            case "tupleIndex": 
            case "staticPercent": {
                return true;
            }
        }
        return false;
    }

    private static double getPositionValue(BigDecimal value, String type) {
        switch (type) {
            case "tupleIndex": {
                return value.intValue() - 1;
            }
            case "staticPercent": {
                return value.doubleValue() / 100.0;
            }
        }
        return value.doubleValue();
    }

    private static String getPositionType(String type) {
        switch (type) {
            case "dataValue": {
                return DATA_VALUE;
            }
            case "tupleIndex": {
                return TUPLE_INDEX;
            }
            case "relativePercent": {
                return RELATIVE_PERCENT;
            }
            case "staticPercent": {
                return STATIC_PERCENT;
            }
        }
        return DATA_VALUE;
    }

    private int[] getDashStyle(String lineStyle) {
        int[] styles = null;
        switch (lineStyle) {
            case "dash": {
                styles = new int[]{8, 4};
                break;
            }
            case "dot": {
                styles = new int[]{1, 4};
                break;
            }
            case "dash_dot": {
                styles = new int[]{8, 4, 1, 4};
                break;
            }
        }
        return styles;
    }
}

