/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida.data;

import com.ibm.ba.vis.adapter.DataSetColumn;
import com.ibm.ba.vis.adapter.DataSetField;
import com.ibm.cognos.adapters.vida.data.DataSetData;
import com.ibm.cognos.adapters.vida.data.VIPRDataItem;
import com.ibm.cognos.adapters.vida.data.VIPRItem;
import com.ibm.cognos.adapters.vida.data.VIPRItemClassSet;
import com.ibm.cognos.adapters.vida.data.VIPRTuple;
import com.ibm.json.java.JSONArray;
import com.ibm.vipr.data.DataItemType;
import com.ibm.vipr.data.ICatDataItem;
import com.ibm.vipr.data.IItemClassSet;
import com.ibm.vipr.data.ITuple;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class VIPRCatDataItem
extends VIPRDataItem
implements ICatDataItem {
    private List<IItemClassSet> itemClassSets = new ArrayList<IItemClassSet>();
    private List<VIPRTuple> tuples = new ArrayList<VIPRTuple>();
    private List<Integer> indexMap = new ArrayList<Integer>();
    private String refSlot = null;
    private int measureCount = 0;
    private DataItemType type = DataItemType.Cat;

    public DataItemType getType() {
        return this.type;
    }

    public int getItemClassSetCount() {
        return this.itemClassSets.size();
    }

    public IItemClassSet getItemClassSet(int _index) {
        return this.itemClassSets.get(_index);
    }

    public int getTupleCount() {
        return this.tuples.size();
    }

    public int getDataWindowStart() {
        return 0;
    }

    public int getDataWindowEnd() {
        return this.tuples.size();
    }

    public ITuple getTuple(int _indexOnDataItem) {
        return this.tuples.get(_indexOnDataItem);
    }

    @Override
    public Integer mapTupleIndex(Integer tupleIndex) {
        if (this.indexMap.size() > 0 && tupleIndex < this.indexMap.size()) {
            return this.indexMap.get(tupleIndex);
        }
        return super.mapTupleIndex(tupleIndex);
    }

    @Override
    public String getRefSlot() {
        return this.refSlot;
    }

    @Override
    public Object getDataValue(JSONArray row) {
        Object value;
        Integer result = null;
        Integer index = this.getItemIndex();
        if (index != null && index < row.size() && (value = row.get(index.intValue())) != null) {
            Integer mapped;
            Integer tupleIndex = 0;
            if (value instanceof Long) {
                tupleIndex = ((Long)value).intValue();
            } else if (value instanceof Integer) {
                tupleIndex = (Integer)value;
            }
            result = mapped = this.mapTupleIndex(tupleIndex);
        }
        return result;
    }

    @Override
    public Object getDataValue(JSONArray row, int measureIndex) {
        Integer result = null;
        Integer index = this.getItemIndex();
        if (index != null && index < row.size()) {
            Object value = row.get(index.intValue());
            if (value != null) {
                Integer mapped;
                Integer tupleIndex = 0;
                if (value instanceof Long) {
                    tupleIndex = ((Long)value).intValue();
                } else if (value instanceof Integer) {
                    tupleIndex = (Integer)value;
                }
                result = mapped = this.mapTupleIndex(tupleIndex + measureIndex);
            }
        } else {
            result = measureIndex;
        }
        return result;
    }

    private Map<Integer, TupleKey> createKeys(DataSetData data, DataSetField slot) {
        int keyIndex = 0;
        TreeMap<Integer, TupleKey> result = new TreeMap<Integer, TupleKey>();
        TreeMap<TupleKey, Integer> keys = new TreeMap<TupleKey, Integer>();
        List<Integer> indexList = this.getItemIndexList();
        JSONArray rows = data.getRows();
        if (rows != null) {
            for (JSONArray row : rows) {
                if (row == null) continue;
                if (this.getItemIndex() == null) {
                    this.setItemIndex(row.size());
                }
                TupleKey key = new TupleKey();
                for (Integer index : indexList) {
                    if (index != null && index < row.size()) {
                        Integer tupleIndex = null;
                        Object value = row.get(index.intValue());
                        if (value instanceof Integer) {
                            tupleIndex = (Integer)value;
                        } else if (value instanceof Long) {
                            tupleIndex = ((Long)value).intValue();
                        }
                        key.add(tupleIndex);
                        continue;
                    }
                    key.add(null);
                }
                Integer kIndex = (Integer)keys.get(key);
                if (kIndex == null) {
                    kIndex = keyIndex;
                    keys.put(key, kIndex);
                    result.put(kIndex, key);
                    keyIndex += slot != null ? slot.getColumns().size() : 1;
                }
                row.add((Object)kIndex);
            }
        }
        return result;
    }

    private void createIndexMap(List<VIPRTuple> tuples) {
        for (int count = 0; count < tuples.size(); ++count) {
            this.indexMap.add(count);
        }
        for (int index = 0; index < tuples.size(); ++index) {
            VIPRTuple tuple = tuples.get(index);
            this.indexMap.set(tuple.getIndex(), index);
        }
    }

    private SortType[] createSort(List<DataSetColumn> dataSetColumns) {
        SortType[] result = null;
        int count = 0;
        for (DataSetColumn col : dataSetColumns) {
            String sort = col.getSort();
            if (sort != null && !sort.isEmpty()) {
                if (result == null) {
                    result = new SortType[dataSetColumns.size()];
                    Arrays.fill((Object[])result, (Object)SortType.ascending);
                }
                result[count] = sort.equals("descending") ? SortType.descending : SortType.ascending;
            }
            ++count;
        }
        return result;
    }

    private DataSetField getDataSetField(String idSlot, List<DataSetField> dataSetFields) {
        DataSetField result = null;
        Iterator<DataSetField> iter = dataSetFields.iterator();
        while (result == null && iter.hasNext()) {
            DataSetField field = iter.next();
            if (!field.getName().equals(idSlot)) continue;
            result = field;
        }
        return result;
    }

    private void processSingleColumn(List<DataSetColumn> dataSetColumns, DataSetData data, int uniqueIndex, List<DataSetField> dataSetFields) {
        block6: {
            DataSetColumn dataSetColumn;
            block5: {
                dataSetColumn = dataSetColumns.get(0);
                if (dataSetColumn.getRefSlot() == null) break block5;
                DataSetField slot = this.getDataSetField(dataSetColumn.getRefSlot(), dataSetFields);
                if (slot == null) break block6;
                this.refSlot = dataSetColumn.getRefSlot();
                this.measureCount = slot.getColumns().size();
                List mgColumns = slot.getColumns();
                if (mgColumns != null) {
                    int index = 0;
                    for (DataSetColumn measureColumn : mgColumns) {
                        VIPRTuple tuple = VIPRTuple.create(0);
                        String value = measureColumn.getName();
                        String keyStr = Integer.toString(index);
                        String formattedValue = data.getLabel(measureColumn.getName());
                        tuple.addItem(value, keyStr, formattedValue, uniqueIndex, 0);
                        tuple.setIndex(index++);
                        this.tuples.add(tuple);
                    }
                }
                break block6;
            }
            JSONArray array = data.getCategory(dataSetColumn.getName());
            JSONArray keys = data.getKeys(dataSetColumn.getName());
            JSONArray foramttedValues = data.getFormattedValues(dataSetColumn.getName());
            if (array != null) {
                int index = 0;
                int valueIndex = 0;
                for (Object value : array) {
                    Object formattedValue;
                    Object keyValue = keys != null && valueIndex < keys.size() ? keys.get(valueIndex) : value;
                    Object object = formattedValue = foramttedValues != null && valueIndex < foramttedValues.size() ? foramttedValues.get(valueIndex) : null;
                    if (value instanceof String) {
                        VIPRTuple tuple = VIPRTuple.create(0);
                        String keyStr = keyValue instanceof String ? (String)keyValue : (String)value;
                        tuple.addItem((String)value, keyStr, (String)formattedValue, uniqueIndex, 0);
                        tuple.setIndex(index++);
                        this.tuples.add(tuple);
                    }
                    ++valueIndex;
                }
            }
        }
    }

    private VIPRTuple createTuple(List<DataSetColumn> dataSetColumns, DataSetData data, TupleKey key, int uniqueIndex, DataSetColumn measureColumn, int measureIndex) {
        VIPRTuple tuple = VIPRTuple.create(0);
        int indexCount = 0;
        List<Integer> indicies = key.getIndicies();
        for (int index = 0; index < dataSetColumns.size(); ++index) {
            DataSetColumn dataSetColumn = dataSetColumns.get(index);
            if (dataSetColumn.getRefSlot() == null) {
                JSONArray array = data.getCategory(dataSetColumn.getName());
                JSONArray keys = data.getKeys(dataSetColumn.getName());
                JSONArray foramttedValues = data.getFormattedValues(dataSetColumn.getName());
                if (indexCount < indicies.size()) {
                    Integer valueIndex = indicies.get(indexCount);
                    if (valueIndex != null && valueIndex < array.size()) {
                        Object formattedValue;
                        Object value = array.get(valueIndex.intValue());
                        Object keyValue = keys != null && valueIndex < keys.size() ? keys.get(valueIndex.intValue()) : value;
                        Object object = formattedValue = foramttedValues != null && valueIndex < foramttedValues.size() ? foramttedValues.get(valueIndex.intValue()) : null;
                        if (value instanceof String) {
                            String keyStr = keyValue instanceof String ? (String)keyValue : (String)value;
                            tuple.addItem((String)value, keyStr, (String)formattedValue, uniqueIndex, index);
                        } else {
                            tuple.addItem(null, null, null, uniqueIndex, index);
                        }
                    } else {
                        tuple.addItem(null, null, null, uniqueIndex, index);
                    }
                }
                ++indexCount;
                continue;
            }
            String value = measureColumn.getName();
            String keyStr = Integer.toString(measureIndex);
            String formattedValue = data.getLabel(measureColumn.getName());
            tuple.addItem(value, keyStr, formattedValue, uniqueIndex, index);
        }
        return tuple;
    }

    private void processMultipleColumns(List<DataSetColumn> dataSetColumns, DataSetData data, int uniqueIndex, List<DataSetField> dataSetFields) {
        DataSetField slot = null;
        for (int index = 0; index < dataSetColumns.size(); ++index) {
            DataSetColumn dataSetColumn = dataSetColumns.get(index);
            if (dataSetColumn.getRefSlot() == null) continue;
            slot = this.getDataSetField(dataSetColumn.getRefSlot(), dataSetFields);
            this.refSlot = dataSetColumn.getRefSlot();
            this.measureCount = slot.getColumns().size();
        }
        Map<Integer, TupleKey> tupleKeys = this.createKeys(data, slot);
        int nTuple = 0;
        for (TupleKey key : tupleKeys.values()) {
            if (slot == null) {
                VIPRTuple tuple = this.createTuple(dataSetColumns, data, key, uniqueIndex, null, 0);
                tuple.setIndex(nTuple++);
                this.tuples.add(tuple);
                continue;
            }
            List mgColumns = slot.getColumns();
            if (mgColumns == null) continue;
            int index = 0;
            for (DataSetColumn measureColumn : mgColumns) {
                VIPRTuple tuple = this.createTuple(dataSetColumns, data, key, uniqueIndex, measureColumn, index++);
                tuple.setIndex(nTuple++);
                this.tuples.add(tuple);
            }
        }
    }

    private void processColumns(DataSetField field, DataSetData data, int uniqueIndex, List<DataSetField> dataSetFields) {
        List dataSetColumns = field.getColumns();
        if (dataSetColumns.size() == 1) {
            this.processSingleColumn(dataSetColumns, data, uniqueIndex, dataSetFields);
        } else if (dataSetColumns.size() > 1) {
            this.processMultipleColumns(dataSetColumns, data, uniqueIndex, dataSetFields);
        }
        SortType[] sort = this.createSort(dataSetColumns);
        if (sort != null && sort.length > 0) {
            this.tuples.sort(new SortComparator(sort));
            this.createIndexMap(this.tuples);
        }
    }

    private void process(SlotRef ref, DataSetField field, DataSetData data, int uniqueIndex, List<DataSetField> dataSetFields) {
        VIPRItemClassSet classSet = VIPRItemClassSet.create(ref, field, data);
        this.processField(field, data.getColumns());
        this.itemClassSets.add(classSet);
        this.processColumns(field, data, uniqueIndex, dataSetFields);
    }

    public static VIPRDataItem create(SlotRef ref, DataSetField field, DataSetData data, int uniqueIndex, List<DataSetField> dataSetFields) {
        VIPRCatDataItem result = new VIPRCatDataItem();
        result.process(ref, field, data, uniqueIndex, dataSetFields);
        return result;
    }

    @Override
    public int getMeasureCount() {
        return this.measureCount;
    }

    private static class SortComparator
    implements Comparator<VIPRTuple> {
        private SortType[] sort = null;

        public SortComparator(SortType[] sort) {
            this.sort = sort;
        }

        @Override
        public int compare(VIPRTuple o1, VIPRTuple o2) {
            int result = 0;
            int itemCount = Math.max(o1.getItemCount(), o2.getItemCount());
            for (int count = 0; result == 0 && count < itemCount; ++count) {
                if (count >= o1.getItemCount()) {
                    result = this.sort[count] == SortType.ascending ? -1 : 1;
                    continue;
                }
                if (count >= o2.getItemCount()) {
                    result = this.sort[count] == SortType.ascending ? 1 : -1;
                    continue;
                }
                VIPRItem lhs = (VIPRItem)o1.getItem(count);
                VIPRItem rhs = (VIPRItem)o2.getItem(count);
                String lhsValue = lhs.getValue();
                String rhsValue = rhs.getValue();
                if (lhsValue == null || rhsValue == null) {
                    if (lhsValue == null && rhsValue != null) {
                        result = this.sort[count] == SortType.ascending ? -1 : 1;
                        continue;
                    }
                    if (lhsValue == null || rhsValue != null) continue;
                    result = this.sort[count] == SortType.ascending ? 1 : -1;
                    continue;
                }
                result = this.sort[count] == SortType.ascending ? lhsValue.compareTo(rhsValue) : rhsValue.compareTo(lhsValue);
            }
            return result;
        }
    }

    private static enum SortType {
        ascending,
        descending;

    }

    private static class TupleKey
    implements Comparable<TupleKey> {
        private List<Integer> indicies = new ArrayList<Integer>();

        private TupleKey() {
        }

        @Override
        public int compareTo(TupleKey rhs) {
            int result = 0;
            for (int index = 0; result == 0 && index < this.indicies.size(); ++index) {
                if (index < rhs.indicies.size()) {
                    if (this.indicies.get(index) < rhs.indicies.get(index)) {
                        result = -1;
                        continue;
                    }
                    if (this.indicies.get(index) <= rhs.indicies.get(index)) continue;
                    result = 1;
                    continue;
                }
                result = 1;
            }
            if (result == 0 && rhs.indicies.size() > this.indicies.size()) {
                result = -1;
            }
            return result;
        }

        public void add(Integer index) {
            this.indicies.add(index);
        }

        public List<Integer> getIndicies() {
            return this.indicies;
        }
    }
}

