/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida.data;

import com.ibm.ba.vis.adapter.DataSetColumn;
import com.ibm.ba.vis.adapter.DataSetField;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.vida.data.DataSetData;
import com.ibm.cognos.adapters.vida.data.VIPRContDomain;
import com.ibm.cognos.adapters.vida.data.VIPRDataItem;
import com.ibm.cognos.adapters.vida.data.VIPRFormatter;
import com.ibm.cognos.adapters.vida.data.VIPRItemClass;
import com.ibm.cognos.adapters.vida.data.VIPRValue;
import com.ibm.json.java.JSONArray;
import com.ibm.vipr.api.ICapability;
import com.ibm.vipr.data.DataItemType;
import com.ibm.vipr.data.FormatKind;
import com.ibm.vipr.data.IContDataItem;
import com.ibm.vipr.data.IContDomain;
import com.ibm.vipr.data.IFormatter;
import com.ibm.vipr.data.IItemClass;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.ArrayList;
import java.util.List;

public class VIPRContDataItem
extends VIPRDataItem
implements IContDataItem {
    private IItemClass itemClass = null;
    private IContDomain domain = null;
    private IFormatter formatter = null;
    private List<IFormatter> valueFormatters = new ArrayList<IFormatter>();

    public DataItemType getType() {
        return DataItemType.Cont;
    }

    public IItemClass getItemClass() {
        return this.itemClass;
    }

    public IFormatter getFormatter(FormatKind _kind) {
        return this.formatter;
    }

    public IContDomain getDomain(ICapability _aggregation, String _channel) {
        return this.domain;
    }

    public static VIPRDataItem create(SlotRef ref, DataSetField field, DataSetData data, Formatter formatter) {
        VIPRContDataItem result = new VIPRContDataItem();
        List columns = field.getColumns();
        if (columns != null) {
            if (columns.size() == 1) {
                result.itemClass = VIPRItemClass.create((DataSetColumn)columns.get(0), data);
            } else if (columns.size() > 1) {
                result.itemClass = VIPRItemClass.create(field.getName(), field.getLabel());
            }
        }
        result.domain = VIPRContDomain.create(field, data);
        result.formatter = VIPRFormatter.create(field, formatter, 0);
        result.valueFormatters.add(result.formatter);
        for (int i = 1; i < columns.size(); ++i) {
            IFormatter valueFormatter = VIPRFormatter.create(field, formatter, i);
            result.valueFormatters.add(valueFormatter);
        }
        result.processField(field, data.getColumns());
        return result;
    }

    @Override
    public Object getDataValue(JSONArray row) {
        Object value;
        VIPRValue result = null;
        Integer index = this.getItemIndex();
        if (index != null && index < row.size() && (value = row.get(index.intValue())) != null) {
            VIPRValue val;
            result = val = VIPRValue.create(value, this.valueFormatters.get(0));
        }
        return result;
    }

    @Override
    public Object getDataValue(JSONArray row, int measureIndex) {
        Object value;
        Integer index;
        VIPRValue result = null;
        List<Integer> itemIndexList = this.getItemIndexList();
        if (measureIndex < itemIndexList.size() && (index = itemIndexList.get(measureIndex)) != null && index < row.size() && (value = row.get(index.intValue())) != null) {
            VIPRValue val;
            result = val = VIPRValue.create(value, this.valueFormatters.get(measureIndex));
        }
        return result;
    }

    @Override
    public int getMeasureCount() {
        return this.getItemIndexList().size();
    }
}

