/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida.data;

import com.ibm.cognos.adapters.vida.data.MeasureGroups;
import com.ibm.cognos.adapters.vida.data.VIPRDataItem;
import com.ibm.cognos.adapters.vida.data.VIPRDecorated;
import com.ibm.json.java.JSONArray;
import com.ibm.vipr.data.IDataPoint;
import com.ibm.vipr.data.IValue;
import java.util.ArrayList;
import java.util.List;

public class VIPRDataPoint
extends VIPRDecorated
implements IDataPoint {
    private List<Object> values = new ArrayList<Object>();
    private int dataSetIndex = 0;
    private int rowIndex = 0;

    public int getTupleIndex(int _dataItemIndex) {
        int result = -1;
        Object value = this.values.get(_dataItemIndex);
        if (value instanceof Integer) {
            result = (Integer)value;
        }
        return result;
    }

    public IValue getValue(int _dataItemIndex) {
        IValue result = null;
        Object value = this.values.get(_dataItemIndex);
        if (value instanceof IValue) {
            result = (IValue)value;
        }
        return result;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getDataSetIndex() {
        return this.dataSetIndex;
    }

    private void process(List<VIPRDataItem> dataItems, JSONArray row, MeasureGroups.MeasureGroupsIterator iter) {
        for (VIPRDataItem item : dataItems) {
            Object value = null;
            if (iter != null && iter.hasMeasureIndex(item)) {
                int measureIndex = iter.getMeasureIndex(item);
                value = item.getDataValue(row, measureIndex);
            } else {
                value = item.getDataValue(row);
            }
            this.values.add(value);
        }
    }

    public static VIPRDataPoint create(List<VIPRDataItem> dataItems, JSONArray row, int dataSetIndex, int rowIndex, MeasureGroups.MeasureGroupsIterator iter) {
        VIPRDataPoint result = new VIPRDataPoint();
        result.dataSetIndex = dataSetIndex;
        result.rowIndex = rowIndex;
        result.process(dataItems, row, iter);
        return result;
    }
}

