/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.adapters.vida.data;

import com.ibm.ba.vis.adapter.DataSet;
import com.ibm.ba.vis.adapter.DataSetField;
import com.ibm.ba.vis.adapter.Formatter;
import com.ibm.cognos.adapters.vida.data.DataSetData;
import com.ibm.cognos.adapters.vida.data.MeasureGroups;
import com.ibm.cognos.adapters.vida.data.VIPRCatDataItem;
import com.ibm.cognos.adapters.vida.data.VIPRContDataItem;
import com.ibm.cognos.adapters.vida.data.VIPRDataItem;
import com.ibm.cognos.adapters.vida.data.VIPRDataPoint;
import com.ibm.cognos.adapters.vida.data.VIPRDecorated;
import com.ibm.json.java.JSONArray;
import com.ibm.vipr.data.IDataItem;
import com.ibm.vipr.data.IDataPoint;
import com.ibm.vipr.data.IDataSet;
import com.ibm.vipr.vizdef.DataSetDef;
import com.ibm.vipr.vizdef.SlotRef;
import com.ibm.vipr.vizdef.SlotType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VIPRDataSet
extends VIPRDecorated
implements IDataSet,
Iterable<IDataPoint> {
    private List<VIPRDataItem> dataItems = new ArrayList<VIPRDataItem>();
    private int dataSetIndex = -1;
    private JSONArray rowData = null;
    private MeasureGroups measureGroups = null;

    public int getDataItemCount() {
        return this.dataItems.size();
    }

    public IDataItem getDataItem(int _index) {
        return this.dataItems.get(_index);
    }

    public Iterable<IDataPoint> getDataPoints() {
        return this;
    }

    @Override
    public Iterator<IDataPoint> iterator() {
        return new DataPointIterator();
    }

    private void process(DataSetData data, DataSetDef def, DataSet dataSet, Formatter formatter, int dataSetIndex) {
        List dataSetFields = dataSet.getDataSetFields();
        int dataIndex = 0;
        for (DataSetField field : dataSetFields) {
            SlotRef ref = def.getSlot(field.getName());
            VIPRDataItem dataItem = null;
            if (ref.type == SlotType.Cat) {
                dataItem = VIPRCatDataItem.create(ref, field, data, dataIndex, dataSetFields);
            } else if (ref.type == SlotType.Cont) {
                dataItem = VIPRContDataItem.create(ref, field, data, formatter);
            } else if (ref.type == SlotType.Any) {
                if (field.getType() == DataSetField.DataSetFieldType.eIndexed) {
                    dataItem = VIPRCatDataItem.create(ref, field, data, dataIndex, dataSetFields);
                } else if (field.getType() == DataSetField.DataSetFieldType.eValue) {
                    dataItem = VIPRContDataItem.create(ref, field, data, formatter);
                }
            }
            if (dataItem == null) continue;
            this.dataItems.add(dataItem);
            ++dataIndex;
            if (dataItem.getRefSlot() == null) continue;
            if (this.measureGroups == null) {
                this.measureGroups = new MeasureGroups();
            }
            this.measureGroups.put(dataItem.getRefSlot(), dataItem.getMeasureCount());
        }
        this.rowData = data.getRows();
        this.dataSetIndex = dataSetIndex;
    }

    public static VIPRDataSet create(DataSetDef def, DataSet dataSet, Formatter formatter, int dataSetIndex) {
        DataSetData data = DataSetData.create(dataSet.getDatSetData());
        VIPRDataSet result = new VIPRDataSet();
        result.process(data, def, dataSet, formatter, dataSetIndex);
        return result;
    }

    private class DataPointIterator
    implements Iterator<IDataPoint> {
        private Iterator<JSONArray> rowIter = null;
        private int rowIndex = 0;
        private JSONArray row = null;
        private MeasureGroups.MeasureGroupsIterator measureIter = null;

        public DataPointIterator() {
            this.rowIter = VIPRDataSet.this.rowData.iterator();
            this.rowIndex = 0;
            if (VIPRDataSet.this.measureGroups != null) {
                this.measureIter = VIPRDataSet.this.measureGroups.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            boolean result = false;
            result = this.measureIter != null ? this.measureIter.hasNext() || this.rowIter.hasNext() : this.rowIter.hasNext();
            return result;
        }

        @Override
        public IDataPoint next() {
            if (this.measureIter != null) {
                if (this.row != null && this.measureIter.hasNext()) {
                    this.measureIter.next();
                } else {
                    this.row = this.rowIter.next();
                    this.measureIter.first();
                }
            } else {
                this.row = this.rowIter.next();
            }
            return VIPRDataPoint.create(VIPRDataSet.this.dataItems, this.row, VIPRDataSet.this.dataSetIndex, this.rowIndex++, this.measureIter);
        }
    }
}

