/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.selector.SelectionQueryEngine;
import com.ibm.rave.core.scene.ImageFactory;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.scene.SceneNodeExtensionFactory;
import com.ibm.rave.core.scene.SceneNodeFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Configuration {
    @InlineStringConstant
    private static final String EXTENSION_KEY = "__rave-node-ext__";
    public static Configuration INSTANCE = new Configuration();
    private final OMap<String, SceneNodeFactory> nodeFactories = new OMap();
    private final OMap<String, ImageFactory> imageSnapshotFactories = new OMap();
    private final OMap<String, SelectionQueryEngine> queryEngines = new OMap();
    private OMap<String, List<SceneNodeExtensionFactory>> nodeExtensions;
    private int extCounter = 1;
    private OMap<String, FilterFunctionClass> filters;

    public SceneNodeFactory getSceneNodeFactory(String nsuri) {
        return this.nodeFactories.get(nsuri);
    }

    public ImageFactory getImageFactory(String nsuri) {
        return this.imageSnapshotFactories.get(nsuri);
    }

    public void setSceneNodeFactory(String nsuri, SceneNodeFactory factory) {
        if (factory != null) {
            this.nodeFactories.put(nsuri, factory);
        } else {
            this.nodeFactories.remove(nsuri);
        }
    }

    public void setImageFactory(String nsuri, ImageFactory factory) {
        if (factory != null) {
            this.imageSnapshotFactories.put(nsuri, factory);
        } else {
            this.imageSnapshotFactories.remove(nsuri);
        }
    }

    public SelectionQueryEngine getQueryEngine(String nsuri) {
        return this.queryEngines.get(nsuri);
    }

    public void setQueryEngine(String nsuri, SelectionQueryEngine queryEngine) {
        if (queryEngine != null) {
            this.queryEngines.put(nsuri, queryEngine);
        } else {
            this.queryEngines.remove(nsuri);
        }
    }

    public void addSceneNodeExtensionFactory(String namespaceUri, SceneNodeExtensionFactory factory, int priority) {
        List<SceneNodeExtensionFactory> list;
        if (this.nodeExtensions == null) {
            this.nodeExtensions = new OMap();
        }
        if ((list = this.nodeExtensions.get(namespaceUri)) != null) {
            if (priority <= 0) {
                list.add(0, factory);
            } else if (priority >= list.size()) {
                list.add(factory);
            } else {
                list.add(priority, factory);
            }
        } else {
            list = new ArrayEx<SceneNodeExtensionFactory>(factory);
            this.nodeExtensions.put(namespaceUri, list);
        }
        ++this.extCounter;
    }

    public void removeSceneNodeExtensionFactory(String namespaceUri, SceneNodeExtensionFactory factory) {
        int i;
        List<SceneNodeExtensionFactory> list = this.nodeExtensions.get(namespaceUri);
        if (list != null && (i = list.indexOf(factory)) >= 0) {
            list.remove(i);
            ++this.extCounter;
        }
    }

    public SceneNode extend(SceneNode node, SceneNode context) {
        if (this.nodeExtensions != null) {
            boolean extend;
            Integer extId = (Integer)node.getProperty(EXTENSION_KEY);
            boolean bl = extend = extId == null;
            if (!extend && extId != this.extCounter) {
                node.initExtensions();
            }
            if (extend) {
                node.setProperty(EXTENSION_KEY, this.extCounter);
                List<SceneNodeExtensionFactory> nodeExtFactories = this.nodeExtensions.get(node.getNamespaceURI());
                if (nodeExtFactories != null) {
                    SceneNode c = context != null ? context : node.getParentNode();
                    for (SceneNodeExtensionFactory extFactory : nodeExtFactories) {
                        extFactory.extend(node, c);
                    }
                }
            }
        }
        return node;
    }

    public SceneNode extendRecursive(SceneNode node) {
        this.extend(node, null);
        if (node.hasChildNodes()) {
            for (SceneNode child : node.getChildNodes()) {
                this.extendRecursive(child);
            }
        }
        return node;
    }

    public void registerFilter(String filterKey, FilterFunctionClass filterFunction) {
        if (this.filters == null) {
            this.filters = new OMap();
        }
        this.filters.put(filterKey, filterFunction);
    }

    public void unregisterFilter(String filterKey) {
        if (this.filters != null) {
            this.filters.remove(filterKey);
        }
    }

    public SceneNode filter(SceneNode item, String query) {
        SceneNode result;
        block1: {
            String key;
            FilterFunctionClass filterFunction;
            result = item;
            if (this.filters == null || result == null) break block1;
            Iterator<String> iterator = this.filters.keySet().iterator();
            while (iterator.hasNext() && (result = (filterFunction = this.filters.get(key = iterator.next())).filter(item, query)) != null) {
            }
        }
        return result;
    }

    public List<SceneNode> filterArray(List<SceneNode> list) {
        if (this.filters != null && list != null) {
            ArrayList<SceneNode> results = new ArrayList<SceneNode>();
            for (SceneNode item : list) {
                for (String key : this.filters.keySet()) {
                    FilterFunctionClass filterFunction = this.filters.get(key);
                    item = filterFunction.filter(item, null);
                }
                if (item == null) continue;
                results.add(item);
            }
            return results;
        }
        return list;
    }

    @FunctionClass(value="filter")
    @SwiftClosure(value="filter")
    public static interface FilterFunctionClass {
        public SceneNode filter(SceneNode var1, String var2);
    }
}

