/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.ExtensionFactory;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.internal.collections.OMap;

public class RegistryService {
    @InlineStringConstant
    private static final String REGISTRY_MAP_KEY_SUFFIX = "_REGISTRY_MAP_KEY";
    private final String registryMapKey = this.getServiceId() + "_REGISTRY_MAP_KEY";

    public String getServiceId() {
        return "RegistryService";
    }

    private OMap<String, ExtensionFactory<?>> getRegistryMap() {
        OMap registry = (OMap)RaveContextManager.INSTANCE.getRaveContext().getData(this.registryMapKey);
        if (registry == null) {
            registry = new OMap();
            RaveContextManager.INSTANCE.getRaveContext().putData(this.registryMapKey, registry);
        }
        return registry;
    }

    public final Object extension(String id) {
        OMap<String, ExtensionFactory<?>> registry = this.getRegistryMap();
        if (registry.get(id) != null) {
            return registry.get(id).create();
        }
        return null;
    }

    public final boolean extension(String id, ExtensionFactory<?> factory) {
        OMap<String, ExtensionFactory<?>> registry = this.getRegistryMap();
        if (registry.get(id) != null) {
            return false;
        }
        registry.put(id, factory);
        return true;
    }

    public boolean isRegistered(String id) {
        return this.getRegistryMap().containsKey(id);
    }
}

