/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.arrays;

import com.ibm.rave.core.arrays.Quantile;
import com.ibm.rave.core.arrays.Sort;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.math.NumberUtil;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.selector.ValueFunction;

public final class Median {
    private Median() {
    }

    public static Number median(Object[] array) {
        ArrayEx<Object> numbers = new ArrayEx<Object>();
        int n = array.length;
        int i = -1;
        while (++i < n) {
            double a = NumberUtil.toNumber(array[i]);
            if (Double.isNaN(a)) continue;
            numbers.add(a);
        }
        return (Number)(numbers.size() > 0 ? Quantile.quantile(numbers.sort(Sort.ascending), 0.5) : Lang.undefined());
    }

    public static Number median(Object[] data, ValueFunction<? super Object[], ? extends Number> valueFunction) {
        ArrayEx<Object> numbers = new ArrayEx<Object>();
        int i = -1;
        int n = data.length;
        while (++i < n) {
            Number val = valueFunction.getValue((Object[])data, data[i], i, -1);
            double a = NumberUtil.toNumber(val);
            if (Double.isNaN(a)) continue;
            numbers.add(a);
        }
        return (Number)(numbers.size() > 0 ? Quantile.quantile(numbers.sort(Sort.ascending), 0.5) : Lang.undefined());
    }
}

