/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.arrays;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.arrays.Entry;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.collections.MapFunctionClass;
import com.ibm.rave.core.functions.TwoParamValueFunction;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.util.Comparator;

public class Nest {
    private final ArrayEx<KeyFunction> keyFunctions = new ArrayEx();
    private final ArrayEx<Comparator<Object>> sortKeysComparators = new ArrayEx();
    private Comparator<Object> sortValuesFn;
    private RollupFunction rollupFn;

    private Object internalMap(final MapFunctionClass mapType, ArrayEx<Object> array, int depth) {
        int _depth = depth;
        if (_depth >= this.keyFunctions.length()) {
            if (this.rollupFn != null) {
                return this.rollupFn.rollup(this, array);
            }
            if (this.sortValuesFn != null) {
                return array.sort(this.sortValuesFn);
            }
            return array;
        }
        final Nest self = this;
        int i = -1;
        int n = array.length();
        KeyFunction keyFn = (KeyFunction)this.keyFunctions.get(_depth++);
        final Object[] keyArray = new Object[1];
        ES6Map valuesByKey = ES6Map.create();
        while (++i < n) {
            keyArray[0] = array.get(i);
            Object keyValue = keyFn.getKey(keyArray[0]);
            ArrayEx values = (ArrayEx)valuesByKey.get(keyValue);
            if (ObjectConverter.toBoolean(values)) {
                values.push(keyArray[0]);
                continue;
            }
            ArrayEx<Object> valueArray = new ArrayEx<Object>();
            valueArray.add(keyArray[0]);
            valuesByKey.set(keyValue, valueArray);
        }
        final int finalDepth = _depth;
        if (mapType != null) {
            keyArray[0] = mapType.createMap();
            valuesByKey.forEach(new TwoParamValueFunction<ArrayEx<Object>, Object, ArrayEx<Object>>(){

                @Override
                public ArrayEx<Object> getValue(Object b, ArrayEx<Object> c) {
                    ((ES6Map)keyArray[0]).set(b, self.internalMap(mapType, c, finalDepth));
                    return null;
                }
            });
        } else {
            keyArray[0] = new OMap();
            valuesByKey.forEach(new TwoParamValueFunction<ArrayEx<Object>, Object, ArrayEx<Object>>(){

                @Override
                public ArrayEx<Object> getValue(Object b, ArrayEx<Object> c) {
                    ((OMap)keyArray[0]).put(b, self.internalMap(mapType, c, finalDepth));
                    return null;
                }
            });
        }
        return keyArray[0];
    }

    private Object internalEntries(Object map, int depth) {
        if (depth >= this.keyFunctions.length()) {
            return map;
        }
        ES6Map realMap = (ES6Map)map;
        final ArrayEx<Entry> array = new ArrayEx<Entry>();
        final Comparator sortKey = this.sortKeysComparators.length() > depth ? (Comparator)this.sortKeysComparators.get(depth) : null;
        final int finalDepth = depth + 1;
        final Nest self = this;
        realMap.forEach(new TwoParamValueFunction<Object, Object, Object>(){

            @Override
            public Object getValue(Object key, Object keyMap) {
                Entry entry = new Entry();
                entry.key = key;
                entry.values = self.internalEntries(keyMap, finalDepth);
                array.push(entry);
                return null;
            }
        });
        return sortKey != null ? array.sort(new Comparator<Entry>(){

            @Override
            public int compare(Entry obj1, Entry obj2) {
                return sortKey.compare(obj1.key, obj2.key);
            }
        }) : array;
    }

    public ArrayEx<?> entries(ArrayEx<Object> array) {
        return (ArrayEx)this.internalEntries(this.internalMap(Rave.map, array, 0), 0);
    }

    public Object map(ArrayEx<Object> array, MapFunctionClass mapType) {
        return this.internalMap(mapType, array, 0);
    }

    public Object map(ArrayEx<Object> array) {
        return this.internalMap(null, array, 0);
    }

    public Nest key(KeyFunction d) {
        this.keyFunctions.push((KeyFunction[])new KeyFunction[]{d});
        return this;
    }

    public Nest rollup(RollupFunction rFunction) {
        this.rollupFn = rFunction;
        return this;
    }

    public Nest sortKeys(Comparator<Object> order) {
        this.sortKeysComparators.set(this.keyFunctions.length() - 1, order);
        return this;
    }

    public Nest sortValues(Comparator<Object> order) {
        this.sortValuesFn = order;
        return this;
    }

    @FunctionClass(value="rollup", contextInvocation=true)
    @SwiftClosure(value="rollup")
    public static interface RollupFunction {
        public Number rollup(Nest var1, ArrayEx<?> var2);
    }

    @FunctionClass(value="getKey")
    @SwiftClosure(value="getKey")
    public static interface KeyFunction {
        public Object getKey(Object var1);
    }
}

