/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.arrays;

import com.ibm.rave.core.internal.math.NumberUtil;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.selector.ValueFunction;

public class Variance {
    private Variance() {
    }

    public static Number variance(Object[] array) {
        double s = 0.0;
        double m = 0.0;
        int i = -1;
        int j = 0;
        while (++i < array.length) {
            double a = NumberUtil.toNumber(array[i]);
            if (Double.isNaN(a)) continue;
            double d = a - m;
            s += d * (a - (m += d / (double)(++j)));
        }
        return j > 1 ? (Number)(s / (double)(j - 1)) : (Number)((Number)Lang.undefined());
    }

    public static Number variance(Object[] array, ValueFunction<? super Object[], ? extends Object> valueFunction) {
        double s = 0.0;
        double m = 0.0;
        int i = -1;
        int j = 0;
        while (++i < array.length) {
            double a = NumberUtil.toNumber(valueFunction.getValue((Object[])array, array[i], i, -1));
            if (Double.isNaN(a)) continue;
            double d = a - m;
            s += d * (a - (m += d / (double)(++j)));
        }
        return j != 0 && !Double.isNaN(j) ? (Number)(s / (double)(j - 1)) : (Number)((Number)Lang.undefined());
    }
}

