/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.behavior;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.event.BaseEvent;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.event.Touch;
import com.ibm.rave.core.event.TouchEvent;
import com.ibm.rave.core.event.TouchList;
import com.ibm.rave.core.event.Touches;
import com.ibm.rave.core.event.UIEvent;
import com.ibm.rave.core.event.WheelEvent;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.Point3;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.event.CustomDispatcher;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.internal.nativeImpl.PlatformInitialization;
import com.ibm.rave.core.internal.nativeImpl.event.DragSuppress;
import com.ibm.rave.core.internal.nativeImpl.transitions.InheritedTransition;
import com.ibm.rave.core.internal.transitions.TransitionUtil;
import com.ibm.rave.core.internal.util.MathUtil;
import com.ibm.rave.core.interpolate.ZoomInterpolation;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.event.EventTracker;
import com.ibm.rave.core.nativeImpl.event.Mouse;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.core.transition.Tween;
import com.ibm.rave.core.util.Runnable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Zoom
implements RunFunction<Object> {
    @InlineStringConstant
    private static final String CHART_PROP = "__chart__";
    @InlineStringConstant
    private static final String zoomWheel = "wheel.zoom";
    @InlineStringConstant
    private static final String mousedown = "mousedown.zoom";
    @InlineStringConstant
    private static final String mouseup = "mouseup.zoom";
    @InlineStringConstant
    private static final String mousemove = "mousemove.zoom";
    @InlineStringConstant
    private static final String touchstart = "touchstart.zoom";
    @InlineStringConstant
    private static final String dblclick = "dblclick.zoom";
    private static final Dim zoomInfinity = new Dim(0.0, Double.POSITIVE_INFINITY);
    private static final GetZoomDelta zoomDelta = new GetZoomDelta(){

        @Override
        public double get() {
            WheelEvent event = (WheelEvent)EventTracker.INSTANCE.get();
            return -event.deltaY * (double)(event.deltaMode != 0 ? 120 : 1);
        }
    };
    @SwiftWeak(value=false)
    private final CustomDispatcher<EventObject, Zoom, SceneNode> _event = CustomDispatcher.create(this, "zoomstart", "zoom", "zoomend");
    private Object mousewheelTimer;
    private double touchtime = Double.NaN;
    private AbstractScale<?, Number> sx0;
    private AbstractScale<?, Number> sx1;
    private AbstractScale<?, Number> sy0;
    private AbstractScale<?, Number> sy1;
    private View view = new View(0.0, 0.0, 1.0);
    private Point translate0;
    private Point center0;
    private Point _center;
    private double _duration = 250.0;
    private int zooming = 0;
    private Point _size = new Point(960.0, 500.0);
    private Dim _scaleExtent = zoomInfinity;
    private SelectorEventListener<?> mousedowned;
    private SelectorEventListener<?> touchstarted;
    private SelectorEventListener<?> dblclicked;
    private SelectorEventListener<?> mousewheeled;
    public RunFunction<Object> event = new ZoomEvent(this);

    public Zoom() {
        final Zoom self = this;
        this.mousedowned = new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event e) {
                final SceneNode that = context;
                final Point location0 = self.location(Mouse.mousePoint(that));
                final DragSuppress.Suppress dragRestore = DragSuppress.dragSuppress(that);
                final Object target = EventTracker.INSTANCE.get().target;
                final CustomDispatcher.DispatchContext dispatch = self._event.of(that, data, index, groupIndex);
                final boolean[] dragged = new boolean[1];
                final Selector subject = Rave.select(PlatformInitialization.getWindow(that));
                SelectorEventListener<Event> moved = new SelectorEventListener<Event>(){

                    @Override
                    public void onEvent(SceneNode context1, Object data1, int index1, int groupIndex1, Event event) {
                        dragged[0] = true;
                        self.translateTo(Mouse.mousePoint(that), location0);
                        self.zoomed(dispatch);
                    }
                };
                SelectorEventListener<Event> ended = new SelectorEventListener<Event>(){

                    @Override
                    public void onEvent(SceneNode context2, Object data2, int index2, int groupIndex2, Event event) {
                        subject.on(Zoom.mousemove, null).on(Zoom.mouseup, null);
                        dragRestore.suppress(dragged[0] && EventTracker.INSTANCE.get().target == target);
                        self.zoomended(dispatch);
                    }
                };
                subject.on(Zoom.mousemove, (SelectorEventListener<? extends Event>)moved).on(Zoom.mouseup, (SelectorEventListener<? extends Event>)ended);
                TransitionUtil.interrupt(context);
                self.zoomstarted(dispatch);
            }
        };
        this.touchstarted = new SelectorEventListener<TouchEvent>(){

            @Override
            public void onEvent(final SceneNode context, Object data, int index, int groupIndex, TouchEvent e) {
                final SceneNode that = context;
                final DragSuppress.Suppress dragRestore = DragSuppress.dragSuppress(that);
                final CustomDispatcher.DispatchContext dispatch = self._event.of(that, data, index, groupIndex);
                final Selector subject = Rave.select(that);
                final String zoomName = ".zoom-" + ((Touch)((TouchEvent)EventTracker.INSTANCE.get()).changedTouches.get((int)0)).identifier;
                final String touchmove = "touchmove" + zoomName;
                final String touchend = "touchend" + zoomName;
                final ArrayList targets = new ArrayList();
                final OMap locations0 = new OMap();
                final double[] distance0 = new double[]{0.0};
                final double[] scale0 = new double[1];
                final Relocate relocate = new Relocate(){

                    @Override
                    public List<Touches.TouchPoint> relocate() {
                        List<Touches.TouchPoint> touches = Touches.touches(that);
                        scale0[0] = ((Zoom)self).view.k;
                        for (Touches.TouchPoint t : touches) {
                            if (!locations0.containsKey(t.identifier)) continue;
                            locations0.put(t.identifier, self.location(t));
                        }
                        return touches;
                    }
                };
                final SelectorEventListener<Event> moved = new SelectorEventListener<Event>(){

                    @Override
                    public void onEvent(SceneNode context1, Object data1, int index1, int groupIndex1, Event event) {
                        List<Touches.TouchPoint> touches = Touches.touches(that);
                        TransitionUtil.interrupt(context);
                        Point p0 = null;
                        Point p1 = null;
                        Point l0 = null;
                        Point l1 = null;
                        int n = touches.size();
                        for (int i = 0; i < n; ++i) {
                            p1 = touches.get(i);
                            l1 = (Point)locations0.get(((Touches.TouchPoint)p1).identifier);
                            if (l1 != null) {
                                if (l0 != null) break;
                                p0 = p1;
                                l0 = l1;
                            }
                            l1 = null;
                        }
                        if (l1 != null) {
                            double temp = p1.getX() - p0.getX();
                            double d = temp * temp;
                            temp = p1.getY() - p0.getY();
                            double distance1 = d + temp * temp;
                            double scale1 = 0.0;
                            if (distance0[0] != 0.0) {
                                scale1 = Math.sqrt(distance1 / distance0[0]);
                            }
                            p0 = new Touches.TouchPoint((p0.getX() + p1.getX()) / 2.0, (p0.getY() + p1.getY()) / 2.0);
                            l0 = new Touches.TouchPoint((l0.getX() + l1.getX()) / 2.0, (l0.getY() + l1.getY()) / 2.0);
                            self.scaleTo(scale1 * scale0[0]);
                        }
                        self.touchtime = Double.NaN;
                        self.translateTo(p0, l0);
                        self.zoomed(dispatch);
                    }
                };
                final SelectorEventListener<TouchEvent> ended = new SelectorEventListener<TouchEvent>(){

                    @Override
                    public void onEvent(SceneNode context1, Object data1, int index1, int groupIndex1, TouchEvent event) {
                        TouchEvent toucheEvent = (TouchEvent)EventTracker.INSTANCE.get();
                        if (toucheEvent.touches.size() != 0) {
                            TouchList changed = toucheEvent.changedTouches;
                            int n = changed.size();
                            for (int i = 0; i < n; ++i) {
                                locations0.remove(((Touch)changed.get((int)i)).identifier);
                            }
                            Iterator iterator = locations0.keySet().iterator();
                            if (iterator.hasNext()) {
                                String identifier = (String)iterator.next();
                                relocate.relocate();
                                return;
                            }
                        }
                        Rave.selectAll(targets).on(zoomName, null);
                        subject.on(Zoom.mousedown, self.mousedowned).on(Zoom.touchstart, self.touchstarted);
                        dragRestore.suppress(false);
                        self.zoomended(dispatch);
                    }
                };
                SelectorEventListener<TouchEvent> started = new SelectorEventListener<TouchEvent>(){

                    @Override
                    public void onEvent(SceneNode context1, Object data1, int index1, int groupIndex1, TouchEvent event) {
                        TouchEvent touchEvent = (TouchEvent)EventTracker.INSTANCE.get();
                        SceneNode target = (SceneNode)touchEvent.target;
                        Rave.select(target).on(touchmove, moved).on(touchend, ended);
                        targets.add(target);
                        TouchList changed = touchEvent.changedTouches;
                        int n = changed.size();
                        for (int i = 0; i < n; ++i) {
                            locations0.put(((Touch)changed.get((int)i)).identifier, null);
                        }
                        List<Touches.TouchPoint> touches = relocate.relocate();
                        double now = Lang.now();
                        if (touches.size() == 1) {
                            if (now - self.touchtime < 500.0) {
                                Touches.TouchPoint p = touches.get(0);
                                self.zoomTo(that, p, (Point)locations0.get(p.identifier), Math.floor(Math.log(((Zoom)self).view.k) / MathUtil.LN2) + 1.0);
                                EventTracker.INSTANCE.preventDefault();
                            }
                            self.touchtime = now;
                        } else if (touches.size() > 1) {
                            Touches.TouchPoint p = touches.get(0);
                            Touches.TouchPoint q = touches.get(1);
                            double dx = p.getX() - q.getX();
                            double dy = p.getY() - q.getY();
                            distance0[0] = dx * dx + dy * dy;
                        }
                    }
                };
                subject.on(Zoom.mousedown, null).on(Zoom.touchstart, (SelectorEventListener<? extends Event>)started);
                started.onEvent(null, null, -1, -1, null);
                self.zoomstarted(dispatch);
            }
        };
        this.dblclicked = new SelectorEventListener<UIEvent>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, UIEvent e) {
                Point p = Mouse.mousePoint(context);
                double k = Math.log(((Zoom)self).view.k) / MathUtil.LN2;
                self.zoomTo(context, p, self.location(p), ((UIEvent)EventTracker.INSTANCE.get()).shiftKey ? Math.ceil(k) - 1.0 : Math.floor(k) + 1.0);
            }
        };
        this.mousewheeled = new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event e) {
                final CustomDispatcher.DispatchContext dispatch = self._event.of(context, data, index, groupIndex);
                if (self.mousewheelTimer != null) {
                    EventQueue.clearTimeout(self.mousewheelTimer);
                } else {
                    self.center0 = self._center != null ? self._center : Mouse.mousePoint(context);
                    self.translate0 = self.location(self.center0);
                    TransitionUtil.interrupt(context);
                    self.zoomstarted(dispatch);
                }
                self.mousewheelTimer = EventQueue.setTimeout(new Runnable(){

                    @Override
                    public void run() {
                        self.mousewheelTimer = null;
                        self.zoomended(dispatch);
                    }
                }, 50);
                EventTracker.INSTANCE.preventDefault();
                self.scaleTo(Math.pow(2.0, zoomDelta.get() * 0.002) * ((Zoom)self).view.k);
                self.translateTo(self.center0, self.translate0);
                self.zoomed(dispatch);
            }
        };
    }

    @Override
    public Object run(Object context, Object ... args) {
        this.zoom((Selector)args[0]);
        return null;
    }

    public void zoom(Selector g) {
        g.on(mousedown, this.mousedowned).on(zoomWheel, this.mousewheeled).on(dblclick, this.dblclicked).on(touchstart, this.touchstarted);
    }

    public Point translate() {
        return new Point(this.view.x, this.view.y);
    }

    public Zoom translate(Point point) {
        this.view = new View(point.getX(), point.getY(), this.view.k);
        this.rescale();
        return this;
    }

    public double scale() {
        return this.view.k;
    }

    public Zoom scale(double s) {
        this.view = new View(this.view.x, this.view.y, s);
        this.rescale();
        return this;
    }

    public Dim scaleExtent() {
        return this._scaleExtent;
    }

    public Zoom scaleExtent(Dim dim) {
        this._scaleExtent = dim == null ? zoomInfinity : new Dim(dim.getWidth(), dim.getHeight());
        return this;
    }

    public Point center() {
        return this._center;
    }

    public Zoom center(Point p) {
        this._center = p != null ? new Point(p.getX(), p.getY()) : null;
        return this;
    }

    public double duration() {
        return this._duration;
    }

    public Zoom duration(double duration) {
        this._duration = duration;
        return this;
    }

    public Point size() {
        return this._size;
    }

    public Zoom size(Point p) {
        this._size = p != null ? new Point(p.getX(), p.getY()) : null;
        return this;
    }

    public AbstractScale<?, Number> x() {
        return this.sx1;
    }

    public Zoom x(AbstractScale<?, Number> z) {
        this.sx1 = z;
        this.sx0 = z.copy();
        this.view = new View(0.0, 0.0, 1.0);
        return this;
    }

    public AbstractScale<?, ?> y() {
        return this.sy1;
    }

    public Zoom y(AbstractScale<?, Number> z) {
        this.sy1 = z;
        this.sy0 = z.copy();
        this.view = new View(0.0, 0.0, 1.0);
        return this;
    }

    private Point location(Point p) {
        return new Point((p.getX() - this.view.x) / this.view.k, (p.getY() - this.view.y) / this.view.k);
    }

    private Point point(Point l) {
        return new Point(l.getX() * this.view.k + this.view.x, l.getY() * this.view.k + this.view.y);
    }

    private void scaleTo(double s) {
        this.view.k = Math.max(this._scaleExtent.getWidth(), Math.min(this._scaleExtent.getHeight(), s));
    }

    private void translateTo(Point p, Point l) {
        Point _l = this.point(l);
        this.view.x += p.getX() - _l.getX();
        this.view.y += p.getY() - _l.getY();
    }

    private void rescale() {
        Object value;
        int i;
        int len;
        ArrayList<Double> r;
        List<Number> ro;
        if (this.sx1 != null) {
            if (this.sx1.getZoomTransform() != null) {
                this.sx1.getZoomTransform().zoomTransform(this.view.k, this.view.x);
            } else {
                ro = this.sx0.range();
                r = new ArrayList<Double>();
                len = ro.size();
                for (i = 0; i < len; ++i) {
                    value = this.sx0.getInvert().getValue((ObjectConverter.toDouble(ro.get(i)) - this.view.x) / this.view.k);
                    r.add(ObjectConverter.toDouble(value));
                }
                this.sx1.domain(r);
            }
        }
        if (this.sy1 != null) {
            if (this.sy1.getZoomTransform() != null) {
                this.sy1.getZoomTransform().zoomTransform(this.view.k, this.view.y);
            } else {
                ro = this.sy0.range();
                r = new ArrayList();
                len = ro.size();
                for (i = 0; i < len; ++i) {
                    value = this.sy0.getInvert().getValue((ObjectConverter.toDouble(ro.get(i)) - this.view.y) / this.view.k);
                    r.add(ObjectConverter.toDouble(value));
                }
                this.sy1.domain(r);
            }
        }
    }

    private void zoomstarted(CustomDispatcher.DispatchContext<EventObject, Zoom> dispatch) {
        if (this.zooming++ == 0) {
            dispatch.dispatch(new EventObject("zoomstart", 0.0, null));
        }
    }

    private void zoomed(CustomDispatcher.DispatchContext<EventObject, Zoom> dispatch) {
        this.rescale();
        dispatch.dispatch(new EventObject("zoom", this.view.k, new double[]{this.view.x, this.view.y}));
    }

    private void zoomended(CustomDispatcher.DispatchContext<EventObject, Zoom> dispatch) {
        if (--this.zooming == 0) {
            dispatch.dispatch(new EventObject("zoomend", 0.0, null));
        }
        this.center0 = null;
    }

    public RunFunction<? super SceneNode> on(String type) {
        return this._event.on(type);
    }

    public Zoom on(String type, RunFunction<SceneNode> listener) {
        this._event.on(type, listener);
        return this;
    }

    private void zoomTo(SceneNode that, Point p, Point l, double k) {
        that.setProperty(CHART_PROP, new View(this.view.x, this.view.y, this.view.k));
        this.scaleTo(Math.pow(2.0, k));
        this.center0 = p;
        this.translateTo(this.center0, l);
        Selection context = Rave.select(that);
        if (this._duration > 0.0) {
            context = ((Selection)context).transition().duration(this._duration);
        }
        context.call(this.event, new Object[0]);
    }

    public static class EventObject
    extends BaseEvent<Zoom> {
        public final double scale;
        public final double[] translate;

        EventObject(String type, double scale, double[] translate) {
            super(type);
            this.scale = scale;
            this.translate = translate;
        }
    }

    private static class View {
        double x;
        double y;
        double k;

        View(double x, double y, double k) {
            this.x = x;
            this.y = y;
            this.k = k;
        }
    }

    @FunctionClass(value="relocate")
    @SwiftClosure(value="relocate")
    private static interface Relocate {
        public List<Touches.TouchPoint> relocate();
    }

    @FunctionClass(value="get")
    @SwiftClosure(value="get")
    private static interface GetZoomDelta {
        public double get();
    }

    private static class ZoomEvent
    implements RunFunction<Object> {
        @SwiftWeak
        final Zoom _zoom;

        ZoomEvent(Zoom zoom) {
            this._zoom = zoom;
        }

        public void doRun(Selection<?> g, final @SwiftWeak Zoom zoom, Object ... args) {
            g.each(new CallbackFunction<SceneNode>(){

                @Override
                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    final CustomDispatcher.DispatchContext dispatch = zoom._event.of(context, data, index, groupIndex);
                    final View view1 = zoom.view;
                    if (InheritedTransition.get() != null) {
                        ((Transition)((Transition)Rave.select(context).transition().each("start.zoom", new RunFunction<SceneNode>(){

                            @Override
                            public Object run(SceneNode context1, Object ... args) {
                                Object temp = context1.getProperty(Zoom.CHART_PROP);
                                if (temp == null) {
                                    zoom.view = new View(0.0, 0.0, 1.0);
                                } else {
                                    zoom.view = (View)temp;
                                }
                                zoom.zoomstarted(dispatch);
                                return null;
                            }
                        })).tween("zoom:zoom", new ValueFunction<SceneNode, Tween<SceneNode>>(){

                            @Override
                            public Tween<SceneNode> getValue(SceneNode context1, Object data1, int index1, int groupIndex1) {
                                final double dx = zoom._size.getX();
                                double dy = zoom._size.getY();
                                final double cx = zoom.center0 != null ? zoom.center0.getX() : dx / 2.0;
                                final double cy = zoom.center0 != null ? zoom.center0.getY() : dy / 2.0;
                                Point3 p0 = new Point3((cx - ((Zoom)zoom).view.x) / ((Zoom)zoom).view.k, (cy - ((Zoom)zoom).view.y) / ((Zoom)zoom).view.k, dx / ((Zoom)zoom).view.k);
                                Point3 p1 = new Point3((cx - view1.x) / view1.k, (cy - view1.y) / view1.k, dx / view1.k);
                                final ZoomInterpolation.ZoomInterpolator i = ZoomInterpolation.INSTANCE.create(p0, p1);
                                return new Tween<SceneNode>(){

                                    @Override
                                    public void tween(SceneNode context2, double t) {
                                        Point3 l = i.interpolate(t);
                                        double k = dx / l.getZ();
                                        zoom.view = new View(cx - l.getX() * k, cy - l.getY() * k, k);
                                        context2.setProperty(Zoom.CHART_PROP, zoom.view);
                                        zoom.zoomed(dispatch);
                                    }
                                };
                            }
                        }).each("interrupt.zoom", new RunFunction<SceneNode>(){

                            @Override
                            public Object run(SceneNode context1, Object ... args) {
                                zoom.zoomended(dispatch);
                                return null;
                            }
                        })).each("end.zoom", new RunFunction<SceneNode>(){

                            @Override
                            public Object run(SceneNode context1, Object ... args) {
                                zoom.zoomended(dispatch);
                                return null;
                            }
                        });
                    } else {
                        context.setProperty(Zoom.CHART_PROP, zoom.view);
                        zoom.zoomstarted(dispatch);
                        zoom.zoomed(dispatch);
                        zoom.zoomended(dispatch);
                    }
                }
            });
        }

        @Override
        public Object run(Object context, Object ... args) {
            this.doRun((Selection)args[0], this._zoom, args);
            return null;
        }
    }
}

