/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.collections;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftGeneratedVariadic;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.arrays.Sort;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.util.Comparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArrayEx<E>
extends ArrayList<E> {
    public ArrayEx() {
    }

    public ArrayEx(int size) {
        super(size);
        for (int i = 0; i < size; ++i) {
            this.add(null);
        }
    }

    @Deprecated
    public ArrayEx(double size) {
        if (size == (double)((int)size)) {
            for (int i = 0; i < (int)size; ++i) {
                this.add(null);
            }
        }
    }

    @SwiftGeneratedVariadic(value="\toverride public init(_ elements : /*E*/JObject!...) {\n\t\tsuper.init(elements)\n\t}\n")
    public ArrayEx(E ... elements) {
        super(elements == null ? 1 : elements.length);
        if (elements == null) {
            this.add(null);
        } else {
            for (E element : elements) {
                this.add(element);
            }
        }
    }

    public int length() {
        return super.size();
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.size()) {
            int increase = index + 1 - this.size();
            for (int i = 0; i < increase; ++i) {
                this.add(null);
            }
        }
        return super.set(index, element);
    }

    public <R> ArrayEx<R> map(ArrayValueFunction<E, R> callback) {
        int len = this.length();
        ArrayEx<R> mappedArray = new ArrayEx<R>();
        for (int i = 0; i < len; ++i) {
            Object currentValue = this.get(i);
            if (currentValue == null) continue;
            mappedArray.add(callback.getValue(currentValue, i, this));
        }
        return mappedArray;
    }

    public static <R, E> ArrayEx<R> map(List<E> input, ArrayValueFunction<E, R> callback) {
        int len = input.size();
        ArrayEx<R> mappedArray = new ArrayEx<R>();
        for (int i = 0; i < len; ++i) {
            E currentValue = input.get(i);
            if (currentValue == null) continue;
            mappedArray.add(callback.getValue(currentValue, i, (ArrayEx)input));
        }
        return mappedArray;
    }

    public <R> R reduce(Accumulator<R, E> accumulator, R initialValue) {
        int len = this.length();
        if (len == 0) {
            return initialValue;
        }
        R reduced = initialValue;
        for (int i = 0; i < len; ++i) {
            Object currentVal = this.get(i);
            if (currentVal == null) continue;
            reduced = accumulator.reduce(reduced, currentVal, i, this);
        }
        return reduced;
    }

    public ArrayEx<E> splice(int index, int howmany, E ... es) {
        int _index = index;
        int _howmany = howmany;
        if (_howmany == Integer.MAX_VALUE || _howmany + _index > this.length()) {
            _howmany = this.length() - _index;
        }
        if (_index < 0) {
            _index = this.length() + _index;
        }
        ArrayEx<E> removedElements = this.slice(_index, _index + _howmany);
        ArrayEx<E> newContents = this.slice(0, _index);
        if (es != null) {
            for (int addIndex = 0; addIndex < es.length; ++addIndex) {
                newContents.add(es[addIndex]);
            }
        }
        newContents.addAll(this.slice(_index + _howmany));
        this.clear();
        this.addAll(newContents);
        return removedElements;
    }

    public <R> R reduce(Accumulator<R, E> accumelator) {
        int len = this.length();
        if (len == 0) {
            throw new UnsupportedOperationException();
        }
        int i = -1;
        Object reduced = null;
        while (++i < len && reduced == null) {
            reduced = this.get(i);
        }
        while (i < len) {
            Object currentVal = this.get(i);
            if (currentVal != null) {
                reduced = accumelator.reduce(reduced, currentVal, i, this);
            }
            ++i;
        }
        return reduced;
    }

    public <R> void forEach(ArrayValueFunction<E, R> callback) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            callback.getValue(this.get(i), i, this);
        }
    }

    public ArrayEx<E> filter(ArrayValueFunction<E, Boolean> callback) {
        int len = this.length();
        ArrayEx mappedArray = new ArrayEx();
        for (int i = 0; i < len; ++i) {
            Boolean res;
            Object currentValue = this.get(i);
            if (currentValue == null || !(res = callback.getValue(currentValue, i, this)).booleanValue()) continue;
            mappedArray.add(currentValue);
        }
        return mappedArray;
    }

    public ArrayEx<E> concat(Object ... args) {
        ArrayEx<Object> newArray = new ArrayEx<Object>();
        newArray.addAll(this);
        for (Object obj : args) {
            if (obj instanceof ArrayEx) {
                newArray.addAll((ArrayEx)obj);
                continue;
            }
            newArray.add(obj);
        }
        return newArray;
    }

    public ArrayEx<E> slice() {
        return this.slice(0, this.length());
    }

    public ArrayEx<E> slice(int begin) {
        return this.slice(begin, this.length());
    }

    public ArrayEx<E> slice(int begin, int end) {
        int e = end < 0 ? this.length() + end : end;
        ArrayEx arr = new ArrayEx();
        for (int i = begin; i < e; ++i) {
            arr.add(this.get(i));
        }
        return arr;
    }

    public ArrayEx<E> reverse() {
        Collections.reverse(this);
        return this;
    }

    public ArrayEx<E> sort() {
        Collections.sort(this, new java.util.Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return Sort.ascending.compare(ObjectConverter.toString(o1), ObjectConverter.toString(o2));
            }
        });
        return this;
    }

    public ArrayEx<E> sort(final Comparator<E> c) {
        Collections.sort(this, new java.util.Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return c.compare(o1, o2);
            }
        });
        return this;
    }

    public String join() {
        return this.join(",");
    }

    @SwiftMethodOverload(overloads={"String"})
    public String join(Object separator) {
        int len = this.length();
        if (len == 0) {
            return "";
        }
        String sep = String.valueOf(separator);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            Object currentValue = this.get(i);
            if (currentValue != null) {
                sb.append(currentValue);
            }
            if (i == len - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public E pop() {
        return this.length() > 0 ? (E)this.remove(this.length() - 1) : null;
    }

    public E shift() {
        return this.remove(0);
    }

    public int unshift(E ... objects) {
        this.splice(0, 0, objects);
        return this.length();
    }

    public void push(E ... elements) {
        for (E element : elements) {
            this.add(element);
        }
    }

    public void setLength(int length) {
        block4: {
            int len = this.length();
            if (len == length) break block4;
            if (length < len) {
                for (int i = len - 1; i >= length; --i) {
                    this.remove(i);
                }
            } else {
                for (int i = len; i < length; ++i) {
                    this.add(null);
                }
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String toString() {
        return this.join();
    }

    @FunctionClass(value="reduce")
    @SwiftClosure(value="reduce")
    public static interface Accumulator<R, E> {
        public R reduce(R var1, E var2, int var3, ArrayEx<E> var4);
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface ArrayValueFunction<E, R> {
        public R getValue(E var1, int var2, ArrayEx<E> var3);
    }
}

