/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.color;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.color.Color;
import com.ibm.rave.core.color.HCL;
import com.ibm.rave.core.color.HSL;
import com.ibm.rave.core.color.LAB;
import com.ibm.rave.core.color.RGB;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.nativeImpl.RegExp;

public final class Colors {
    @InlineStringConstant
    private static final String HSL_STR = "hsl";
    @InlineStringConstant
    private static final String HSLA_STR = "hsla";
    @InlineStringConstant
    private static final String RGB_STR = "rgb";
    @InlineStringConstant
    private static final String RGBA_STR = "rgba";
    @InlineStringConstant
    private static final String COMMA_STR = ",";
    @InlineStringConstant
    private static final String PERCENT_STR = "%";
    @InlineStringConstant
    private static final String EMPTY_STR = "";
    @InlineStringConstant
    private static final String TRANSPARENT = "transparent";
    static double lab_X = 0.95047;
    static double lab_Y = 1.0;
    static double lab_Z = 1.08883;
    static double lab_K = 18.0;
    private static String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    @InlineStringConstant
    private static final String COLORS_REG_EXP_KEY = "COLORS_REG_EXP_KEY";
    static final OMap<String, RGB> rgb_names = Colors.initialize_rgb_names();

    private static RegExp getColorsRegExp() {
        RegExp regexp = (RegExp)RaveContextManager.INSTANCE.getRaveContext().getData(COLORS_REG_EXP_KEY);
        if (regexp == null) {
            regexp = new RegExp("([a-z]+)\\((.*)\\)", "i");
            RaveContextManager.INSTANCE.getRaveContext().putData(COLORS_REG_EXP_KEY, regexp);
        }
        return regexp;
    }

    private static OMap<String, RGB> initialize_rgb_names() {
        OMap<String, RGB> rgb_names = new OMap<String, RGB>();
        rgb_names.put("aliceblue", Colors.rgbNumber(0xF0F8FF));
        rgb_names.put("antiquewhite", Colors.rgbNumber(16444375));
        rgb_names.put("aqua", Colors.rgbNumber(65535));
        rgb_names.put("aquamarine", Colors.rgbNumber(8388564));
        rgb_names.put("azure", Colors.rgbNumber(0xF0FFFF));
        rgb_names.put("beige", Colors.rgbNumber(16119260));
        rgb_names.put("bisque", Colors.rgbNumber(16770244));
        rgb_names.put("black", Colors.rgbNumber(0));
        rgb_names.put("blanchedalmond", Colors.rgbNumber(16772045));
        rgb_names.put("blue", Colors.rgbNumber(255));
        rgb_names.put("blueviolet", Colors.rgbNumber(9055202));
        rgb_names.put("brown", Colors.rgbNumber(0xA52A2A));
        rgb_names.put("burlywood", Colors.rgbNumber(14596231));
        rgb_names.put("cadetblue", Colors.rgbNumber(6266528));
        rgb_names.put("chartreuse", Colors.rgbNumber(0x7FFF00));
        rgb_names.put("chocolate", Colors.rgbNumber(13789470));
        rgb_names.put("coral", Colors.rgbNumber(16744272));
        rgb_names.put("cornflowerblue", Colors.rgbNumber(6591981));
        rgb_names.put("cornsilk", Colors.rgbNumber(16775388));
        rgb_names.put("crimson", Colors.rgbNumber(14423100));
        rgb_names.put("cyan", Colors.rgbNumber(65535));
        rgb_names.put("darkblue", Colors.rgbNumber(139));
        rgb_names.put("darkcyan", Colors.rgbNumber(35723));
        rgb_names.put("darkgoldenrod", Colors.rgbNumber(12092939));
        rgb_names.put("darkgray", Colors.rgbNumber(0xA9A9A9));
        rgb_names.put("darkgreen", Colors.rgbNumber(25600));
        rgb_names.put("darkgrey", Colors.rgbNumber(0xA9A9A9));
        rgb_names.put("darkkhaki", Colors.rgbNumber(12433259));
        rgb_names.put("darkolivegreen", Colors.rgbNumber(5597999));
        rgb_names.put("darkorange", Colors.rgbNumber(16747520));
        rgb_names.put("darkorchid", Colors.rgbNumber(10040012));
        rgb_names.put("darkred", Colors.rgbNumber(0x8B0000));
        rgb_names.put("darksalmon", Colors.rgbNumber(15308410));
        rgb_names.put("darkseagreen", Colors.rgbNumber(9419919));
        rgb_names.put("darkslateblue", Colors.rgbNumber(4734347));
        rgb_names.put("darkslategray", Colors.rgbNumber(0x2F4F4F));
        rgb_names.put("darkslategrey", Colors.rgbNumber(0x2F4F4F));
        rgb_names.put("darkturquoise", Colors.rgbNumber(52945));
        rgb_names.put("darkviolet", Colors.rgbNumber(9699539));
        rgb_names.put("deeppink", Colors.rgbNumber(16716947));
        rgb_names.put("deepskyblue", Colors.rgbNumber(49151));
        rgb_names.put("dimgray", Colors.rgbNumber(0x696969));
        rgb_names.put("dimgrey", Colors.rgbNumber(0x696969));
        rgb_names.put("dodgerblue", Colors.rgbNumber(2003199));
        rgb_names.put("firebrick", Colors.rgbNumber(0xB22222));
        rgb_names.put("floralwhite", Colors.rgbNumber(0xFFFAF0));
        rgb_names.put("forestgreen", Colors.rgbNumber(0x228B22));
        rgb_names.put("fuchsia", Colors.rgbNumber(0xFF00FF));
        rgb_names.put("gainsboro", Colors.rgbNumber(0xDCDCDC));
        rgb_names.put("ghostwhite", Colors.rgbNumber(0xF8F8FF));
        rgb_names.put("gold", Colors.rgbNumber(16766720));
        rgb_names.put("goldenrod", Colors.rgbNumber(14329120));
        rgb_names.put("gray", Colors.rgbNumber(0x808080));
        rgb_names.put("green", Colors.rgbNumber(32768));
        rgb_names.put("greenyellow", Colors.rgbNumber(11403055));
        rgb_names.put("grey", Colors.rgbNumber(0x808080));
        rgb_names.put("honeydew", Colors.rgbNumber(0xF0FFF0));
        rgb_names.put("hotpink", Colors.rgbNumber(16738740));
        rgb_names.put("indianred", Colors.rgbNumber(0xCD5C5C));
        rgb_names.put("indigo", Colors.rgbNumber(4915330));
        rgb_names.put("ivory", Colors.rgbNumber(0xFFFFF0));
        rgb_names.put("khaki", Colors.rgbNumber(15787660));
        rgb_names.put("lavender", Colors.rgbNumber(15132410));
        rgb_names.put("lavenderblush", Colors.rgbNumber(0xFFF0F5));
        rgb_names.put("lawngreen", Colors.rgbNumber(8190976));
        rgb_names.put("lemonchiffon", Colors.rgbNumber(16775885));
        rgb_names.put("lightblue", Colors.rgbNumber(11393254));
        rgb_names.put("lightcoral", Colors.rgbNumber(0xF08080));
        rgb_names.put("lightcyan", Colors.rgbNumber(0xE0FFFF));
        rgb_names.put("lightgoldenrodyellow", Colors.rgbNumber(16448210));
        rgb_names.put("lightgray", Colors.rgbNumber(0xD3D3D3));
        rgb_names.put("lightgreen", Colors.rgbNumber(0x90EE90));
        rgb_names.put("lightgrey", Colors.rgbNumber(0xD3D3D3));
        rgb_names.put("lightpink", Colors.rgbNumber(16758465));
        rgb_names.put("lightsalmon", Colors.rgbNumber(16752762));
        rgb_names.put("lightseagreen", Colors.rgbNumber(2142890));
        rgb_names.put("lightskyblue", Colors.rgbNumber(8900346));
        rgb_names.put("lightslategray", Colors.rgbNumber(0x778899));
        rgb_names.put("lightslategrey", Colors.rgbNumber(0x778899));
        rgb_names.put("lightsteelblue", Colors.rgbNumber(11584734));
        rgb_names.put("lightyellow", Colors.rgbNumber(0xFFFFE0));
        rgb_names.put("lime", Colors.rgbNumber(65280));
        rgb_names.put("limegreen", Colors.rgbNumber(3329330));
        rgb_names.put("linen", Colors.rgbNumber(16445670));
        rgb_names.put("magenta", Colors.rgbNumber(0xFF00FF));
        rgb_names.put("maroon", Colors.rgbNumber(0x800000));
        rgb_names.put("mediumaquamarine", Colors.rgbNumber(6737322));
        rgb_names.put("mediumblue", Colors.rgbNumber(205));
        rgb_names.put("mediumorchid", Colors.rgbNumber(12211667));
        rgb_names.put("mediumpurple", Colors.rgbNumber(9662683));
        rgb_names.put("mediumseagreen", Colors.rgbNumber(3978097));
        rgb_names.put("mediumslateblue", Colors.rgbNumber(8087790));
        rgb_names.put("mediumspringgreen", Colors.rgbNumber(64154));
        rgb_names.put("mediumturquoise", Colors.rgbNumber(4772300));
        rgb_names.put("mediumvioletred", Colors.rgbNumber(13047173));
        rgb_names.put("midnightblue", Colors.rgbNumber(1644912));
        rgb_names.put("mintcream", Colors.rgbNumber(0xF5FFFA));
        rgb_names.put("mistyrose", Colors.rgbNumber(16770273));
        rgb_names.put("moccasin", Colors.rgbNumber(16770229));
        rgb_names.put("navajowhite", Colors.rgbNumber(16768685));
        rgb_names.put("navy", Colors.rgbNumber(128));
        rgb_names.put("oldlace", Colors.rgbNumber(16643558));
        rgb_names.put("olive", Colors.rgbNumber(0x808000));
        rgb_names.put("olivedrab", Colors.rgbNumber(7048739));
        rgb_names.put("orange", Colors.rgbNumber(16753920));
        rgb_names.put("orangered", Colors.rgbNumber(16729344));
        rgb_names.put("orchid", Colors.rgbNumber(14315734));
        rgb_names.put("palegoldenrod", Colors.rgbNumber(0xEEE8AA));
        rgb_names.put("palegreen", Colors.rgbNumber(10025880));
        rgb_names.put("paleturquoise", Colors.rgbNumber(0xAFEEEE));
        rgb_names.put("palevioletred", Colors.rgbNumber(14381203));
        rgb_names.put("papayawhip", Colors.rgbNumber(16773077));
        rgb_names.put("peachpuff", Colors.rgbNumber(16767673));
        rgb_names.put("peru", Colors.rgbNumber(13468991));
        rgb_names.put("pink", Colors.rgbNumber(16761035));
        rgb_names.put("plum", Colors.rgbNumber(0xDDA0DD));
        rgb_names.put("powderblue", Colors.rgbNumber(11591910));
        rgb_names.put("purple", Colors.rgbNumber(0x800080));
        rgb_names.put("rebeccapurple", Colors.rgbNumber(0x663399));
        rgb_names.put("red", Colors.rgbNumber(0xFF0000));
        rgb_names.put("rosybrown", Colors.rgbNumber(12357519));
        rgb_names.put("royalblue", Colors.rgbNumber(4286945));
        rgb_names.put("saddlebrown", Colors.rgbNumber(9127187));
        rgb_names.put("salmon", Colors.rgbNumber(16416882));
        rgb_names.put("sandybrown", Colors.rgbNumber(16032864));
        rgb_names.put("seagreen", Colors.rgbNumber(3050327));
        rgb_names.put("seashell", Colors.rgbNumber(0xFFF5EE));
        rgb_names.put("sienna", Colors.rgbNumber(10506797));
        rgb_names.put("silver", Colors.rgbNumber(0xC0C0C0));
        rgb_names.put("skyblue", Colors.rgbNumber(8900331));
        rgb_names.put("slateblue", Colors.rgbNumber(6970061));
        rgb_names.put("slategray", Colors.rgbNumber(7372944));
        rgb_names.put("slategrey", Colors.rgbNumber(7372944));
        rgb_names.put("snow", Colors.rgbNumber(0xFFFAFA));
        rgb_names.put("springgreen", Colors.rgbNumber(65407));
        rgb_names.put("steelblue", Colors.rgbNumber(4620980));
        rgb_names.put("tan", Colors.rgbNumber(13808780));
        rgb_names.put("teal", Colors.rgbNumber(32896));
        rgb_names.put("thistle", Colors.rgbNumber(14204888));
        rgb_names.put("tomato", Colors.rgbNumber(16737095));
        rgb_names.put("turquoise", Colors.rgbNumber(4251856));
        rgb_names.put("violet", Colors.rgbNumber(0xEE82EE));
        rgb_names.put("wheat", Colors.rgbNumber(16113331));
        rgb_names.put("white", Colors.rgbNumber(0xFFFFFF));
        rgb_names.put("whitesmoke", Colors.rgbNumber(0xF5F5F5));
        rgb_names.put("yellow", Colors.rgbNumber(0xFFFF00));
        rgb_names.put("yellowgreen", Colors.rgbNumber(10145074));
        return rgb_names;
    }

    static HSL rgb_hsl(double r, double g, double b, double a) {
        double h;
        double s;
        double _r = r;
        double _g = g;
        double _b = b;
        double min = Math.min(Math.min(_r /= 255.0, _g /= 255.0), _b /= 255.0);
        double max = Math.max(Math.max(_r, _g), _b);
        double d = max - min;
        double l = (max + min) / 2.0;
        if (d != 0.0) {
            double d2 = s = l < 0.5 ? d / (max + min) : d / (2.0 - max - min);
            h = _r == max ? (_g - _b) / d + (double)(_g < _b ? 6 : 0) : (_g == max ? (_b - _r) / d + 2.0 : (_r - _g) / d + 4.0);
            h *= 60.0;
        } else {
            h = Double.NaN;
            s = l > 0.0 && l < 1.0 ? 0.0 : h;
        }
        return new HSL(h, s, l, a);
    }

    public static String rgb_hex(int v) {
        int _v = v;
        if (_v < 0) {
            _v = 0;
        } else if (_v > 255) {
            _v = 255;
        }
        return hexDigits[_v >> 4 & 0xF] + hexDigits[_v & 0xF];
    }

    public static RGB hsl_rgb(double h, double s, double l, double a) {
        double d;
        double _h = h;
        double _s = s;
        double _l = l;
        if (Double.isNaN(_h)) {
            d = 0.0;
        } else {
            double d2;
            _h %= 360.0;
            d = _h = d2 < 0.0 ? _h + 360.0 : _h;
        }
        double d3 = Double.isNaN(_s) ? 0.0 : (_s < 0.0 ? 0.0 : (_s = _s > 1.0 ? 1.0 : _s));
        _l = _l < 0.0 ? 0.0 : (_l > 1.0 ? 1.0 : _l);
        double m2 = _l <= 0.5 ? _l * (1.0 + _s) : _l + _s - _l * _s;
        double m1 = 2.0 * _l - m2;
        return new RGB((int)Math.round(Colors.normalizeHue(_h + 120.0, m1, m2) * 255.0), (int)Math.round(Colors.normalizeHue(_h, m1, m2) * 255.0), (int)Math.round(Colors.normalizeHue(_h - 120.0, m1, m2) * 255.0), a);
    }

    static double normalizeHue(double h, double m1, double m2) {
        double _h = h;
        if (_h > 360.0) {
            _h -= 360.0;
        } else if (_h < 0.0) {
            _h += 360.0;
        }
        if (_h < 60.0) {
            return m1 + (m2 - m1) * _h / 60.0;
        }
        if (_h < 180.0) {
            return m2;
        }
        if (_h < 240.0) {
            return m1 + (m2 - m1) * (240.0 - _h) / 60.0;
        }
        return m1;
    }

    static RGB rgbNumber(int value) {
        return new RGB(value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, 1.0);
    }

    static String rgbString(int value) {
        return Colors.rgbNumber(value).toString();
    }

    static double rgb_parseNumber(String c) {
        double d = Double.parseDouble(c);
        return c.charAt(c.length() - 1) == '%' ? (double)Math.round(d * 2.55) : d;
    }

    static Color rgb_parse(String format) {
        RGB color;
        if (format == null || format.length() == 0) {
            return new RGB(0, 0, 0, 1.0);
        }
        if (TRANSPARENT.equals(format)) {
            return new RGB(0, 0, 0, 0.0);
        }
        int r = 0;
        int g = 0;
        int b = 0;
        RegExp.RegExpResult m1 = Colors.getColorsRegExp().exec(format);
        if (m1 != null && m1.size() > 0) {
            String[] m2 = ((String)m1.get(2)).split(COMMA_STR);
            if (HSL_STR.equals(m1.get(1))) {
                return new HSL(Double.parseDouble(m2[0]), Double.parseDouble(m2[1].replace(PERCENT_STR, EMPTY_STR)) / 100.0, Double.parseDouble(m2[2].replace(PERCENT_STR, EMPTY_STR)) / 100.0, 1.0);
            }
            if (HSLA_STR.equals(m1.get(1))) {
                return new HSL(Double.parseDouble(m2[0]), Double.parseDouble(m2[1].replace(PERCENT_STR, EMPTY_STR)) / 100.0, Double.parseDouble(m2[2].replace(PERCENT_STR, EMPTY_STR)) / 100.0, Double.parseDouble(m2[3]));
            }
            if (RGBA_STR.equals(m1.get(1))) {
                return new RGB((int)Colors.rgb_parseNumber(m2[0]), (int)Colors.rgb_parseNumber(m2[1]), (int)Colors.rgb_parseNumber(m2[2]), Colors.rgb_parseNumber(m2[3]));
            }
            if (RGB_STR.equals(m1.get(1))) {
                return new RGB((int)Colors.rgb_parseNumber(m2[0]), (int)Colors.rgb_parseNumber(m2[1]), (int)Colors.rgb_parseNumber(m2[2]), 1.0);
            }
        }
        if (format.charAt(0) != '#' && (color = rgb_names.get(format.toLowerCase())) != null) {
            return new RGB(color.r, color.g, color.b, 1.0);
        }
        int colorValue = 0;
        if (format.charAt(0) == '#' && !Double.isNaN(colorValue = Integer.parseInt(format.substring(1), 16))) {
            if (format.length() == 4) {
                r = (colorValue & 0xF00) >> 4;
                r = r >> 4 | r;
                g = colorValue & 0xF0;
                g = g >> 4 | g;
                b = colorValue & 0xF;
                b = b << 4 | b;
            } else if (format.length() == 7) {
                r = (colorValue & 0xFF0000) >> 16;
                g = (colorValue & 0xFF00) >> 8;
                b = colorValue & 0xFF;
            }
        }
        return new RGB(r, g, b, 1.0);
    }

    static LAB rgb_lab(double r, double g, double b) {
        double _r = r;
        double _g = g;
        double _b = b;
        _r = Colors.rgb_xyz(_r);
        _g = Colors.rgb_xyz(_g);
        _b = Colors.rgb_xyz(_b);
        double x = Colors.xyz_lab((0.4124564 * _r + 0.3575761 * _g + 0.1804375 * _b) / lab_X);
        double y = Colors.xyz_lab((0.2126729 * _r + 0.7151522 * _g + 0.072175 * _b) / lab_Y);
        double z = Colors.xyz_lab((0.0193339 * _r + 0.119192 * _g + 0.9503041 * _b) / lab_Z);
        return new LAB(116.0 * y - 16.0, 500.0 * (x - y), 200.0 * (y - z));
    }

    public static LAB hcl_lab(double h, double c, double l) {
        double _h = h;
        double _c = c;
        if (Double.isNaN(_h)) {
            _h = 0.0;
        }
        if (Double.isNaN(_c)) {
            _c = 0.0;
        }
        return new LAB(l, Math.cos(_h *= Math.PI / 180) * _c, Math.sin(_h) * _c);
    }

    static double xyz_lab(double x) {
        return x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787037 * x + 0.13793103448275862;
    }

    static double xyz_rgb(double r) {
        return Math.round(255.0 * (r <= 0.00304 ? 12.92 * r : 1.055 * Math.pow(r, 0.4166666666666667) - 0.055));
    }

    static double rgb_xyz(double r) {
        double d;
        double _r = r;
        return d <= 0.04045 ? _r / 12.92 : Math.pow(((_r /= 255.0) + 0.055) / 1.055, 2.4);
    }

    static HCL lab_hcl(double l, double a, double b) {
        return l > 0.0 ? new HCL(Math.atan2(b, a) * 57.29577951308232, Math.sqrt(a * a + b * b), l) : new HCL(Double.NaN, Double.NaN, l);
    }

    public static RGB lab_rgb(double l, double a, double b) {
        double y = (l + 16.0) / 116.0;
        double x = y + a / 500.0;
        double z = y - b / 200.0;
        x = Colors.lab_xyz(x) * lab_X;
        y = Colors.lab_xyz(y) * lab_Y;
        z = Colors.lab_xyz(z) * lab_Z;
        return new RGB((int)Colors.xyz_rgb(3.2404542 * x - 1.5371385 * y - 0.4985314 * z), (int)Colors.xyz_rgb(-0.969266 * x + 1.8760108 * y + 0.041556 * z), (int)Colors.xyz_rgb(0.0556434 * x - 0.2040259 * y + 1.0572252 * z), 1.0);
    }

    static double lab_xyz(double x) {
        return x > 0.206893034 ? x * x * x : (x - 0.13793103448275862) / 7.787037;
    }

    private Colors() {
    }

    public static LAB newLAB(double l, double a, double b) {
        return new LAB(l, a, b);
    }

    @SwiftMethodOverload(overloads={"String"})
    public static LAB newLAB(Object color) {
        if (color instanceof LAB) {
            LAB lab = (LAB)color;
            return new LAB(lab.l, lab.a, lab.b);
        }
        if (color instanceof RGB) {
            return ((RGB)color).lab();
        }
        if (color instanceof HCL) {
            return ((HCL)color).lab();
        }
        return Colors.rgb_parse(color == null ? EMPTY_STR : color.toString()).rgb().lab();
    }

    public static HCL newHCL(double h, double c, double l) {
        return new HCL(h, c, l);
    }

    @SwiftMethodOverload(overloads={"String"})
    public static HCL newHCL(Object color) {
        if (color instanceof HCL) {
            HCL hcl = (HCL)color;
            return new HCL(hcl.h, hcl.c, hcl.l);
        }
        if (color instanceof LAB) {
            return ((LAB)color).hcl();
        }
        return Colors.rgb_parse(color == null ? EMPTY_STR : color.toString()).rgb().lab().hcl();
    }

    public static HSL newHSL(double h, double s, double l) {
        return new HSL(h, s, l, 1.0);
    }

    public static HSL newHSLA(double h, double s, double l, double a) {
        return new HSL(h, s, l, a);
    }

    @SwiftMethodOverload(overloads={"String"})
    public static HSL newHSL(Object color) {
        if (color instanceof HSL) {
            HSL hsl = (HSL)color;
            return new HSL(hsl.h, hsl.s, hsl.l, hsl.a);
        }
        if (color instanceof RGB) {
            return ((RGB)color).hsl();
        }
        Color c = Colors.rgb_parse(color == null ? EMPTY_STR : color.toString());
        if (c instanceof HSL) {
            return (HSL)c;
        }
        return ((RGB)c).hsl();
    }

    public static RGB newRGB(int r, int g, int b) {
        return new RGB(r, g, b, 1.0);
    }

    public static RGB newRGBA(int r, int g, int b, double a) {
        return new RGB(r, g, b, a);
    }

    @SwiftMethodOverload(overloads={"String"})
    public static RGB newRGB(Object color) {
        if (color instanceof Color) {
            RGB rgb = ((Color)color).rgb();
            return new RGB(rgb.r, rgb.g, rgb.b, rgb.a);
        }
        return Colors.rgb_parse(color == null ? EMPTY_STR : color.toString()).rgb();
    }

    public static boolean isRGBColorName(String str) {
        return rgb_names.containsKey(str);
    }
}

