/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.color;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.color.Color;
import com.ibm.rave.core.color.Colors;
import com.ibm.rave.core.color.LAB;
import com.ibm.rave.core.color.RGB;
import com.ibm.rave.core.internal.color.ContrastShift;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public final class HCL
extends Color {
    final double h;
    final double c;
    final double l;

    HCL(double h, double c, double l) {
        this.h = ObjectConverter.toDouble(h);
        this.c = ObjectConverter.toDouble(c);
        this.l = ObjectConverter.toDouble(l);
    }

    @Override
    public RGB rgb() {
        return this.lab().rgb();
    }

    @Override
    public Color brighter(double k) {
        return new HCL(this.h, this.c, Math.min(100.0, this.l + Colors.lab_K * k));
    }

    @Override
    public Color darker(double k) {
        return new HCL(this.h, this.c, Math.max(0.0, this.l - Colors.lab_K * k));
    }

    LAB lab() {
        return Colors.hcl_lab(this.h, this.c, this.l);
    }

    public double getH() {
        return this.h;
    }

    public double getC() {
        return this.c;
    }

    public double getL() {
        return this.l;
    }

    @Override
    public Color contrastShift() {
        return ContrastShift.updateColor(this.rgb(), this.rgb()).lab().hcl();
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public Color contrastShift(Object color) {
        return ContrastShift.updateColor(this.rgb(), Colors.newRGB(color)).lab().hcl();
    }

    @Override
    public Color contrastShift(double ratio) {
        return ContrastShift.updateColor(this.rgb(), this.rgb(), ratio).lab().hcl();
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public Color contrastShift(Object color, double ratio) {
        return ContrastShift.updateColor(this.rgb(), Colors.newRGB(color), ratio).lab().hcl();
    }

    @Override
    public double getLuminance() {
        return ContrastShift.getLuminance(this.rgb());
    }
}

