/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.css;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.css.CSSEngine;
import com.ibm.rave.core.css.CSSStyleSheet;
import com.ibm.rave.core.internal.css.CSSParser;
import com.ibm.rave.core.internal.css.CSSStyleSheetManager;
import java.util.List;

public class RaveCSSEngine
implements CSSEngine {
    private final ArrayEx<CSSStyleSheet> stylesheets = new ArrayEx();

    @Override
    public CSSStyleSheet importCSS(String cssText) {
        CSSStyleSheet styleSheet = CSSParser.parse(cssText);
        if (styleSheet != null) {
            return this.importStyleSheet(styleSheet) ? styleSheet : null;
        }
        return null;
    }

    @Override
    public boolean importStyleSheets(List<CSSStyleSheet> styleSheets) {
        if (styleSheets != null) {
            boolean result = true;
            for (CSSStyleSheet styleSheet : styleSheets) {
                if (this.importStyleSheet(styleSheet)) continue;
                result = false;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean importStyleSheet(CSSStyleSheet styleSheet) {
        if (styleSheet != null && !this.stylesheets.contains(styleSheet)) {
            CSSStyleSheetManager.INSTANCE.add(styleSheet);
            this.stylesheets.add(styleSheet);
            return true;
        }
        return false;
    }

    @Override
    public ArrayEx<CSSStyleSheet> styleSheets() {
        return this.stylesheets;
    }

    @Override
    public void removeAllStyleSheets() {
        this.stylesheets.clear();
        CSSStyleSheetManager.INSTANCE.clear();
    }

    @Override
    public boolean removeStyleSheet(CSSStyleSheet styleSheet) {
        int index = this.stylesheets.indexOf(styleSheet);
        if (index > -1) {
            this.stylesheets.splice(index, 1, (CSSStyleSheet[])new CSSStyleSheet[0]);
            return CSSStyleSheetManager.INSTANCE.remove(styleSheet);
        }
        return false;
    }
}

