/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.format;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.format.Round;
import com.ibm.rave.core.internal.format.Precision;
import com.ibm.rave.core.internal.util.MathUtil;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public class FormatPrefix {
    private static final ArrayEx<FormatPrefix> formatPrefixes = new ArrayEx<String>("y", "z", "a", "f", "p", "n", "\u00b5", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y").map(new ArrayEx.ArrayValueFunction<String, FormatPrefix>(){

        @Override
        public FormatPrefix getValue(String currentValue, int index, ArrayEx<String> array) {
            return new FormatPrefix(currentValue, index);
        }
    });
    public final String symbol;
    public final ScaleValueFunction scale;

    private FormatPrefix(String symbol, double i) {
        final double k = Math.pow(10.0, Math.abs(8.0 - i) * 3.0);
        this.scale = i > 8.0 ? new ScaleValueFunction(){

            @Override
            public double scale(double d) {
                return d / k;
            }
        } : new ScaleValueFunction(){

            @Override
            public double scale(double d) {
                return d * k;
            }
        };
        this.symbol = symbol;
    }

    public static FormatPrefix formatPrefix(double value, Integer precision) {
        double _value = value;
        double i = 0.0;
        if (ObjectConverter.toBoolean(_value)) {
            if (_value < 0.0) {
                _value *= -1.0;
            }
            if (ObjectConverter.toBoolean(precision)) {
                _value = Round.round(_value, Precision.precision(_value, precision));
            }
            i = 1.0 + Math.floor(1.0E-12 + Math.log(_value) / MathUtil.LN10);
            i = Math.max(-24.0, Math.min(24.0, Math.floor((i - 1.0) / 3.0) * 3.0));
        }
        return (FormatPrefix)formatPrefixes.get((int)(8.0 + i / 3.0));
    }

    @FunctionClass(value="scale")
    @SwiftClosure(value="scale")
    public static interface ScaleValueFunction {
        public double scale(double var1);
    }
}

