/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.geo;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geo.StreamListener;
import com.ibm.rave.core.geo.TransformStreamListener;
import com.ibm.rave.core.internal.geo.ClipExtentStreamListener;
import com.ibm.rave.core.internal.geo.ClipExtentStreamListenerFactory;
import com.ibm.rave.core.internal.geo.ClipUtil;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.List;

public final class ClipExtentStreamListenerTransform {
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private ClipExtentStreamListener transformListener;
    private ClipExtentStreamListenerFactory clip;

    private ClipExtentStreamListenerTransform() {
    }

    public TransformStreamListener stream(StreamListener listener) {
        if (this.transformListener != null) {
            this.transformListener.setValid(false);
        }
        this.transformListener = this.clip.stream(listener);
        this.transformListener.setValid(true);
        return this.transformListener;
    }

    public ClipExtentStreamListenerTransform extent(List<? extends List<?>> ext) {
        this.x0 = ObjectConverter.toDouble(ext.get(0).get(0));
        this.y0 = ObjectConverter.toDouble(ext.get(0).get(1));
        this.x1 = ObjectConverter.toDouble(ext.get(1).get(0));
        this.y1 = ObjectConverter.toDouble(ext.get(1).get(1));
        this.clip = ClipUtil.newClipExtentStreamListenerFactory(this.x0, this.y0, this.x1, this.y1);
        if (this.transformListener != null) {
            this.transformListener.setValid(false);
            this.transformListener = null;
        }
        return this;
    }

    public List<? extends List<? extends Number>> extent() {
        return new ArrayEx<ArrayEx>(new ArrayEx<Double>(this.x0, this.y0), new ArrayEx<Double>(this.x1, this.y1));
    }

    public static ClipExtentStreamListenerTransform newClipExtent() {
        ClipExtentStreamListenerTransform clipExtent = new ClipExtentStreamListenerTransform();
        return clipExtent.extent(new ArrayEx<ArrayEx>(new ArrayEx<Double>(0.0, 0.0), new ArrayEx<Double>(960.0, 500.0)));
    }
}

