/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.geom;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Hull;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.PointStruct;
import com.ibm.rave.core.geom.Polygon;
import com.ibm.rave.core.geom.QuadTree;
import com.ibm.rave.core.geom.Voronoi;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiPolygon;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.List;

public final class Geom {
    public static final Geom INSTANCE = new Geom();

    private Geom() {
    }

    public <T> QuadTree<T> quadtree() {
        return QuadTree.createQuadTree();
    }

    public <T extends PointStruct> QuadTree.RootQTNode<T> quadtree(List<T> data) {
        return QuadTree.createQuadTree(data);
    }

    public <T extends PointStruct> QuadTree.RootQTNode<T> quadtree(List<T> data, double x1, double y1, double x2, double y2) {
        return QuadTree.createQuadTree(data, x1, y1, x2, y2);
    }

    public <T extends PointStruct> QuadTree.RootQTNode<T> quadtree(List<T> data, double x1, double y1) {
        return QuadTree.createQuadTree(data, x1, y1);
    }

    public Polygon polygon(List<List<? extends Number>> coordinates) {
        return new Polygon(coordinates);
    }

    public Voronoi voronoi() {
        return new Voronoi();
    }

    @Deprecated
    public <T> ArrayEx<VoronoiPolygon<T>> voronoi(ArrayEx<T> data) {
        return new Voronoi().voronoi(data);
    }

    public Hull hull() {
        return new Hull();
    }

    public ArrayEx<Point> hull(List<Point> data) {
        return new Hull().hull(data);
    }

    @Deprecated
    public <T> ArrayEx<ArrayEx<T>> delaunay(List<T> vertices) {
        return new Voronoi().triangles(ObjectConverter.listToArray(vertices));
    }
}

