/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.geom;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.internal.math.Trigonometry;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.util.Comparator;
import java.util.List;

@FunctionClass(value="hull")
public class Hull {
    private HullFunction fx = FX_COMP_FN;
    private HullFunction fy = FY_COMP_FN;
    private Object xVal = this.fx;
    private Object yVal = this.fy;
    static Comparator<HullPoint> geom_hullOrder = new Comparator<HullPoint>(){

        @Override
        public int compare(HullPoint a, HullPoint b) {
            int val = (int)(a.x - b.x);
            if (val != 0) {
                return val;
            }
            return (int)(a.y - b.y);
        }
    };
    private static final HullFunction FX_COMP_FN = new HullFunction(){

        @Override
        public Object getValue(Point data, int i) {
            return data.getX();
        }
    };
    private static final HullFunction FY_COMP_FN = new HullFunction(){

        @Override
        public Object getValue(Point data, int i) {
            return data.getY();
        }
    };

    public ArrayEx<Point> hull(List<Point> vertices) {
        int i;
        if (vertices == null || vertices.size() < 3) {
            return new ArrayEx<Point>();
        }
        int n = vertices.size();
        ArrayEx<HullPoint> points = new ArrayEx<HullPoint>();
        ArrayEx<HullPoint> flippedPoints = new ArrayEx<HullPoint>();
        int i2 = 0;
        while (i2 < n) {
            HullPoint p = new HullPoint();
            p.x = ObjectConverter.toDouble(this.fx.getValue(vertices.get(i2), i2));
            p.y = ObjectConverter.toDouble(this.fy.getValue(vertices.get(i2), i2));
            p.index = i2++;
            points.push((HullPoint[])new HullPoint[]{p});
        }
        points.sort(geom_hullOrder);
        for (i2 = 0; i2 < n; ++i2) {
            HullPoint point = new HullPoint();
            point.x = ((HullPoint)points.get((int)i2)).x;
            point.y = -((HullPoint)points.get((int)i2)).y;
            flippedPoints.push((HullPoint[])new HullPoint[]{point});
        }
        ArrayEx<Integer> upper = Hull.geom_hullUpper(points);
        ArrayEx<Integer> lower = Hull.geom_hullUpper(flippedPoints);
        int skipLeft = 0;
        int skipRight = 0;
        if (lower.get(0) == null && upper.get(0) == null || ObjectConverter.toInt(lower.get(0)) == ObjectConverter.toInt(upper.get(0))) {
            skipLeft = 1;
        }
        if (lower.get(lower.size() - 1) == null && upper.get(upper.size() - 1) == null || ObjectConverter.toInt(lower.get(lower.size() - 1)) == ObjectConverter.toInt(upper.get(upper.size() - 1))) {
            skipRight = 1;
        }
        ArrayEx<Point> polygon = new ArrayEx<Point>();
        for (i = upper.size() - 1; i >= 0; --i) {
            HullPoint upperPoint = (HullPoint)points.get((Integer)upper.get(i));
            polygon.push((Point[])new Point[]{vertices.get(upperPoint.index)});
        }
        for (i = skipLeft; i < lower.size() - skipRight; ++i) {
            HullPoint lowerPoint = (HullPoint)points.get((Integer)lower.get(i));
            polygon.push((Point[])new Point[]{vertices.get(lowerPoint.index)});
        }
        return polygon;
    }

    public Object x() {
        return this.xVal;
    }

    public Hull x(final double x) {
        this.fx = new HullFunction(){

            @Override
            public Object getValue(Point data, int i) {
                if (data == null) {
                    return Lang.undefined();
                }
                return x;
            }
        };
        this.xVal = x;
        return this;
    }

    public Hull x(HullFunction x) {
        this.fx = x;
        this.xVal = x;
        return this;
    }

    public Object y() {
        return this.yVal;
    }

    public Hull y(final double y) {
        this.fy = new HullFunction(){

            @Override
            public Object getValue(Point data, int i) {
                if (data == null) {
                    return Lang.undefined();
                }
                return y;
            }
        };
        this.yVal = y;
        return this;
    }

    public Hull y(HullFunction y) {
        this.fy = y;
        this.yVal = y;
        return this;
    }

    private static ArrayEx<Integer> geom_hullUpper(ArrayEx<HullPoint> points) {
        int n = points.size();
        ArrayEx<Integer> hull = new ArrayEx<Integer>(0, 1);
        int hs = 2;
        for (int i = 2; i < n; ++i) {
            while (hs > 1 && Trigonometry.cross2d(((HullPoint)points.get((Integer)hull.get(hs - 2))).toDoubleArray(), ((HullPoint)points.get((Integer)hull.get(hs - 1))).toDoubleArray(), ((HullPoint)points.get(i)).toDoubleArray()) <= 0.0) {
                --hs;
            }
            hull.set(hs++, i);
        }
        return hull.slice(0, hs);
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface HullFunction {
        public Object getValue(Point var1, int var2);
    }

    private class HullPoint {
        double x;
        double y;
        int index;

        private HullPoint() {
        }

        public ArrayEx<Double> toDoubleArray() {
            return new ArrayEx<Double>(this.x, this.y);
        }
    }
}

