/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.geom;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.geom.PolygonUtil;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import java.util.ArrayList;
import java.util.List;

public final class Polygon
extends ArrayList<List<? extends Number>> {
    private static void addCollection(List<List<? extends Number>> coordinates1, List<List<? extends Number>> coordinates2) {
        for (int index = 0; index < coordinates2.size(); ++index) {
            coordinates1.add(coordinates2.get(index));
        }
    }

    public Polygon(List<List<? extends Number>> coordinates) {
        Polygon.addCollection(this, coordinates);
    }

    public double area() {
        int i = -1;
        int n = this.size();
        List b = (List)this.get(n - 1);
        double area = 0.0;
        while (++i < n) {
            List a = b;
            b = (List)this.get(i);
            area += ((Number)a.get(1)).doubleValue() * ((Number)b.get(0)).doubleValue() - ((Number)a.get(0)).doubleValue() * ((Number)b.get(1)).doubleValue();
        }
        return area * 0.5;
    }

    public List<Double> centroid() {
        int i = -1;
        int n = this.size();
        double x = 0.0;
        double y = 0.0;
        List b = (List)this.get(n - 1);
        double c = 0.0;
        double k = -1.0 / (6.0 * this.area());
        while (++i < n) {
            List a = b;
            b = (List)this.get(i);
            c = ((Number)a.get(0)).doubleValue() * ((Number)b.get(1)).doubleValue() - ((Number)b.get(0)).doubleValue() * ((Number)a.get(1)).doubleValue();
            x += (((Number)a.get(0)).doubleValue() + ((Number)b.get(0)).doubleValue()) * c;
            y += (((Number)a.get(1)).doubleValue() + ((Number)b.get(1)).doubleValue()) * c;
        }
        return new ArrayEx<Double>(x * k, y * k);
    }

    public List<Double> centroid(double k) {
        int i = -1;
        int n = this.size();
        double x = 0.0;
        double y = 0.0;
        List b = (List)this.get(n - 1);
        double c = 0.0;
        while (++i < n) {
            List a = b;
            b = (List)this.get(i);
            c = ((Number)a.get(0)).doubleValue() * ((Number)b.get(1)).doubleValue() - ((Number)b.get(0)).doubleValue() * ((Number)a.get(1)).doubleValue();
            x += (((Number)a.get(0)).doubleValue() + ((Number)b.get(0)).doubleValue()) * c;
            y += (((Number)a.get(1)).doubleValue() + ((Number)b.get(1)).doubleValue()) * c;
        }
        return new ArrayEx<Double>(x * k, y * k);
    }

    public List<List<? extends Number>> clip(List<List<? extends Number>> subject) {
        boolean closed = Polygon.geom_polygonClosed(subject);
        int i = -1;
        int n = this.size();
        if (Polygon.geom_polygonClosed(this)) {
            --n;
        }
        int j = 0;
        int m = 0;
        List a = (List)this.get(n - 1);
        List<List<? extends Number>> _subject = subject;
        while (++i < n) {
            ArrayList<List<? extends Number>> input = new ArrayList<List<? extends Number>>();
            for (List<? extends Number> val : _subject) {
                input.add(val);
            }
            _subject = new ArrayEx<List<? extends Number>>();
            List b = (List)this.get(i);
            m = input.size();
            if (closed) {
                --m;
            }
            List c = (List)input.get(m - 1);
            j = -1;
            while (++j < m) {
                List d = (List)input.get(j);
                if (Polygon.geom_polygonInside(d, a, b)) {
                    if (!Polygon.geom_polygonInside(c, a, b)) {
                        _subject.add(PolygonUtil.polygonIntersect(c, d, a, b));
                    }
                    _subject.add(d);
                } else if (Polygon.geom_polygonInside(c, a, b)) {
                    _subject.add(PolygonUtil.polygonIntersect(c, d, a, b));
                }
                c = d;
            }
            if (closed) {
                _subject.add(_subject.get(0));
            }
            a = b;
        }
        return _subject;
    }

    private static boolean geom_polygonInside(List<? extends Number> p, List<? extends Number> a, List<? extends Number> b) {
        return (b.get(0).doubleValue() - a.get(0).doubleValue()) * (p.get(1).doubleValue() - a.get(1).doubleValue()) < (b.get(1).doubleValue() - a.get(1).doubleValue()) * (p.get(0).doubleValue() - a.get(0).doubleValue());
    }

    private static boolean geom_polygonClosed(List<List<? extends Number>> subject) {
        List<? extends Number> a = subject.get(0);
        List<? extends Number> b = subject.get(subject.size() - 1);
        return !ObjectConverter.toBoolean(a.get(0).doubleValue() - b.get(0).doubleValue()) && !ObjectConverter.toBoolean(a.get(1).doubleValue() - b.get(1).doubleValue());
    }
}

