/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.geom;

import com.ibm.rave.core.geom.RectStruct;

public final class RaveRect {
    public final double x;
    public final double y;
    public final double width;
    public final double height;

    public RaveRect(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public final double getX() {
        return this.x;
    }

    public final double getX2() {
        return this.x + this.width;
    }

    public final double getY() {
        return this.y;
    }

    public final double getY2() {
        return this.y + this.height;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public boolean intersects(RectStruct rect) {
        return this.x <= rect.x + rect.width && this.x + this.width >= rect.x && this.y <= rect.y + rect.height && this.y + this.height >= rect.y;
    }

    public boolean contains(double X, double Y) {
        if (this.width < 0.0 || this.height < 0.0) {
            return false;
        }
        return X >= this.x && Y >= this.y && X <= this.x + this.width && Y <= this.y + this.height;
    }
}

