/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.geom;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiCell;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiContext;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiEdge;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiIndex;
import com.ibm.rave.core.internal.geom.voronoi.VoronoiPolygon;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.SVGLine;

@FunctionClass(value="voronoi")
public class Voronoi {
    private static double[][] DEFAULT_CLIPEXTENT = new double[][]{{-1000000.0, -1000000.0}, {1000000.0, 1000000.0}};
    private double[][] clipExtentVal = DEFAULT_CLIPEXTENT;
    private ValueFunction<Object, ?> fx = SVGLine.DEFAULT_X_FN;
    private ValueFunction<Object, ?> fy = SVGLine.DEFAULT_Y_FN;
    private final VoronoiContext voronoieContext = new VoronoiContext();
    private Object xVal = this.fx;
    private Object yVal = this.fy;

    private <T> ArrayEx<VoronoiEdge.VoronoiSite> sites(ArrayEx<T> data) {
        final Voronoi self = this;
        return data.map(new ArrayEx.ArrayValueFunction<T, VoronoiEdge.VoronoiSite>(){

            @Override
            public VoronoiEdge.VoronoiSite getValue(T d, int i, ArrayEx<T> array) {
                double x = (double)Math.round(ObjectConverter.toDouble(self.fx.getValue(this, d, i, -1)) / 1.0E-6) * 1.0E-6;
                double y = (double)Math.round(ObjectConverter.toDouble(self.fy.getValue(this, d, i, -1)) / 1.0E-6) * 1.0E-6;
                VoronoiEdge.VoronoiSite site = new VoronoiEdge.VoronoiSite(x, y);
                site.i = i;
                return site;
            }
        });
    }

    public <T> ArrayEx<VoronoiPolygon<T>> voronoi(final ArrayEx<T> data) {
        final ArrayEx<VoronoiPolygon<T>> polygons = new ArrayEx<VoronoiPolygon<T>>(data.size());
        final double x0 = this.clipExtentVal[0][0];
        final double y0 = this.clipExtentVal[0][1];
        final double x1 = this.clipExtentVal[1][0];
        final double y1 = this.clipExtentVal[1][1];
        ArrayEx<VoronoiCell> cells = VoronoiIndex.voronoi((VoronoiContext)this.voronoieContext, this.sites(data), (double[][])this.clipExtentVal).voronoiCells;
        cells.forEach(new ArrayEx.ArrayValueFunction<VoronoiCell, Object>(){

            @Override
            public Object getValue(VoronoiCell cell, int index, ArrayEx<VoronoiCell> array) {
                ArrayEx<VoronoiEdge.VoronoiHalfEdge> edges = cell.edges;
                VoronoiEdge.VoronoiSite site = cell.site;
                if (edges.length() != 0) {
                    int len = edges.length();
                    VoronoiPolygon mappedArray = new VoronoiPolygon(new ArrayEx[0]);
                    for (int i = 0; i < len; ++i) {
                        VoronoiEdge.VoronoiHalfEdge currentValue = (VoronoiEdge.VoronoiHalfEdge)edges.get(i);
                        if (currentValue == null) continue;
                        VoronoiEdge.VoronoiSite s = currentValue.start();
                        mappedArray.add(new ArrayEx<Double>(s.x, s.y));
                    }
                    polygons.set(index, mappedArray);
                } else if (site.x >= x0 && site.x <= x1 && site.y >= y0 && site.y <= y1) {
                    VoronoiPolygon newPolygon = new VoronoiPolygon(new ArrayEx[0]);
                    newPolygon.push(new ArrayEx<Double>(x0, y1), new ArrayEx<Double>(x1, y1), new ArrayEx<Double>(x1, y0), new ArrayEx<Double>(x0, y0));
                    polygons.set(index, newPolygon);
                } else {
                    polygons.set(index, new VoronoiPolygon(new ArrayEx[0]));
                }
                VoronoiPolygon polygon = (VoronoiPolygon)polygons.get(index);
                polygon.point = data.get(index);
                return null;
            }
        });
        return polygons;
    }

    public <T> ArrayEx<Edge<T>> links(final ArrayEx<T> data) {
        VoronoiIndex.VoronoiDiagram diagram = VoronoiIndex.voronoi(this.voronoieContext, this.sites(data), null);
        ArrayEx<VoronoiEdge> filtered = diagram.voronoiEdges.filter(new ArrayEx.ArrayValueFunction<VoronoiEdge, Boolean>(){

            @Override
            public Boolean getValue(VoronoiEdge edge, int index, ArrayEx<VoronoiEdge> array) {
                return edge.l != null && edge.r != null;
            }
        });
        return filtered.map(new ArrayEx.ArrayValueFunction<VoronoiEdge, Edge<T>>(){

            @Override
            public Edge<T> getValue(VoronoiEdge currentValue, int index, ArrayEx<VoronoiEdge> array) {
                return new Edge(data.get(currentValue.l.i), data.get(currentValue.r.i));
            }
        });
    }

    private static double voronoiTriangleArea(VoronoiEdge.VoronoiSite a, VoronoiEdge.VoronoiSite b, VoronoiEdge.VoronoiSite c) {
        return (a.x - c.x) * (b.y - a.y) - (a.x - b.x) * (c.y - a.y);
    }

    public <T> ArrayEx<ArrayEx<T>> triangles(final ArrayEx<T> data) {
        final ArrayEx<ArrayEx<T>> triangles = new ArrayEx<ArrayEx<T>>();
        VoronoiIndex.VoronoiDiagram diagram = VoronoiIndex.voronoi(this.voronoieContext, this.sites(data), null);
        ArrayEx<VoronoiCell> cells = diagram.voronoiCells;
        cells.forEach(new ArrayEx.ArrayValueFunction<VoronoiCell, Object>(){

            @Override
            public Object getValue(VoronoiCell cell, int i, ArrayEx<VoronoiCell> array) {
                VoronoiEdge.VoronoiSite s1;
                VoronoiEdge.VoronoiSite site = cell.site;
                ArrayEx<VoronoiEdge.VoronoiHalfEdge> edges = cell.edges.sort(VoronoiCell.voronoiHalfEdgeOrder);
                int j = -1;
                int m = edges.length();
                VoronoiEdge e1 = ((VoronoiEdge.VoronoiHalfEdge)edges.get((int)(m - 1))).edge;
                VoronoiEdge.VoronoiSite voronoiSite = s1 = e1.l == site ? e1.r : e1.l;
                while (++j < m) {
                    VoronoiEdge.VoronoiSite s0 = s1;
                    e1 = ((VoronoiEdge.VoronoiHalfEdge)edges.get((int)j)).edge;
                    VoronoiEdge.VoronoiSite voronoiSite2 = s1 = e1.l == site ? e1.r : e1.l;
                    if (i >= s0.i || i >= s1.i || !(Voronoi.voronoiTriangleArea(site, s0, s1) < 0.0)) continue;
                    triangles.push(new ArrayEx<Object>(data.get(i), data.get(s0.i), data.get(s1.i)));
                }
                return null;
            }
        });
        return triangles;
    }

    public double[][] clipExtent() {
        if (this.clipExtentVal == DEFAULT_CLIPEXTENT) {
            return null;
        }
        return this.clipExtentVal;
    }

    public Voronoi clipExtent(double[][] extent) {
        this.clipExtentVal = extent == null ? DEFAULT_CLIPEXTENT : extent;
        return this;
    }

    @Deprecated
    public double[] size() {
        if (this.clipExtentVal == DEFAULT_CLIPEXTENT) {
            return null;
        }
        return this.clipExtentVal[1];
    }

    @Deprecated
    public Voronoi size(double[] size) {
        if (ObjectConverter.toBoolean(size)) {
            double[][] newClipExtentVal = new double[][]{{0.0, 0.0}, size};
            this.clipExtentVal = newClipExtentVal;
        }
        return this;
    }

    public Object x() {
        return this.xVal;
    }

    public Voronoi x(final double _xVal) {
        this.fx = new ValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return _xVal;
            }
        };
        this.xVal = _xVal;
        return this;
    }

    public Voronoi x(ValueFunction<Object, ?> xFn) {
        this.xVal = this.fx = xFn;
        return this;
    }

    public Object y() {
        return this.yVal;
    }

    public Voronoi y(final double _yVal) {
        this.fy = new ValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return _yVal;
            }
        };
        this.yVal = _yVal;
        return this;
    }

    public Voronoi y(ValueFunction<Object, ?> yFn) {
        this.yVal = this.fy = yFn;
        return this;
    }

    public static class Edge<T> {
        public T source = null;
        public T target = null;

        public Edge(T source, T target) {
            this.source = source;
            this.target = target;
        }
    }
}

