/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.internal.color;

import com.ibm.rave.core.color.Colors;
import com.ibm.rave.core.color.RGB;

public final class ContrastShift {
    private static final double DEFAULT_RATIO = 4.5;
    private static final int STEP = 25;
    private static final int MAX_RATIO = 21;
    private static final int MIN_RATIO = 1;
    private static final RGB BLACK = Colors.newRGB(0, 0, 0);
    private static final RGB WHITE = Colors.newRGB(255, 255, 255);
    private static final double BLACK_LUMINANCE = 0.0;
    private static final double WHITE_LUMINANCE = 1.0;

    private ContrastShift() {
    }

    public static RGB updateColor(RGB staticColor, RGB nonStaticColor) {
        return ContrastShift.updateColor(staticColor, nonStaticColor, 4.5);
    }

    public static RGB updateColor(RGB staticColor, RGB nonStaticColor, double contrastRatio) {
        double luminance1 = ContrastShift.getLuminance(nonStaticColor);
        double luminance2 = ContrastShift.getLuminance(staticColor);
        double ratio = ContrastShift.calculateRatio(luminance1, luminance2);
        double cRatio = contrastRatio;
        RGB color = nonStaticColor;
        if (cRatio < 1.0 || cRatio > 21.0) {
            cRatio = 4.5;
        }
        double contrastWhite = ContrastShift.calculateRatio(1.0, luminance2);
        double contrastBlack = ContrastShift.calculateRatio(0.0, luminance2);
        if (contrastWhite < cRatio && contrastBlack < cRatio) {
            return contrastWhite > contrastBlack ? WHITE : BLACK;
        }
        int step = 25 * (ContrastShift.moveDarker(luminance1, luminance2) ? -1 : 1);
        while (ratio < cRatio) {
            color = ContrastShift.shiftColor(color, step);
            luminance1 = ContrastShift.getLuminance(color);
            ratio = ContrastShift.calculateRatio(luminance1, luminance2);
            if (!(luminance1 >= 1.0) && !(luminance1 <= 0.0) || !(ratio < cRatio)) continue;
            color = nonStaticColor;
            step *= -1;
        }
        return color;
    }

    private static boolean moveDarker(double shiftingLuminance, double staticLuminance) {
        boolean darker = true;
        if (shiftingLuminance == staticLuminance) {
            darker = shiftingLuminance - 0.5 >= 0.0;
        } else if (shiftingLuminance > staticLuminance) {
            darker = false;
        }
        return darker;
    }

    public static double getLuminance(RGB rgb) {
        return 0.2126 * ContrastShift.adjustColor((double)rgb.getR() / 255.0) + 0.7152 * ContrastShift.adjustColor((double)rgb.getG() / 255.0) + 0.0722 * ContrastShift.adjustColor((double)rgb.getB() / 255.0);
    }

    private static double adjustColor(double color) {
        double adjustedColor = 0.0;
        adjustedColor = color <= 0.03928 ? color / 12.92 : Math.pow((color + 0.055) / 1.055, 2.4);
        return adjustedColor;
    }

    private static RGB shiftColor(RGB color, int amount) {
        int r = Math.max(0, Math.min(color.getR() + amount, 255));
        int g = Math.max(0, Math.min(color.getG() + amount, 255));
        int b = Math.max(0, Math.min(color.getB() + amount, 255));
        return Colors.newRGB(r, g, b);
    }

    private static double calculateRatio(double l1, double l2) {
        if (l1 >= l2) {
            return (l1 + 0.05) / (l2 + 0.05);
        }
        return (l2 + 0.05) / (l1 + 0.05);
    }
}

